/* TENUMTOP: Simple Example program for Help Access Library
             Enumerates the Contents of one Topic in the Topic-File

   (C)1996 Herd Software Development, Rudolf-Virchow-Str. 8 / 68642 Buerstadt / Germany"
*/


#include <windows.h>
#pragma argsused
#include <time.h>
#include <stdio.h>
#include "hlpacces.h"

#ifdef __WIN32__
# define _export                // Microsoft C can't stand that
#endif


/* The ENUMERATION_PRIVATE_DATA-Struktucture is just used to show how the
   Application can Transfer a Pointer to an application-defined object
   to the callback-Function by use of the lParam-Parameter.

   The HlpTopicEnumerate-Function does not stop enumeration until the
   Callback-Functions tells it to stop by returning Zero.

   In This example we want to enumerate only once Topics contents,
   so we have to cancel enumeration when the seconds topic Title is
   to be enumerated.

   So we set our marker when the First enumeration took place.
*/

typedef struct
        {
          BOOL TitleEnumerated;                /* TRUE after Title has been enumerated first */
        }
          ENUMERATION_PRIVATE_DATA, FAR *LPENUMERATIOn_PRIVATE_DATA;   

LPSTR Types[] = {
        "TOPIC_TEXT",                     /* Transfered Data is normal Topic Text */
        "TOPIC_TEXT_CONTROL",             /* Transfered Data is Additional control-code, like Carriage Return, Tab etc. */
        "TOPIC_TITLE",                    /* Transfered Data is a Topic Title ('$'-Footnote) */
        "TOPIC_TITLE_GROUP",              /* Transfered Data is the group-name in case of a Media Viewer 2.0 MVB-File */
        "TOPIC_MACRO_ENTRY",              /* Transfered Data is a Macro-String defined in a "!"-Footnote */
        "TOPIC_MACRO_HOTSPOT",            /* Transfered Data is a Macro-String defined in a Hotspot (!-Hidden Text) */
        "TOPIC_RTF_INIT",                 /* Transfered Data is additional Formatting Information in RTF-Coding.
                                                                The Data is Initialization Table Data such as \colortbl etc. and should be
                                                                contained in a Help File only once. */
        "TOPIC_RTF_TEXT",                 /* Transfered Data is additional Formatting Information in RTF-Coding. The Data is part of the Text formatting of Paragraphs, Tabels etc. */
        "TOPIC_RTF_EXIT",                 /* Transfered Data is additional Formatting Information in RTF-Coding.
                                                                The Data is Deinitialization Data, usually no more than just "}" and should be
                                                                contained in a Help File only once. */
        "TOPIC_EWX",                      /* Transfered Dats is {ewl ...}, {ewc ...}, {ewr ...} embedded Window String */
        "TOPIC_BMX",                      /* Transfered Data is {bml ...}, {bmr ...}, {bmc ...} Bitmap String. Filename: Internal File System Filename */
        "TOPIC_MCI",                      /* Transfered Data is MCI-Control string {mci ...} */
        "TOPIC_BUTTON",                   /* Transfered Data is Windows 95 {button...} string command */
        "TOPIC_CONTEXTID",                /* Transfered Data is a Context-Id (#-Footnote) */
        "TOPIC_KEYWORD",                  /* Transfered Data is a Keyword-Entry (K-Footnote) Format: Table-Name \t List of Keywords */
        "TOPIC_HOTSPOT_START",            /* Transfered Data is Hotspot at the starting-Point of the Hotspot. */
        "TOPIC_HOTSPOT_END"               /* Transfered Data is Hotspot at the ending-Point of the Hotspot. */
        };

        /* TopicEnumerationProcedure
         *
         * This is the callback-Function this application defined for the call to
         * HlpTopicEnumerate to Enumerate the TOPIC-Files contents
         */
	BOOL FAR PASCAL _export TopicEnumerationProcedure(
                LPCSTR    lpszTopicText,   // Text to be transfered to the Application program
                DWORD     dummy,           // resevred
                TEXTTYPE  eTextType,       // type of Text-String transfered to the Application
                LPARAM    lParam)          // Application-Defined user Data
	{
          LPENUMERATIOn_PRIVATE_DATA dta = (LPENUMERATIOn_PRIVATE_DATA) lParam;

          /* This printf-statment can be used to display ALL enumerated Informations including their Type */
//          printf("%08x %s:\t%s\n", dummy, Types[(int)eTextType], lpszTopicText);

          switch (eTextType)
          {
             case TOPIC_TEXT:                   // Normal Text...
             case TOPIC_TEXT_CONTROL:           // Control-Characters, like Tab, New Line...
                     printf("%s", lpszTopicText);
                     break;

             case TOPIC_TITLE:                  // Next topic's title
                     if (dta->TitleEnumerated)
                          return FALSE;         // Cancel Enumeration, No more Topics to Enumerate.
                     else
                          dta->TitleEnumerated=TRUE;
                     break;
             case TOPIC_CONTEXTID:
                     printf("-> # %s\n", lpszTopicText);
                     break;

             case TOPIC_KEYWORD:
                     printf("%s\n", lpszTopicText);       /* Keyword... */
          }

	  return TRUE;                          // Continue enumeration
	}


main(int argc, char **argv)
{ HIFS   ifs;
  HTOPIC topic;
  DWORD  TopicOffset;
  ENUMERATION_PRIVATE_DATA dta;
  memset(&dta, 0, sizeof(dta));

  if (argc>2)
  { sscanf(argv[2], "%lx", &TopicOffset);

    { ifs = IFSOpen(argv[1]);                   // Open the .HLP-File file system

      if (ifs)
      {
         topic = HlpTopicOpen(ifs, HTO_CONTEXT | HTO_KEYWORDS);          // Open TOPIC-File and load Phrases etc.
         if (topic)
         {
           printf("Enumerating contents of TopicOffset 0x%08x\n", TopicOffset);

           //------------ Enumerate the Topic ------------------------------
           HlpTopicSeek(     topic, TopicOffset);   
           HlpTopicEnumerate(topic, TopicEnumerationProcedure, (LPARAM)&dta);
           HlpTopicClose(topic);
         }
         else
           printf("HlpTopicOpen: Topic-File could not be opened. Maybe it is not a Help-File?\n");

	 IFSClose(ifs);
      } else
         printf("IFSOpen: File could not be opened\n");
    }
  }
  else
    printf("TENUMTOP: Simple Example program for Help Access Library\n"
           "          Enumerates the Contents of the Topic-File"
           "USAGE   : TENUMTOP Filename TopicOffset\n"
           "EXAMPLE : TENUMTOP c:\\windows\\winfile.hlp 00000000\n"
           "INFO    : Use example-Program TENUMTTL to retrieve valid TopicOffsets\n"
           "(C)1996 Herd Software Development, Rudolf-Virchow-Str. 8 / 68642 Buerstadt / Germany");

  return 0;
}
