#include <windows.h>
#pragma argsused
#include <time.h>
#include <stdio.h>
#include <malloc.h>
#include "hlpacces.h"

#ifdef __WIN32__
# define _export		// Microsoft C can't stand that
#endif


#define MAX_KEYWORDS 100

typedef struct
        { // --------- Command-Line Parameters -----------------
          int    KeyWordCount;
          LPSTR *KeyWords;

          // --------- Topic Access ----------------------------
          HIFS   ifs;
          HTOPIC topic;

          // --------- Search results --------------------------
          BOOL   KeyWordHasBeenFound,
                 TitleEnumerated;          // Second Title enumeration means Topic-Change
        }
        THLPGREP, FAR *LPTHLPGREP;



        /* TopicEnumerationProcedureGrep
         *
         * This is the callback-Function this application defined for the call to
         * HlpTopicEnumerate to Enumerate the TOPIC-Files contents
         *
         * This Version of the Procedure gets called when scanning a Topic for the keywords that
         * need to be found. It will not display the Data.
         */
	BOOL FAR PASCAL _export TopicEnumerationProcedureGrep(
                LPCSTR    lpszTopicText,   // Text to be transfered to the Application program
                DWORD     dummy,           // resevred
                TEXTTYPE  eTextType,       // type of Text-String transfered to the Application
                LPARAM    lParam)          // Application-Defined user Data
	{
          LPTHLPGREP thlpgrep = (LPTHLPGREP) lParam;

          switch (eTextType)
          {
             case TOPIC_TEXT:                   // Normal Text...
             case TOPIC_TEXT_CONTROL:           // Control-Characters, like Tab, New Line...
                     { int i;
                       for (i=0;i<thlpgrep->KeyWordCount && !thlpgrep->KeyWordHasBeenFound;++i)
                                  thlpgrep->KeyWordHasBeenFound=strstr(lpszTopicText,thlpgrep->KeyWords[i])!=NULL;
                     }
                     break;

             case TOPIC_TITLE:                  // Next topic's title
                     if (thlpgrep->TitleEnumerated)
                          return FALSE;         // Cancel Enumeration, No more Topics to Enumerate.
                     else
                          thlpgrep->TitleEnumerated=TRUE;

          }

	  return !thlpgrep->KeyWordHasBeenFound;// Continue enumeration
	}


        /* Callback-Procedure for Title-Enumeration */

	BOOL FAR PASCAL TitleEnumerationProcedure(LPCSTR lpszTitle, DWORD dwTopicOffset, LPARAM lParam)
	{ LPTHLPGREP thlpgrep=(LPTHLPGREP) lParam;
          HlpTopicSeek(thlpgrep->topic, dwTopicOffset);
          thlpgrep->TitleEnumerated    =
          thlpgrep->KeyWordHasBeenFound=FALSE;
          HlpTopicEnumerate(thlpgrep->topic, TopicEnumerationProcedureGrep, (LPARAM)thlpgrep);
          if (thlpgrep->KeyWordHasBeenFound)
          { printf("TopicOffset:%08lx\tTitle:\"%Fs\"\n", dwTopicOffset, lpszTitle);
          }

	  return TRUE;
	}


main(int argc, char **argv)
{ int i;
  THLPGREP thlpgrep;

  if (argc>2)
  {
    /* ------------ Shift command-line keywords in ... -----------*/
    thlpgrep.KeyWords=(LPCSTR*)malloc((argc-1)*sizeof(LPCSTR));
    for (i=0;i<argc-1;++i)
      thlpgrep.KeyWords[i]=argv[i+1];
    thlpgrep.KeyWordCount=argc-1;


    /* ------------ Let's enumerate the Titles -------------------*/
    { HIFS   ifs  = IFSOpen(argv[1]);

      if (ifs)
      {  /* ------- Let's open Topic-File for quick access -------*/
         thlpgrep.topic= HlpTopicOpen(ifs, 0);
         if (thlpgrep.topic)
         {  thlpgrep.ifs=ifs;
	    HlpEnumTitles(ifs, TitleEnumerationProcedure, (LPARAM)(LPSTR)&thlpgrep);
            HlpTopicClose(thlpgrep.topic);
         }
         else
         printf("Can't open TOPIC file, maybe this file is not a Windows Help ore Media Viewer file?\n");
	 IFSClose(ifs);
      } else
         printf("File could not be opened\n");
    }

    free(thlpgrep.KeyWords);
  }
  else
    printf("THLPGREP: Simple example program to search for Topics containing as specific word\n"
           "          Enumerates the List of Topics (|TTLBTREE) contained in a"
           "          Help or Media Viewer File."
           "Usage: THLPGREP Filename Keyword\n"
           "(C)1996 Herd Software Development, Rudolf-Virchow-Str. 8 / 68642 Buerstadt / Germany");

  return 0;
}

