#include <windows.h>
#pragma argsused
#include <time.h>
#include <stdio.h>
#include "hlpacces.h"


#ifdef __WIN32__
# define _export		// Microsoft C can't stand that
#endif

	BOOL FAR PASCAL _export IfsEnumerationProcedure(LPCSTR lpszFileName, DWORD dwTopicOffset, LPARAM lParam)
	{ HIFS     ifs=(HIFS) lParam;
          HIFSFILE hf=IFSOpenFile(ifs, lpszFileName);

          if (hf)
          {
               printf("FileOffset:0x%08lx Size:0x%08lx\tFileName:\"%Fs\"\n", dwTopicOffset, IFSSeekFile(hf,0,2), lpszFileName);
               IFSCloseFile(hf);
          }
          else printf("FileOffset:0x%08lx Access ERROR!\tFileName:\"%Fs\"\n", dwTopicOffset, lpszFileName);

	  return TRUE;
	}


main(int argc, char **argv)
{ if (argc>1)
  {
    { HIFS ifs = IFSOpen(argv[1]);

      if (ifs)
      {
	 IFSEnumerateFiles(ifs, IfsEnumerationProcedure, (LPARAM)ifs);
	 IFSClose(ifs);
      } else
         printf("File could not be opened\n");
    }


  }
  else
    printf("TIFSENU : Simple Example program for Help Access Library\n"
           "          Enumerates the List of Files (Baggage and internal) contained in a"
           "          Help internal file System."  
           "Usage: TIFSENU Filename\n"
           "(C)1996 Herd Software Development, Rudolf-Virchow-Str. 8 / 68642 Buerstadt / Germany");

  return 0;
}
