/* TMVGROUP: Simple Example program for Help Access Library
             Enumerates the Titles of all Topic in a Media Viewer 2.0 File and
             Their associated Group-Names

   (C)1996 Herd Software Development, Rudolf-Virchow-Str. 8 / 68642 Buerstadt / Germany"
*/


#include <windows.h>
#pragma argsused
#include <time.h>
#include <stdio.h>
#include "hlpacces.h"

#ifdef __WIN32__
# define _export		// Microsoft C can't stand that
#endif

LPSTR Types[] = {
        "TOPIC_TEXT",                     /* @emem Transfered Data is normal Topic Text */
        "TOPIC_TEXT_CONTROL",             /* @emem Transfered Data is Additional control-code, like Carriage Return, Tab etc. */
        "TOPIC_TITLE",                    /* @emem Transfered Data is a Topic Title ('$'-Footnote) */
        "TOPIC_TITLE_GROUP",              /* @emem Transfered Data is the group-name in case of a Media Viewer 2.0 MVB-File */
        "TOPIC_MACRO_ENTRY",              /* @emem Transfered Data is a Macro-String defined in a "!"-Footnote */
        "TOPIC_MACRO_HOTSPOT",            /* @emem Transfered Data is a Macro-String defined in a Hotspot (!-Hidden Text) */
        "TOPIC_RTF",                      /* @emem Transfered Data is additional Formatting Information in RTF-Coding */
        "TOPIC_EWX",                      /* @emem Transfered Dats is {ewl ...}, {ewc ...}, {ewr ...} embedded Window String */
        "TOPIC_MCI",                      /* @emem Transfered Data is MCI-Control string {mci ...} */
        "TOPIC_BUTTON"};                   /* @emem Transfered Data is Windows 95 {button...} string command */

        /* TopicEnumerationProcedure
         *
         * This is the callback-Function this application defined for the call to
         * HlpTopicEnumerate to Enumerate the TOPIC-Files contents
         */
	BOOL FAR PASCAL _export TopicEnumerationProcedure(
                LPCSTR    lpszTopicText,   // Text to be transfered to the Application program
                DWORD     dummy,           // resevred
                TEXTTYPE  eTextType,       // type of Text-String transfered to the Application
                LPARAM    lParam)          // Application-Defined user Data
	{

          /* This printf-statment can be used to display ALL enumerated Informations including their Type */
//            printf("%08x %s:\t%s\n", dummy, Types[(int)eTextType], lpszTopicText);



          if (eTextType==TOPIC_TITLE ||
              eTextType==TOPIC_TITLE_GROUP)
          {
            putchar(eTextType==TOPIC_TITLE ? '\n' : '\t');
            printf("%s",lpszTopicText);
          }

	  return TRUE;                          // Continue enumeration
	}


main(int argc, char **argv)
{ HIFS   ifs;
  HTOPIC topic;
  DWORD  TopicOffset;

  if (argc>2)
  { sscanf(argv[2], "%lx", &TopicOffset);

    { ifs = IFSOpen(argv[1]);                   // Open the .HLP-File file system

      if (ifs)
      {
         topic = HlpTopicOpen(ifs, 0);          // Open TOPIC-File and load Phrases etc.
         if (topic)
         {
           //------------ Enumerate the Topic ------------------------------
           HlpTopicSeek(topic, TopicOffset);
           HlpTopicEnumerate(topic, TopicEnumerationProcedure, (LPARAM)0);
           HlpTopicClose(topic);
         }
         else
           printf("HlpTopicOpen: Topic-File could not be opened. Maybe it is not a Help-File?\n");

	 IFSClose(ifs);
      } else
         printf("IFSOpen: File could not be opened\n");
    }
  }
  else
    printf("TMVGROUP: Simple Example program for Help Access Library\n"
           "          Enumerates the Titles of all Topic in a Media Viewer 2.0 File and\n"
           "          Their associated Group-Names\n"
           "          Starting with a given TopicOffset\n"
           "USAGE   : TMVGROUP Filename TopicOffset\n"
           "EXAMPLE : TMVGROUP c:\\windows\\winfile.hlp 00000000\n"
           "INFO    : Use example-Program TENUMTTL to retrieve valid TopicOffsets\n"
           "(C)1996 Herd Software Development, Rudolf-Virchow-Str. 8 / 68642 Buerstadt / Germany");

  return 0;
}