{ HLPACCES.H ---------------------------------------------------------------------
 *
 * Include-File for programs that use the Herd Software help file access
 * library HLPACC16.DLL or HLPACC32.DLL.
 *
 * (C) 1996-1997 Herd Software Development
 * Rudolf-Virchow-Str. 8/68642 Brstadt / Germany
 *
 *---------------------------------------------------------------------------------}

unit hlpacces;

interface

uses WinTypes;

{$IFDEF WIN32}
const HLPACCESS_DLL_NAME = 'HLPACC32.DLL';
{$ELSE}
const HLPACCESS_DLL_NAME = 'HLPACC16';
{$ENDIF}

{ =================== Internal Declarations ================================= }
{ Define us a Handle for opened Files... }
type
  THIFS = THandle;        { Handle to an open File-System (.HLP, .MVB or .ANN-File) }
  THIFSFILE = THandle;    { Handle to a file inside of a File-System, like a Baggage-File or a included SHG-File etc.}
  THTOPIC = THandle;      { Handle to an opened TOPIC-File retrieved vom <f HlpTopicOpen> and closed by HlpTopicClose }




{ =========== Exported File-Accessing functions ============================ }

{ IFSOpen
 *
 * Opens an existing .HLP or .MVB and reads in Header-Level Data structures
 *}
function IFSOpen(HelpFileName : PChar) : THIFS; far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}


{* IFSClose
 *
 * Closes Down .HLP-File and frees assigned Structures
 *}
procedure IFSClose(ifs : THIFS); far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}


{* @cb BOOL CALLBACK | IFSENUMPROC |
 * Application-defined callback-Function to be used for calls to <f IFSEnumerateFiles>.
 * IFSEnumerateFiles calls this function for every Filename retrieved from a file System
 *
 * LPCSTR | lpszFileName | File name of the internal File
 * DWORD  | dwFileOffset | Offset of the file in the physical Help-File
 * LPARAM | lParam       | Application-Defined parameter transfered with the call to <f IFSEnumerateFiles>
 *}
type TIFSENUMPROC = Function(lpszFileName : Pchar; dwFileOffset : LongInt; lParam : LongInt) : BOOL
                  {$IFDEF WIN32} stdcall {$ENDIF}
                  ;

{* IFSEnumerateFiles
 *
 * Enumerates the files contained in the File System.
 * Files starting with a "|"-Character are usually automatically added by the
 * Compiler, while other files are usually added by the [Baggage]
 *}

procedure IFSEnumerateFiles(ifs :THIFS; fnCallback : TIFSENUMPROC; lParam : LongInt);far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}


{* IFSOpenFile
 *
 * Opens an internal File
 *
 *}
function IFSOpenFile(ifs : THIFS; InternalFileName : PChar) : THIFSFILE;far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}


{* IFSCloseFile
 *
 * Closes an internal File
 *
 *}
procedure IFSCloseFile(ifsfile : THIFSFILE);far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}


{* IFSSeekFile
 *
 * Positions an Internal File
 *
 *}
function IFSSeekFile(ifsfile : THIFSFILE; pos : LongInt; whence : Integer) : LongInt;far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}


{* IFSReadFile
 *
 * Reads data from an internal File
 *
 *}
function IFSReadFile(ifsfile : THIFSFILE; dest : Pointer; count : LongInt) : LongInt;far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}


{* HlpGenerateHashValue
 *
 * Computes a Hash-Code that sinifies the given ContextSstring
 *}
function HlpGenerateHashValue(p : PChar) : LongInt;far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}


{* HlpIsTopic
 *
 * Tests if the given Hash-Code is in the list
 * of hash-Codes in the given File.
 *
 * Returns: TopicOffset Value, or 0xffffffff if not found.
 *}
function HlpIsTopic(ifs : THIFS; HashCode : LongInt) : LongInt;far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}



{* IsTopic
 *
 * The main Topic-Test Function
 *
 *}
Function IsTopic(FileName : PChar; ContextString : PChar) : Boolean ;far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}


{* IsSecondaryWindow
 *
 * Tests if the given Help-File contains a Definition of the diven Secondary Window-Name
 *
 *}
Function IsSecondaryWindow(FileName : PChar; WindowName : PChar) : Boolean;far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}


{* ==== Enumeration of Keywords ===================== *}

{* @cb BOOL CALLBACK | KWENUMPROC |
 * Application-defined callback-Function to be used for calls to <f HlpEnumKeyWords>.
 * HlpEnumKeyWords calls this function for every Keyword retrieved from a Help or Media Viewer File
 *
 * @rdesc The Callback-Function cancels the Enumeration by return 0, every other
 *        value continues enumeration
 *
 * LPCSTR | lpszKeyWord  | Keyword retrieved
 * DWORD  | dwDataOffset | Offset of the Keyword into the Keyword-Datafile (KWDATA, 0KWDATA or AKWDATA...)
 *                               where the TopicOffsets for use with <f HlpTopicSeek> can be retrieved
 * UINT   | uDataCount   | Number of uses of this Keyword in the File.
 * LPARAM | lParam       | Application-Defined parameter transfered with the call to <f IFSEnumerateFiles>
 *
 * @comm The Informations retrieved from the KeyWord Binary Tree contain the Keyword strings in an
 *       alphabetically sorted list and a Reference to the Keyword Data File (KWDATA, 0KWDATA, AKWDATA...)
 *
 *       The KWDATA file contains a list of DWORD-Values for the TopicOffsets linkes to the Topics
 *       that used these Keyword. To jump to a Topic using <f HlpTopicSeek> or <f HlpTopicJumpAPI>
 *       You first have to open the KWDATA-File, read the Topic-Offset(s) and use these for the Jump.
 *}
type TKWENUMPROC = Function(lpszKeyWord : Pchar; dwDataOffset : LongInt; uDataCount : cardinal; lParam : LongInt) : BOOL
                  {$IFDEF WIN32} stdcall {$ENDIF}
                  ;


{* HlpEnumKeyWords
 *
 * This Function enumerates the List of Keywords from a Help or Media Viewer
 * Tile. This Function is relatively fast.
 *
 * Note that one Help or Media Viewer file can Have several Keyword lists.
 * Usually in Help Files the Keyword list is named "KWBTREE" in Media Viewe it's
 * Named "0KWBTREE", the ALink-List in Windows 95 Files is named "AWBTREE", others are
 * also possible.
 *
 * Return Value:
 * TRUE if the Function was Successfull
 * FALSE else
 *}
function HlpEnumKeyWords(ifs : THIFS; fnKWEnumProc:TKWENUMPROC; StartKeyWord : PChar; KWListName : PChar; lParam : LongInt)
                             : Boolean;far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}






{* ==== Enumeration of Topics and Topic-Titles ====== *}

{* @cb BOOL CALLBACK | TITLEENUMPROC |
 *
 * Type-Definition for an application-supplied callback-Function
 * that will be called each time a Title has been retrieved from the
 * Help-File by the <f HlpEnumTitles> function.
 *
 * @rdesc The Callback-Function cancels the Enumeration by return 0, every other
 *        value continues enumeration
 *
 * @comm The number of enumerated Names can be huge, depending on the
 *       .MVB - or .HLP File.
 *
 * @comm The enumeration is sorted by the value of TopicOffset
 *
 * @comm As the Group-Definition Contained in a Media Viewer 2.0-File is
 *       not itself stored in the TTLBTREE internal File, this Function will
 *       not receive it. The <f HlpTopicEnumerate> Function can be used to
 *       retrieve these strings for one or all topics.
 *
 * LPCSTR | lpszTitle      | Title-String retrieved from Help-File TTLBTREE
 * LPCSTR | lpszDummy      | Dummy-String variable might eventually be used
 *                                 for Group names in the future and is currently always NULL
 * DWORD  | dwTopicOffset  | Topic-Offset into the TOPIC-File.
 * LPARAM | lParam         | Application-Defined parameter transfered to <f HlpEnumTitles>
 *}
type TTITLEENUMPROC = Function(lpszTitle : Pchar; dwTopicOffset : LongInt; lParam : LongInt) : BOOL
                  {$IFDEF WIN32} stdcall {$ENDIF}
                  ;

     {* A typical definition of this application-defined function in Delphi 2 will look
	the following:

        function TitleEnumerationProcedure(lpszTitle : Pchar; dwTopicOffset : LongInt; lParam : LongInt) ; stdcall; export;
        Begin
           writeln("Title:", lpszTitle);
           TitleEnumerationProcedure:=TRUE;
        End;
     *}


{* HlpEnumTitles
 *
 * This Function enumerates the List of titles to the application-Given
 * callback Function.
 *
 * Return Value:
 * TRUE if the Function was Successfull
 * FALSE else
 *}
Function HlpEnumTitles(ifs :THIFS; fnTitleEnumProc : TTITLEENUMPROC ;lParam : LongInt):Boolean;far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}


{* HlpGetTopicTitle
 *
 * Retrieves the Topic Title for a given TopicOffset Value.
 * The TopicOffset does not neccessarily need to point directly
 * to the start of the Topic.
 *
 * @rdesc
 * TRUE if the Function was Successfull
 * FALSE else
 *}
function HlpGetTopicTitle(
                ifs : THIFS;                    { Handle to a opened File-System opened by <f IFSOpen> }
                dwTopicOffset : LongInt;        { TopicOffset to search for }
                lpszBuffer : THIFS;             { Buffer to copy the retrieved Title String or NULL if not needed }
                uBufferSize : Cardinal;         { Size of the Bufffer in Bytes }
                lpdwTopicOffsetStart : PLongInt) { Pointer to a DWORD that will contain the TopicOffset value for the
                                                  begin of the Topic or NULL if this is not needed }
                :Boolean;far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}

{* =================== Get Help-File title informations ============================= *}


{ ---------- Get Title and Copyright ... ---------------- }
{ @struct HELPFILETITLE |
   a Memory-Object allocated and filled by <f HlpGetHelpTitle> and Freed by the
   <f HlpFreeHelpTitle>.
}
type GroupArray = Array[0..1000] of PChar;

type THELPFILETITLE = Record
           HelpTitle : PChar;           {* Title of Help-File *}
           Citation  : PChar;           {* Citation of Help-File *}
           Copyright : PChar;           {* Copyright of Help-File *}

           Version : Byte;              {* Version # of Help Compiler  *}
           Revision : Byte;             {* Revision code of Help Compiler  *}
           Flags : Word;                {* Compression-related Flag-Values *}

           GroupCount : Cardinal;       {* Number of Groups defined in an Media Viewer 2.0-File *}
           Groupnames : ^GroupArray;    {* Names and descriptions of the Groups, or NULL
                                           of no groups defined or no Media Viewer 2.0 file. *}
        End;
     PHelpFileTitle = ^THELPFILETITLE;

{* HlpGetHelpTitle
 *
 * Allocates a memory-Object with Informations read from a Help-Files SYSTEM-File
 * The memory object must be freed with HlpFreeHelpTitle afterwards.
 *}
Function HlpGetHelpTitle(ifs : THIFS) : PHelpFileTitle; far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}

Procedure HlpFreeHelpTitle(tit : PHelpFileTitle);far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}


 
{* =================== Get Help topic contents ====================================== *}

{* @enum TEXTTYPE |
 *
 * Topic text is transfered to the Application based on a Application-Defined Callback
 * procdedure. The callback-Function receives a Block of text Data from the Topic.
 *
 * The eTextType enumeration code tells the Application about the Type of Informations
 * retrieved.
 *}
type TTEXTTYPE = (

        TOPIC_TEXT,                     {* @emem Transfered Data is normal Topic Text *}
        TOPIC_TEXT_CONTROL,             {* @emem Transfered Data is Additional control-code, like Carriage Return, Tab etc. *} 
        TOPIC_TITLE,                    {* @emem Transfered Data is a Topic Title ('$'-Footnote) *}
        TOPIC_TITLE_GROUP,              {* @emem Transfered Data is the group-name in case of a Media Viewer 2.0 MVB-File,
                                                                    This does not currently apply to Media View files which
                                                                    are renamed to ".MVB", like Development Network files. *}
        TOPIC_MACRO_ENTRY,              {* @emem Transfered Data is a Macro-String defined in a "!"-Footnote *}
        TOPIC_MACRO_HOTSPOT,            {* @emem Transfered Data is a Macro-String defined in a Hotspot (!-Hidden Text) *}
        TOPIC_RTF_INIT,                 {* @emem Transfered Data is additional Formatting Information in RTF-Coding.
                                                                    The Data is Initialization Table Data such as colortbl
                                                                    etc. and should be contained in a Help File only once. *}
        TOPIC_RTF_TEXT,                 {* @emem Transfered Data is additional Formatting Information in RTF-Coding. The Data
                                                                    is part of the Text formatting of Paragraphs, Tabels etc.} 
        TOPIC_RTF_EXIT,                 {* @emem Transfered Data is additional Formatting Information in RTF-Coding.
                                                                    The Data is Deinitialization Data, usually no more than
                                                                    just "} { and should be contained in a Help File only once}
        TOPIC_EWX,                      {* @emem Transfered Dats is { ewl ...} { ewc ...} { ewr ...} {embedded Window String}
        TOPIC_BMX,                      {* @emem Transfered Data is { bml ...} { bmr ...} { bmc ...} {Bitmap String.
                                                                    Filename: Internal File System Filename *}
        TOPIC_MCI,                      {* @emem Transfered Data is MCI-Control string { mci ...}
        TOPIC_BUTTON,                   {* @emem Transfered Data is Windows 95 { button...} {string command *}
        TOPIC_CONTEXTID,                {* @emem Transfered Data is a Context-Id (#-Footnote) *}
        TOPIC_KEYWORD,                  {* @emem Transfered Data is a Keyword-Entry (K-Footnote) Format: Table-Name tab List
                                                                    of Keywords *}
        TOPIC_HOTSPOT_START,            {* @emem Transfered Data is Hotspot at the starting-Point of the Jump-Hotspot. *}
        TOPIC_HOTSPOT_END               {* @emem Transfered Data is Hotspot at the ending-Point of the Jump or Macro-Hotspot.}
        );



{* @cb BOOL CALLBACK | TOPICENUMPROC |
 *
 * Application-Defined callback-routine called by <f HlpEnumerateTopic> whenever
 * Topic-Text is to be transfered to the Application.
 *
 * @rdesc The Callback-Function cancels the Enumeration by return FALSE, every other
 *        value continues enumeration
 *}
type TTOPICENUMPROC = Function(
                lpszTopicText : PChar;     { Text to be transfered to the Application program }
                dwTopicOffset : LongInt;   { TopicOffset where these Informations have been retrieved (not exact) }
                eTextType     : TTEXTTYPE; { <t TEXTTYPE> type of Text-String transfered to the Application }
                lParam        : LongInt)   { Application-Defined user Data }
                : BOOL
                  {$IFDEF WIN32} stdcall {$ENDIF}
                  ;



{* HlpTopicOpen
 *
 * Opens the internal Help TOPIC-File and reads in and decompresses secondary
 * Tables, like Phrases, Keywords etc.
 *
 * The returned Handle need to be freed by calling <f HlpTopicClose>.
 * HlpTopicOpen is a rather slow operation, so when enumerating multiple Topics it's
 * a good idea to do them all using the same HTOPIC-Handle
 *
 * The return Value will be NULL if the File cannot be opened, for example due to
 * the fact that the IFS is not a Help-File.
 *
 * The HlpTopicEnumerate-Function does not stop enumeration until the
 * Callback-Functions tells it to stop by returning Zero.
 *
 * Flag-Values currently need to be Zero.
 *}

const HTO_FONTS    =      $00000001;             { Load Fonts-file }
const HTO_KEYWORDS =      $00000002;             { Load Keywords file }
const HTO_CONTEXT  =      $00000004;             { Load Context-File (#-footnotes) }

Function HlpTopicOpen(ifs : THIFS; flags : LongInt) : THTopic; far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}



{* HlpTopicSeek
 *
 * Positions the TOPIC-Pointer to the given TopicOffset
 *}
Procedure HlpTopicSeek(htopic : THTOPIC; TopicOffset:LongInt);far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}



{* HlpTopicEnumerate
 *
 * Enumerates a topics contents to the Application-Defined Callback function
 *
 *}
Function HlpTopicEnumerate(htopic : THTopic; fnenum : TTOPICENUMPROC; lParam : LongInt):Boolean;far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}



{* HlpTopicClose
 *
 * Closes a Handle opened by HlpTopicOpen
 *}
Procedure HlpTopicClose(topic:THTOPIC);far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}



{* ================== Jump to a Help or Media Viewer Topic ================= *}

{* HlpTopicJumpAPI
 *
 * Tries to launch Windows Help or Media Viewer 2.0 to display the
 * topic accessed with HlpTopicSeek.
 *
 * This is not always possible.
 *
 * The return Value is TRUE when the Function successfully started a Viewer,
 * it is FALSE if either the Media Viewer was not installed or the Windows
 * Help topic has no context Id to jump to.
 *
 *}
Function HlpTopicJumpAPI(lpszHelpFileName:Pchar; topic:THTOPIC): Boolean;far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}




{* @cb BOOL CALLBACK | CONTEXTNUMPROC |
 *
 * Type-Definition for an application-supplied callback-Function
 * that will be called each time a Hash-Value has been retrieved from the
 * Help-File by the <f HlpEnumContex> function.
 *
 * @rdesc The Callback-Function cancels the Enumeration by return 0, every other
 *        value continues enumeration
 *
 * @comm The enumeration is sorted by the HashValues
 *
 * DWORD  | dwHashValue    | Hashcode for the Context-ID String (#-Footnote) a valid
                             context-String for this value may be created by the <f HlpCreateStringForHashValue> function.
 * DWORD  | dwTopicOffset  | Topic-Offset into the TOPIC-File.
 * LPARAM | lParam         | Application-Defined parameter transfered to <f HlpEnumTitles>
 *}
type TCONTEXTENUMPROC = Function(dwHashValue : LongInt; dwTopicOffset : LongInt; lParam : LongInt) : BOOL
                  {$IFDEF WIN32} stdcall {$ENDIF}
                  ;

{* HlpEnumContext
 *
 * Enumerates all the Context-Id-Hash-Values defined in a Help-File
 * By reading thru all of the CONTEXT internal File.
 *
 * TRUE if enumeration has been performed successfully.
 *}
Function HlpEnumContext(
            ifs : THIFS;                      { Handle to a opened File-System opened by <f IFSOpen> }
            fnTitleEnumProc :TCONTEXTENUMPROC;{ TCONTEXTENUMPROC Application-Defined Callback-Procedure to be called for
                                                every context-Id found in the help file }
            lParam : LongInt)                 { Aplication-defined parameter to be transfered to the Callback-function }
            :Boolean; far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}

{* HlpCreateStringForHashValue
 *
 * Creates a String that has the same Hash-Code and can be used
 * to Transfer hash-code data to Winhelp as a context-String
 * for example in JumpId()-Macros and "-i"-command line Parameter.
 *}
Procedure HlpCreateStringForHashValue(
        HashValue : LongInt;                    { Hash-Code that shall be decoded }
        Buffer    : PChar);                     { Buffer for the decoded hash-Value. Minimum Size is 20 Bytes. }
        far;
                  {$IFDEF WIN32} stdcall; {$ENDIF}

{============================================================================ }
{============================================================================ }
{============================================================================ }
{============================================================================ }
{============================================================================ }

implementation
function  IFSOpen(HelpFileName : PChar) : THIFS; external HLPACCESS_DLL_NAME;
procedure IFSClose(ifs : THIFS); external HLPACCESS_DLL_NAME;
procedure IFSEnumerateFiles(ifs :THIFS; fnCallback : TIFSENUMPROC; lParam : LongInt);external HLPACCESS_DLL_NAME;
function  IFSOpenFile(ifs : THIFS; InternalFileName : PChar) : THIFSFILE;external HLPACCESS_DLL_NAME;
procedure IFSCloseFile(ifsfile : THIFSFILE);external HLPACCESS_DLL_NAME;
function  IFSSeekFile(ifsfile : THIFSFILE; pos : LongInt; whence : Integer) : LongInt;external HLPACCESS_DLL_NAME;
function  IFSReadFile(ifsfile : THIFSFILE; dest : Pointer; count : LongInt) : LongInt;external HLPACCESS_DLL_NAME;
function  HlpGenerateHashValue(p : PChar) : LongInt;external HLPACCESS_DLL_NAME;
function  HlpIsTopic(ifs : THIFS; HashCode : LongInt) : LongInt;external HLPACCESS_DLL_NAME;
Function  IsTopic(FileName : PChar; ContextString : PChar) : Boolean ;external HLPACCESS_DLL_NAME;
Function  IsSecondaryWindow(FileName : PChar; WindowName : PChar) : Boolean;external HLPACCESS_DLL_NAME;
function  HlpEnumKeyWords(ifs : THIFS; fnKWEnumProc:TKWENUMPROC; StartKeyWord : PChar; KWListName : PChar; lParam : LongInt)
                             : Boolean;external HLPACCESS_DLL_NAME;
Function  HlpEnumTitles(ifs :THIFS; fnTitleEnumProc : TTITLEENUMPROC ;lParam : LongInt):Boolean;external HLPACCESS_DLL_NAME;
function  HlpGetTopicTitle(
                ifs : THIFS;                    { Handle to a opened File-System opened by <f IFSOpen> }
                dwTopicOffset : LongInt;        { TopicOffset to search for }
                lpszBuffer : THIFS;             { Buffer to copy the retrieved Title String or NULL if not needed }
                uBufferSize : Cardinal;         { Size of the Bufffer in Bytes }
                lpdwTopicOffsetStart : PLongInt) { Pointer to a DWORD that will contain the TopicOffset value for the
                                                  begin of the Topic or NULL if this is not needed }
                :Boolean;external HLPACCESS_DLL_NAME;
Function  HlpGetHelpTitle(ifs : THIFS) : PHelpFileTitle; external HLPACCESS_DLL_NAME;
Procedure HlpFreeHelpTitle(tit : PHelpFileTitle);external HLPACCESS_DLL_NAME;
Function  HlpTopicOpen(ifs : THIFS; flags : LongInt) : THTopic; external HLPACCESS_DLL_NAME;
Procedure HlpTopicSeek(htopic : THTOPIC; TopicOffset:LongInt);external HLPACCESS_DLL_NAME;
Function  HlpTopicEnumerate(htopic : THTopic; fnenum : TTOPICENUMPROC; lParam : LongInt):Boolean;external HLPACCESS_DLL_NAME;
Procedure HlpTopicClose(topic:THTOPIC);external HLPACCESS_DLL_NAME;
Function  HlpTopicJumpAPI(lpszHelpFileName:Pchar; topic:THTOPIC): Boolean; external HLPACCESS_DLL_NAME;
Function  HlpEnumContext(
            ifs : THIFS;                      { Handle to a opened File-System opened by <f IFSOpen> }
            fnTitleEnumProc :TCONTEXTENUMPROC;{ TCONTEXTENUMPROC Application-Defined Callback-Procedure to be called for
                                                every context-Id found in the help file }
            lParam : LongInt)                 { Aplication-defined parameter to be transfered to the Callback-function }
            :Boolean; external HLPACCESS_DLL_NAME;
Procedure HlpCreateStringForHashValue(
        HashValue : LongInt;                    { Hash-Code that shall be decoded }
        Buffer    : PChar);                     { Buffer for the decoded hash-Value. Minimum Size is 20 Bytes. }
        external HLPACCESS_DLL_NAME;
end.

