{* -------------------------------------------------------------
 * An example program to show how to use the SHG Import
 * Technology from Help Access Library in a Delphi Application
 *
 * (C) 1996-1997 Herd Software Development
 * Rudolf-Virchow-Str. 8/68642 Brstadt / Germany
 * --------------------------------------------------------------}

unit Shgform;

interface
 
uses
  shgimpor,  { Help Access Library SHG Import Routine }
  seg,  { Help Access Library SHG Import Segmentation file format }
  mmsystem,

  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, StdCtrls, ExtCtrls, Grids;

type
  TForm1 = class(TForm)
    Image: TImage;
    FileName: TLabel;
    MainMenu1: TMainMenu;
    Menu: TMenuItem;
    Open1: TMenuItem;
    Hotspots: TStringGrid;
    OpenDialog: TOpenDialog;
    procedure Open1Click(Sender: TObject);
    procedure GetSegInfos(hSegInfo : THandle);
    function  ReadSHGFile(FileName : string) : THandle;
    procedure GetSHGData;
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


{ ReadSHGFile

  Load all the Data from the SHG-File into a memory-handle allocated by
  GlobalAlloc.
}
function  TForm1.ReadSHGFile(FileName : string) : THandle;
var SHGFileName : Array[0..256] of char;
    hfile       : THandle;
    mmioInfo    : TMMIOINFO;
    filesize    : longInt;
    hmem        : THandle;
    pmem        : PChar;
begin
  { Open the SHG file. }
  strPCopy(SHGFileName, FileName);
  hmem:=0;

  fillchar(mmioInfo, sizeof(mmioInfo), 0);
  hfile := mmioOpen(SHGFileName, @mmioInfo, MMIO_READ);
  if hfile<>0 then Begin
     filesize := mmioSeek(hfile, 0, 2);

     hmem := GlobalAlloc(GHND, filesize);
     if hmem<>0 then Begin
        pmem:=GlobalLock(hmem);
        mmioSeek(hfile, 0, 0);
        mmioRead(hfile, pmem, filesize);
        { OK, we've got all the file data in pmem now. }
        GlobalUnlock(hmem);
     End;

     mmioClose(hfile, 0);
  End;

  ReadSHGFile:=hmem;
end;


{ DDBFromDIB

  Convert the given Device Independend Bitmap (Practically the contents of a .BMP file
  without the TBITMAOFILEHEADER loaded into a memory handle allocated by GlobalAlloc)

  into

  A Device-Dependend Bitmap (or HBITMAP-Handle) prepared to be displayed in a Window
}
function DDBfromDIB(hdib : THandle; palette : THandle) : HBitmap;
var palcount : Cardinal;
    bitptr   ,
    bmdat    : PChar;
    bmi      : PBITMAPINFOHEADER;
    hpo      : THandle;
    DC       : HDC;
begin
  DC    := GetDC(0);
  bmdat := GlobalLock(hdib);
  bmi   := PBITMAPINFOHEADER(bmdat);
  if bmi^.biClrUsed<>0
     then palcount:=bmi^.biClrUsed
     else palcount:=(bmi^.biBitCount shl 8) and $ffff;

  bitptr := bmdat + palcount * sizeof(trgbquad)+ sizeof(tbitmapinfoheader);

  hpo := SelectPalette(DC, palette, FALSE);
  RealizePalette(DC);
  DDBFromDIB := CreateDIBitmap(DC, bmi^, CBM_INIT, bitptr, PBitmapInfo(bmi)^, DIB_RGB_COLORS);
  SelectPalette(DC, hpo, FALSE);

  ReleaseDC(0, DC);
end;


{ PaletteFromDIB

  Create a Color-Palette HPALETTE Handle for a given DIB Handle.
}
Function PaletteFromDIB(hdib : THandle) : THandle;
var bi         : PBitmapInfo;
    bih        : PBitmapInfoHeader;
    hLogPalette: THandle;
    LogPalette : PLogPalette;
    Used       : Cardinal;
    Counter    : Integer;
Begin
    PaletteFromDIB:=0;

    bi := PBitmapInfo(GlobalLock(hdib));
    bih:=@bi^.bmiHeader;
    if bih^.biBitCount<=8 then
    Begin
       if bih^.biClrImportant=0
          then
          if bih^.biClrUsed=0
             then Used:=1 shl bih^.biBitCount
             Else Used:=bih^.biClrUsed
          Else    Used:=bih^.biClrImportant
       ;

       hLogPalette:= LocalAlloc(LMEM_FIXED, sizeof(TLogPalette)+Used*sizeof(TPALETTEENTRY));
       LogPalette := PLogPalette(LocalLock(hLogPalette));
       if LogPalette<>NIL then
       Begin
          LogPalette^.palVersion:=$300;
          LogPalette^.palNumEntries:=Used;

          for Counter:=0 to Used-1 do
           with LogPalette^.palPalEntry[Counter] do
            with bi^.bmiColors[Counter] do
             Begin
               peRed   := rgbRed;
               peGreen := rgbGreen;
               peBlue  := rgbBlue;
               peFlags := 0;
             End;

          PaletteFromDIB := CreatePalette(LogPalette^);

          LocalFree(hLogPalette);
       End;
    End;

    GlobalUnlock(hdib);
End;

{ GetSegInfos

  Display the Hotspot informations retrieved from the SHG-File in a List form...
}
procedure TForm1.GetSegInfos(hSegInfo : THandle);
var Data : PChar;
    Info : PSegInfoHeader;
    i    : Integer;
    Jump : PSegJump;
    Macro: PChar;

begin
  Data := GlobalLock(hSegInfo);
  info := PSegInfoHeader(Data);
  Hotspots.RowCount:=info^.SegJumpCount+1;

  Hotspots.Cells[0,0]:='Nr.';
  Hotspots.Cells[1,0]:='Macro/Jump';
  Hotspots.Cells[2,0]:='Left';
  Hotspots.Cells[3,0]:='Top';
  Hotspots.Cells[4,0]:='Right';
  Hotspots.Cells[5,0]:='Bottom';

  for i:=0 to info^.SegJumpCount-1 do
  Begin
     Hotspots.Cells[0,i+1]:=IntToStr(i+1);
     Jump :=SegGetJump(Info, i);
     if Jump^.Macro<>0 then Begin
        Macro:=SegGetString(Info, Jump^.Macro);
        Hotspots.Cells[1,i+1]:=StrPas(Macro);
     End;
     Hotspots.Cells[2,i+1]:=IntToStr(Jump^.left);
     Hotspots.Cells[3,i+1]:=IntToStr(Jump^.top);
     Hotspots.Cells[4,i+1]:=IntToStr(Jump^.right);
     Hotspots.Cells[5,i+1]:=IntToStr(Jump^.bottom);
  End;
  GlobalUnlock(hSegInfo);
End;


{$ifdef WIN32}
{ Converts a 16-Bit Windows Metafile to a 32-Bit enhanced Metafile
  This is neccessary so Delphi 2 will be able to display it in a TImage Object
}
Function EmfFromWmf(hMetaFile : THandle; mfh : PMETAFILEHEADER) : THandle;
var BytesNeeded : LongInt;
    hemf        : THandle;
    hmem        : THandle;
    data        : PChar;
    mfp         : TMetaFilePict;
    DC          : HDC;
Begin
  hemf:=0;
  BytesNeeded := GetMetaFileBitsEx(hMetaFile, 0, NIL);
  hmem := GlobalAlloc(GHND, BytesNeeded);
  if hmem<>0 then begin
      data := GlobalLock(hmem);

      GetMetaFileBitsEx(hMetaFile, BytesNeeded, Data);
      DeleteMetaFile(hMetaFile);

      DC := GetDC(0);
      mfp.mm := MM_ANISOTROPIC;
      mfp.xExt := MulDiv(mfh^.bbox.right -mfh^.bbox.left, 2540, mfh^.inch);
      mfp.yExt := MulDiv(mfh^.bbox.bottom-mfh^.bbox.top , 2540, mfh^.inch);
      hemf := SetWinMetaFileBits(BytesNeeded, Data, DC, mfp);
      ReleaseDC(0, DC);

      GlobalUnlock(hmem);
      GlobalFree(hmem);
  end;
  EmfFromWmf:=hemf;
End;
{$endif}


procedure TForm1.GetSHGData;
var hmem        : THandle;
    SHGData     : PChar;
    DDB         : THandle;
    hDib        : THandle;
    hMetaFile   : THandle;
    MetaFileHeader : TMETAFILEHEADER;
    hSegInfo    : THandle;
    Palette : HPalette;

    mf : THandle;
Begin
  { read the SHG file into a global memor handle first. }
  hmem:=ReadSHGFile(Filename.caption);

  if hmem<>0 then begin
     SHGData := GlobalLock(hmem);
     hDib:=0;
     hMetaFile:=0;
     hSegInfo:=0;
     if SHGImport(Handle, SHGData, @hDib, @hMetaFile, @MetaFileHeader, @hSegInfo) then Begin

        if hMetaFile<>0 then Begin
           {$ifdef WIN32}
           hMetafile := EmfFromWmf(hMetaFile, @MetaFileHeader);
           {$endif}
           
           { This does not work in Delphi 1, and I don't have the faintest Idea why. Must be a Bug in Delphi VCL }
           Image.Picture.Metafile.handle:=hMetaFile;
           {$ifndef WIN32}
           Image.Picture.Metafile.width :=MetaFileHeader.bbox.right-MetaFileHeader.bbox.left;
           Image.Picture.Metafile.height:=MetaFileHeader.bbox.bottom-MetaFileHeader.bbox.top;
           Image.Picture.Metafile.inch  :=MetaFileHeader.inch;
           {$endif}
        end;


        if hdib<>0 then begin

            { Hbsche Bunte Farben machen }
            Palette       := PaletteFromDIB(hdib);
            Image.Picture.Bitmap.Palette       := Palette;

            { Leonardo-Function: Create a HBITMAP-Handle from a HDIB-Handle }
            Image.Picture.Bitmap.Handle        := DDBFromDIB(hdib, Palette);
        End;

        if hSegInfo<>0 then GetSegInfos(hSegInfo);

        if hdib<>0      then GlobalFree(hdib);
        if hSegInfo<>0  then GlobalFree(hSegInfo);
        if hmetafile<>0 then DeleteMetaFile(hmetafile);
     End;
     GlobalUnlock(hmem);
     GlobalFree(hmem);
  end;
End;  

procedure TForm1.Open1Click(Sender: TObject);
begin
    if OpenDialog.Execute Then
    Begin
         FileName.Caption:=OpenDialog.FileName;
         GetSHGData;
    End;
end;

end.
