unit Topiclst;

interface

uses
  HlpAcces,
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Menus, Grids, StdCtrls;

type
  THlpForm = class(TForm)
    Titles: TStringGrid;
    MainMenu1: TMainMenu;
    Menu: TMenuItem;
    Open1: TMenuItem;
    OpenDialog: TOpenDialog;
    FileName: TLabel;
    TopicText: TMemo;
    procedure FillTopicList;
    procedure FillTopicText(Offset : LongInt);
    procedure Open1Click(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure TitlesSelectCell(Sender: TObject; Col, Row: Longint;
      var CanSelect: Boolean);
  private
    { Private-Deklarationen }
  public
    FirstTopic : Boolean;
    { Public-Deklarationen }
  end;

var
  HlpForm: THlpForm;

implementation

{$R *.DFM}

{ This callback funcion is being used by the call to HlpEnumTitles
  in the FillTopicList Method }
function TitleEnumProc(lpszTitle : Pchar; dwTopicOffset : LongInt; lParam : LongInt) : BOOL;export;
                  {$IFDEF WIN32} stdcall; {$ENDIF}
type PHlpForm = ^THlpForm;
var  PForm : PHlpForm;
     RowCount : Integer;
begin
   PForm:=PHlpForm(lParam);
   RowCount:=PForm^.Titles.RowCount;
   PForm^.Titles.Cells[0,RowCount]:=strpas(lpszTitle);
   PForm^.Titles.Cells[1,RowCount]:=IntToHex(dwTopicOffset, 8);
   PForm^.Titles.RowCount:=RowCount+1;
   TitleEnumProc:=TRUE;
end;



{ Fill the Topic List StringGrid... }
procedure THlpForm.FillTopicList;
var  ifs : THIFS;
     HelpFileName : Array[0..256] of char;
Begin
  { Open the help file internal file System }
  strPCopy(HelpFileName, FileName.Caption);
  ifs := IFSOpen(HelpFileName);
  if ifs<>0 then Begin
     Titles.RowCount:=1;
     Titles.Cells[0,0]:='Title';
     Titles.Cells[1,0]:='Offset';
     HlpEnumTitles(ifs, TitleEnumProc, Longint(@self));
     Titles.FixedRows:=1;
     IFSClose(ifs);
  End;
End;


procedure THlpForm.Open1Click(Sender: TObject);
begin
    if OpenDialog.Execute Then
    Begin
         FileName.Caption:=OpenDialog.FileName;
         FillTopicList;
    End;
end;


{ This callback funcion is being used by the call to HlpTopicEnumerate
  in the FillTopicText Method }
Function TopicEnumProc(
                lpszTopicText : PChar;     { Text to be transfered to the Application program }
                dwTopicOffset : LongInt;   { TopicOffset where these Informations have been retrieved (not exact) }
                eTextType     : TTEXTTYPE; { <t TEXTTYPE> type of Text-String transfered to the Application }
                lParam        : LongInt)   { Application-Defined user Data }
                : BOOL ; export;
                  {$IFDEF WIN32} stdcall; {$ENDIF}
type PHlpForm = ^THlpForm;
var  PForm   : PHlpForm;
     Dest    ,
     TextBuf : PChar;
     TextLen ,
     BlkSize : Cardinal;
     FResult : Boolean;
begin
   FResult:=TRUE;
   PForm:=PHlpForm(lParam);
   case eTextType of
      TOPIC_TITLE: { Cancel Enumeration on transfer of the second topic title }
                   Begin FResult:=PForm^.FirstTopic;
                         PForm^.FirstTopic:=FALSE;
                   End;
      TOPIC_TEXT:  { Append new String to current String }
                   Begin
                      BlkSize:=PForm^.TopicText.GetTextLen +lstrlen(lpszTopicText)+2;
                      if BlkSize<48000 then Begin
                         GetMem(TextBuf, BlkSize);
                         PForm^.TopicText.GetTextBuf(TextBuf, BlkSize);
                         lstrcat(TextBuf, lpszTopicText);
                         PForm^.TopicText.SetTextBuf(TextBuf);
                         FreeMem(TextBuf, BlkSize);
                      End
                      else
                         FResult:=FALSE;
                   End;
      TOPIC_TEXT_CONTROL:
                   { Append new String to current string, Replace newLine (#10) with Carriage Return +NewLine (#13#10) }
                   Begin
                      TextLen:=PForm^.TopicText.GetTextLen;
                      BlkSize:=TextLen +2*lstrlen(lpszTopicText)+2;
                      if BlkSize<48000 then Begin
                         GetMem(TextBuf, BlkSize);
                         PForm^.TopicText.GetTextBuf(TextBuf, BlkSize);
                         Dest:=TextBuf+TextLen;
                         while lpszTopicText^ <> #0 do Begin
                            if lpszTopicText^ = #10 then Begin
                               Dest^:= #13;
                               Inc(Dest);
                            End;
                            Dest^ := lpszTopicText^;
                            Inc(Dest);
                            Inc(lpszTopicText);
                         End;
                         Dest^:=#0;
                         PForm^.TopicText.SetTextBuf(TextBuf);
                         FreeMem(TextBuf, BlkSize);
                      End
                      else
                         FResult:=FALSE;
                   End;
   End; { of case }
   TopicEnumProc:=FResult;
end;



{ Fill the Topic Text... }
procedure THlpForm.FillTopicText(Offset : LongInt);
var  ifs : THIFS;
     topic : THTOPIC;
     HelpFileName : Array[0..256] of char;
Begin
  { Open the help file internal file System }
  strPCopy(HelpFileName, FileName.Caption);
  ifs := IFSOpen(HelpFileName);
  if ifs<>0 then Begin
     { Open the Topic Handle }
     topic := HlpTopicOpen(ifs, 0);
     if topic<>0 then Begin
        HlpTopicSeek(topic, offset);

        TopicText.Text:='';
        FirstTopic:=TRUE;
        HlpTopicEnumerate(topic, TopicEnumProc, LongInt(@self));

        HlpTopicClose(topic);
     End;
     IFSClose(ifs);
  End;
End;


{ Make the Topic text as large on screen as possible }
procedure THlpForm.FormResize(Sender: TObject);
begin
   TopicText.Width := Width-10;
   TopicText.Height:= Height-50 - TopicText.top;
end;

procedure THlpForm.TitlesSelectCell(Sender: TObject; Col, Row: Longint;
  var CanSelect: Boolean);
var HexOffset : String;
    Offset    : LongInt;
begin
   HexOffset := Titles.Cells[1,row];
   Offset    := StrToInt('$'+HexOffset);
   CanSelect := TRUE;
   if Length(HexOffset)=8 then
      FillTopicText(Offset);
end;

end.
