Attribute VB_Name = "ModuleEaster"
Option Explicit

Public Function Easter(Year As Integer) As Date
'-------------------------------------------------------------
' .Name:        Easter
' .Purpose:
' Calculate the date of the Easter sunday for a given year.
'
' .Parameters:
' Year as Integer, e.g. 1997
'
' .Returns:
' Easter Sunday as Date
' .Author:     Klaus_D_Buettner@compuserve.com
' .Created:    June, 1997
' .Copyright:  Klaus D. Buettner
' .Changed:
'--------------------------------------------------------------
   Dim X%, GN%, C%, GC%, CC%, ED%, E%, Tag%, Mon%
   
   GN% = (Year Mod 19) + 1
   
   If Year > 1582 Then
      C% = Year \ 100 + 1
      GC% = Int((3 * C%) / 4) - 12
      CC% = Int((C% - 16 - (C% - 18) / 25)) / 3
      ED% = Int((5 * Year) / 4) - GC% - 10
      E% = ((11 * GN% + 19 + CC% - GC%) Mod 30) + 1
      If (E% = 25 And GN% > 11) Or E% = 24 Then E% = E% + 1
   Else
      ED% = (5 * Year) / 4
      E% = ((11 * GN% - 4) Mod 30) + 1
   End If
   
   Tag% = 44 - E%
   If Tag% < 21 Then Tag% = Tag% + 30
   Tag% = Tag% + 7 - ((ED% + Tag%) Mod 7)
   If Tag% > 31 Then
      Mon% = 4
      Tag% = Tag% - 31
   Else
      Mon% = 3
   End If
   
'   Debug.Print Year, Mon%, Tag%
   Easter = DateSerial(Year, Mon%, Tag%)
   
End Function


