'(C) BY PETER BENWAR-WAGNER
'____________________________

DECLARE FUNCTION eval (item#, decFlag%) AS DOUBLE
DECLARE FUNCTION evaluate% (TextBox AS CONTROL, label AS CONTROL, fmt$)
DECLARE FUNCTION EvalReg% ()
DECLARE FUNCTION EvalGet% (index%)
DECLARE FUNCTION UserFmt$ (t$)
DECLARE FUNCTION BasicFmt$ (t$)
DECLARE SUB EvalSet (index%)

'$INCLUDE: 'bit.bi'

OPTION EXPLICIT
DEFINT A-Z

DIM SHARED decimalSeperator, syntax, eValError
DIM SHARED expression$

' t$ is a string containing either a numeric expression or a
' format string. This function will return either a String
' that will convert to a numeric expression using BASIC's VAL-
' function or it will return a valid format-String for use with
' BASIC's format$ function.
' Disclaimer: No thousend seperators allowed!
FUNCTION BasicFmt$ (t$)
    DIM p, c$
    c$ = t$
    IF c$ = "(ohne Format)" THEN BasicFmt$ = "": EXIT FUNCTION
    IF c$ = "(no format)" THEN BasicFmt$ = "": EXIT FUNCTION
    DO
        p = INSTR(c$, ",")
        IF p THEN MID$(c$, p, 1) = "."
    LOOP WHILE p
    BasicFmt$ = c$
END FUNCTION

' This function evaluates the shared expression$
' holding an arithmetic expression.
STATIC FUNCTION eval (item#, decFlag) AS DOUBLE

DIM char, Temp$, collection$, test#

IF eValError THEN EXIT FUNCTION
DO WHILE syntax < LEN(expression$)
    syntax = syntax + 1
    Temp$ = MID$(expression$, syntax, 1)
    char = ASC(Temp$)
    SELECT CASE char
    CASE 32
    CASE 48 TO 57           ' ignore blanks
        collection$ = collection$ + Temp$
    CASE 46
        IF decFlag AND bit00 THEN
        ' we've got a fractional part already
            eValError = 2: EXIT DO
        ELSE
        ' turn on bit00 to indicate we're collecting the fractional part
            decFlag = decFlag OR bit00
            collection$ = collection$ + Temp$
        END IF
    CASE plus
        IF decFlag AND push1 THEN EXIT DO
        GOSUB collectItem
        item# = item# + eval(0#, bit01)
    CASE minus
        IF decFlag AND push1 THEN EXIT DO
        GOSUB collectItem
        item# = item# - eval(0#, bit01)
    CASE mult
        IF decFlag AND push2 THEN EXIT DO
        GOSUB collectItem
        item# = item# * eval(0#, bit02)
    CASE divis
        IF decFlag AND push2 THEN EXIT DO
        GOSUB collectItem
        test# = eval(0#, bit02)
        IF test# THEN
            item# = item# / test#
        ELSE
            eValError = 11
        END IF
    CASE expo
        IF decFlag AND push3 THEN EXIT DO
        GOSUB collectItem
        item# = item# ^ eval(0#, bit03)
    CASE brakO
        item# = eval(0#, 0)
    CASE brakC
        syntax = syntax + 1
        EXIT DO
    CASE ELSE
        eValError = 2: EXIT DO
    END SELECT
LOOP

push:
    IF LEN(collection$) THEN
        eval = VAL(collection$)
        collection$ = ""
    ELSE
        eval = item#
    END IF
    IF syntax < LEN(expression$) THEN syntax = syntax - 1

    EXIT FUNCTION

collectItem:
    IF LEN(collection$) THEN item# = VAL(collection$)
    collection$ = ""
RETURN
END FUNCTION

' This spy-function lets you see eval-settings
' Valid parameters:
' index     EvalGet-Return value
'   0       ASCII of the decimal seperator setting (either 44 or 46)
FUNCTION EvalGet (index)
    SELECT CASE index
    CASE 0
        EvalGet = decimalSeperator
    END SELECT
END FUNCTION

' Startup Function - returns true if eval-toolkit registered successfully.
' call this function only one time during startup and before calling any
' of the tookit's routines.
FUNCTION EvalReg ()
    EvalSet 0
    IF decimalSeperator THEN EvalReg = -1
END FUNCTION

SUB EvalSet (index)
    SELECT CASE index
    CASE 0
        decimalSeperator = ASC(MID$(FORMAT$(.1, "0.0"), 2, 1))
    END SELECT
END SUB

' This fills 2 combobox-controls for userdefined formatting.
' Pass the combo that holds the formatting strings as parameter a
' and the combo that holds the alignment properties as parameter b.
SUB EvalSetcboFmt (a AS CONTROL, b AS CONTROL)
IF TYPEOF a IS combobox THEN
    a.ADDITEM UserFmt$("")
    a.ADDITEM "0"
    a.ADDITEM "#"
    a.ADDITEM UserFmt$("0.00")
    a.ADDITEM UserFmt$("0.0000")
    a.ADDITEM "0%"
    a.ADDITEM "#%"
    a.ADDITEM UserFmt$("0.00%")
    a.ADDITEM UserFmt$("0.0000%")
END IF

IF TYPEOF b IS combobox THEN
SELECT CASE decimalSeperator
    CASE 44
        b.ADDITEM "linksbndig"
        b.ADDITEM "rechtsbndig"
        b.ADDITEM "zentriert"

    CASE 46
        b.ADDITEM "left justify"
        b.ADDITEM "right justify"
        b.ADDITEM "center"
END SELECT
END IF
END SUB

' This Function returns TRUE if it could evaluate the expression
' from the TextBox. It also assigns the result to the Label using
' the format from the fmt$ parameter.
FUNCTION evaluate (TextBox AS CONTROL, label AS CONTROL, fmt$)
DIM t$
IF TYPEOF TextBox IS TextBox THEN
IF TYPEOF label IS label THEN
    t$ = TextBox.Text
    expression$ = BasicFmt$(t$): syntax = 0
    eValError = 0: label.caption = FORMAT$(eval(0#, 0), BasicFmt$(fmt$))
    IF eValError THEN
    ' Return BASIC-Error-Code
        label.caption = ""
        evaluate = eValError
        TextBox.selstart = syntax - 1
        TextBox.SelLength = 1
    END IF
END IF
END IF
END FUNCTION

' t$ is a string containing either a numeric expression or a valid
' format string. According to the module variable DecimalSeperator
' the function will return a string with either a comma or a dot as
' decimal seperator. Disclaimer: No thousend seperators allowed!
FUNCTION UserFmt$ (t$)
    DIM p, c$
    c$ = t$
    IF c$ = "" THEN
        SELECT CASE decimalSeperator
        CASE 44
            c$ = "(ohne Format)"
        CASE 46
            c$ = "(no format)"
        END SELECT
    ELSE
        DO
            SELECT CASE decimalSeperator
            CASE 44
            ' seperator is: ,
                p = INSTR(c$, ".")
                IF p THEN MID$(c$, p, 1) = ","

            CASE 46
            ' seperator is: .
                p = INSTR(c$, ",")
                IF p THEN MID$(c$, p, 1) = "."
            END SELECT
        LOOP WHILE p
    END IF
    UserFmt$ = c$
END FUNCTION

