'NWBIND.BAS  NetWare Bindery Services Interface for Visual Basic For Windows
'Version 1.0
'Novell Systems Research Department, Novell, Inc.
'Copyright (c) 1993, Novell, Inc.
'This interface is not supported through Novell's regular
'support channels.  See README.TXT for more information.

'Bindery object types
Global Const OT_WILD = -1               ' Matches any type
Global Const OT_UNKNOWN = 0             ' Unknown object type
Global Const OT_USER = 1                ' The object is a "user"
Global Const OT_USER_GROUP = 2          ' A group of users
Global Const OT_PRINT_QUEUE = 3         ' Services print queues
Global Const OT_FILE_SERVER = 4         ' The object serves files
Global Const OT_JOB_SERVER = 5
Global Const OT_GATEWAY = 6
Global Const OT_PRINT_SERVER = 7
Global Const OT_ARCHIVE_QUEUE = 8
Global Const OT_ARCHIVE_SERVER = 9      ' Services backup jobs
Global Const OT_JOB_QUEUE = 10
Global Const OT_ADMINISTRATION = 11
Global Const OT_NAS_SNA_GATEWAY = 33
Global Const OT_NACS = 35
Global Const OT_REMOTE_BRIDGE_SERVER = 36
Global Const OT_BRIDGE_SERVER = 38
Global Const OT_TCPIP_GATEWAY = 39
Global Const OT_GATE = 41
Global Const OT_TIME_SYNCHRONIZATION_SERVER = 45
Global Const OT_ARCHIVE_SRV = 46
Global Const OT_ADVERTISING_PRINT_SERVER = 71
Global Const OT_BTRIEVE_VAP_NLM_5XX = 75
Global Const OT_SQL_VAP_NLM = 76
Global Const OT_XTREE_NETWORK = 77
Global Const OT_BTRIEVE_VAP_NLM_4XX = 80
Global Const OT_APPLETALK_GATEWAY = 83
Global Const OT_X25_GATEWAY = 88
Global Const OT_WAN_COPY = 114
Global Const OT_TES_NETWARE_VMS = 122
Global Const OT_NETWARE_ACCESS_SERVER = 152
Global Const OT_PORTABLE_NETWARE = 158
Global Const OT_COMPAQ_IDA_STATUS_MONITOR = 172
Global Const OT_NETWARE_386_SERVER = 263
Global Const OT_CSA_MUX = 276
Global Const OT_CSA_LCA = 277
Global Const OT_CSA_CM = 278
Global Const OT_CSA_SMA = 279
Global Const OT_CSA_DBA = 280
Global Const OT_CSA_NMA = 281
Global Const OT_CSA_SSA = 282
Global Const OT_CSA_STATUS = 283
Global Const OT_CSA_APPC = 286
Global Const OT_SNA_TEST = 294
Global Const OT_CSA_TRACE = 298
Global Const OT_COMMUNICATIONS_EXECUTIVE = 304
Global Const OT_NNS_DOMAIN = 307
Global Const OT_NNS_PROFILE = 309
Global Const OT_NNS_QUEUE = 311
Global Const OT_WORDPERFECT_NETWORK = -2184

' Bindery security definitions
Global Const BS_ANY_READ = &H0       ' Readable by anyone
Global Const BS_LOGGED_READ = &H1    ' Must be logged in to read
Global Const BS_OBJECT_READ = &H2    ' Readable by same object or super
Global Const BS_SUPER_READ = &H3     ' Readable by supervisor only
Global Const BS_BINDERY_READ = &H4   ' Readable only by the bindery
Global Const BS_ANY_WRITE = &H0      ' Writeable by anyone
Global Const BS_LOGGED_WRITE = &H10  ' Must be logged in to write
Global Const BS_OBJECT_WRITE = &H20  ' Writeable by same object or super
Global Const BS_SUPER_WRITE = &H30   ' Writeable only by the supervisor
Global Const BS_BINDERY_WRITE = &H40 ' Writeable by the bindery only

' Attributes of objects and properties in the bindery
Global Const BF_STATIC = &H0
Global Const BF_DYNAMIC = &H1
Global Const BF_ITEM = &H0
Global Const BF_SET = &H2

Type PROPERTY_VALUE
    'changed type declaration from
    'propertyValue As String * 128
    propertyValue(32) As Long
End Type

Declare Function AddBinderyObjectToSet Lib "NWNETAPI.DLL" (ByVal objectName$, ByVal objectType%, ByVal propertyName$, ByVal memberName$, ByVal memberType%) As Integer
Declare Function ChangeBinderyObjectPassword Lib "NWNETAPI.DLL" (ByVal objectName$, ByVal objectType%, ByVal oldPassword$, ByVal newPassword$) As Integer
Declare Function ChangeBinderyObjectSecurity Lib "NWNETAPI.DLL" (ByVal objectName$, ByVal objectType%, ByVal newObjectSecurity%) As Integer
Declare Function ChangePropertySecurity Lib "NWNETAPI.DLL" (ByVal objectName$, ByVal objectType%, ByVal propertyName$, ByVal newPropertySecurity%) As Integer
Declare Function CloseBindery Lib "NWNETAPI.DLL" () As Integer
Declare Function CreateBinderyObject Lib "NWNETAPI.DLL" (ByVal objectName$, ByVal objectType%, ByVal objectFlag%, ByVal objectSecurity%) As Integer
Declare Function CreateProperty Lib "NWNETAPI.DLL" (ByVal objectName$, ByVal objectType%, ByVal propertyName$, ByVal propertyFlags%, ByVal propertySecurity%) As Integer
Declare Function DeleteBinderyObject Lib "NWNETAPI.DLL" (ByVal objectName$, ByVal objectType%) As Integer
Declare Function DeleteBinderyObjectFromSet Lib "NWNETAPI.DLL" (ByVal objectName$, ByVal objectType%, ByVal propertyName$, ByVal propertyName, ByVal memberName$, ByVal memberType%) As Integer
Declare Function DeleteProperty Lib "NWNETAPI.DLL" (ByVal objectName$, ByVal objectType%, ByVal propertyName$) As Integer
Declare Function GetBinderyAccessLevel Lib "NWNETAPI.DLL" (securityAccessLevel%, objectID&) As Integer
Declare Function GetBinderyObjectDiskSpaceLeft Lib "NWNETAPI.DLL" (ByVal connectionID%, ByVal binderyObjectID%, systemElapsedTime&, unusedDiskBlocks&, restrictionEnforced%) As Integer
Declare Function GetBinderyObjectID Lib "NWNETAPI.DLL" (ByVal objectName$, ByVal objectType%, objectID&) As Integer
Declare Function GetBinderyObjectName Lib "NWNETAPI.DLL" (ByVal objectID&, ByVal objectName$, objectType%) As Integer
Declare Function IsBinderyObjectInSet Lib "NWNETAPI.DLL" (ByVal objectName$, ByVal objectType%, ByVal propertyName$, ByVal memberName$, ByVal memberType%) As Integer
Declare Function OpenBindery Lib "NWNETAPI.DLL" () As Integer
'propertyValue is a 128-byte array
Declare Function ReadPropertyValue Lib "NWNETAPI.DLL" (ByVal objectName$, ByVal objectType%, ByVal propertyName$, ByVal segmentNumber%, propertyValue As PROPERTY_VALUE, moreSegments%, propertyFlags%) As Integer
Declare Function RenameBinderyObject Lib "NWNETAPI.DLL" (ByVal objectName$, ByVal newObjectName$, ByVal objectType%) As Integer
Declare Function ScanBinderyObject Lib "NWNETAPI.DLL" (ByVal searchObjectName$, ByVal searchObjectType%, objectID&, ByVal objectName$, objectType%, objectHasProperties%, objectFlag%, objectSecurity%) As Integer
Declare Function ScanBinderyObjectTrusteePaths Lib "NWNETAPI.DLL" (ByVal objectID&, ByVal volumeNumber%, sequenceNumber%, trusteeAccessMask%, ByVal trusteePathName$) As Integer
Declare Function ScanProperty Lib "NWNETAPI.DLL" (ByVal objectName$, ByVal objectType%, ByVal searchPropertyName$, sequenceNumber&, ByVal propertyName$, propertyFlags%, propertySecurity%, propertyHasValue%, moreProperties) As Integer
Declare Function VerifyBinderyObjectPassword Lib "NWNETAPI.DLL" (ByVal objectName$, ByVal objectType%, ByVal password$) As Integer
'propertyValue is a 128-byte array
Declare Function WritePropertyValue Lib "NWNETAPI.DLL" (ByVal objectName$, ByVal objectType%, ByVal propertyName$, ByVal segmentNumber%, propertyValue As PROPERTY_VALUE, ByVal moreSegments%) As Integer

