'NWDIAG.BAS  NetWare Diagnostics Services Interface for Visual Basic For Windows
'Version 1.0
'Novell Systems Research Department, Novell, Inc.
'Copyright (c) 1993, Novell, Inc.
'This interface is not supported through Novell's regular
'support channels.  See README.TXT for more information.

Global Const MAX_NETWORKS = 120
Global Const MAX_SERVERS = 150
Global Const MAX_NODES = 120
Global Const MAX_EXCLUSIONS = 80

Global Const MAX_COMPONENTS = 10
Global Const MAX_LOCAL_NETWORKS = 4
Global Const MAX_ROUTES = 47

Global Const MAX_IPX_PACKET_SIZE = 576

Global Const IPX_SPX_COMPONENT = 0
Global Const BRIDGE_DRIVER_COMPONENT = 1
Global Const SHELL_DRIVER_COMPONENT = 2
Global Const SHELL_COMPONENT = 3
Global Const VAP_SHELL_COMPONENT = 4
Global Const BRIDGE_COMPONENT = 5
Global Const FILE_SERVER_COMPONENT = 6
Global Const NONDEDICATED_IPX_SPX_COMPONENT = 7
Global Const IPX_ONLY = 8

Global Const NO_ERRORS = &H0
Global Const COULD_NOT_GET_LOCAL_TARGET = &HFF
Global Const COULD_NOT_OPEN_SOCKET = &HFE
Global Const COULD_NOT_BEGIN_CONNECTION = &HFD
Global Const COULD_NOT_ESTABLISH_CONNECTION = &HFC
Global Const COULD_NOT_TERMINATE_CONNECTION = &HFB
Global Const BAD_CONNECTION_ID = &HFA
Global Const COULD_NOT_SEND_REQUEST = &HF9
Global Const RECEIVED_REPLY_IN_ERROR = &HF8
Global Const NETWORK_NOT_FOUND = &HEF
Global Const NO_RESPONSE_FROM_DESTINATION = &HEE
Global Const RESPONSE_COMPLETION_CODE_BAD = &HED
Global Const LIST_SIZE_TOO_SMALL = &HEC
Global Const INTERNAL_LIST_ERROR = &HEB
Global Const NODE_NOT_FOUND_OR_NO_RESPONSE = &HEA
Global Const MEMORY_ALLOCATION_ERROR = &HDF
Global Const VERSION_DOES_NOT_SUPPORT = &HDE

Type NodeAddress
    nodeHi As Long
    nodeLo As Integer
End Type

Type IPXAddress
    network As Long
    nodeAddr As NodeAddress
    socket As Integer
End Type

Type IPXHeader
    checkSum As Integer
    length As Integer
    transportControl As String * 1
    packetType As String * 1
    destination As IPXAddress
    source As IPXAddress
End Type
    
Type SPXHeader
    checkSum As Integer
    length As Integer
    transportControl As String * 1
    packetType As String * 1
    destination As IPXAddress
    source As IPXAddress
    connectionControl As String * 1
    dataStreamType As String * 1
    sourceConnectionID As Integer   'high-low unsigned
    destConnectionID As Integer     'high-low unsigned
    sequenceNumber As Integer       'high-low unsigned
    acknowledgeNumber As Integer    'high-low unsigned
    allocationNumber As Integer     'high-low unsigned
End Type

Type ECBFragment
    address As Long
    size As Integer
End Type

Type ECB
    linkAddress As Long
    esrAddress As Long
    inUseFlag As String * 1
    completionCode As String * 1
    socketNumber As Integer
    ipxWorkspace As String * 4
    driverWorkspace As String * 12
    immediateAddress As IPXAddress
    fragmentCount As Integer
    fragmentDescriptor As ECBFragment
End Type

Type CONNECTION_INFO
    connectionState As String * 1
    connectionFlags As String * 1
    sourceConnectionID As Integer           'high-low byte order
    destinationConnectionID As Integer      'hi-lo
    sequenceNumber As Integer               'hi-lo
    acknowlegeNumber As Integer             'hi-lo
    allocationNumber As Integer             'hi-lo
    remoteAcknowledgeNumber As Integer      'hi-lo
    remoteAllocationNumber As Integer       'hi-lo
    connectionSocket As Integer
    immediateAddress As IPXAddress
    destination As IPXAddress
    retransmissionCount As Integer          'hi-lo
    estimatedRoundTripDelay As Integer      'hi-lo
    retransmittedPackets As Integer         'hi-lo
    suppressedPackets As Integer            'hi-lo
End Type

Type BeginDiagnosticStruct     'same as IPXAddress
    network As Long
    nodeAddr As NodeAddress
    socket As Integer
End Type

Type AllResponseData
    completionCode As String * 1
    intervalMarker As Long
End Type

Type IPXSPXVersion
    IPXMajorVersion As String * 1
    IPXMinorVersion As String * 1
    SPXMajorVersion As String * 1
    SPXMinorVersion As String * 1
End Type

Type IPXStatisticsStruct
    sendPacketCount As Long
    malformedPacketCount As Integer
    getECBRequestCount As Long
    getECBFailureCount  As Long
    aesEventCount As Long
    postponedAESEventCount As Integer
    maxConfiguredSocketsCount As Integer
    maxOpenSocketsCount As Integer
    openSocketFailureCount As Integer
    listenECBCount As Long
    ecbCancelFailureCount As Integer
    findRouteFailureCount As Integer
End Type

Type SPXStatisticsStruct
    maxConnectionsCount As Integer
    maxUsedConnectionsCount As Integer
    establishConnectionRequest As Integer
    establishConnectionFailure As Integer
    listenConnectionRequestCount As Integer
    listenConnectionFailureCount As Integer
    sendPacketCount As Long
    windowChokeCount As Long
    badSendPacketCount As Integer
    sendFailureCount As Integer
    abortConnectionCount As Integer
    listenPacketCount As Long
    badListenPacketCount As Integer
    incomingPacketCount As Long
    badIncomingPacketCount As Integer
    suppressedPacketCount As Integer
    noSessionListenECBCount As Integer
    watchdogDestroySessionCount As Integer
End Type

Type ReturnReceivedPacketStruct
    receivedPackets As Integer
End Type

Type StartCountingPacketsStruct
    destinationSocket As Integer
End Type

Type SendPacketsRequestStruct
    target As BeginDiagnosticStruct
    immediateAddress As String * 6
    numberOfPackets As Integer
    timerTickInterval As String * 1
    packetsPerTickInterval As String * 1
    packetSize As Integer
    changeSize As Integer
End Type

Type SendPacketsResponseStruct
    numberOfTransmitErrors As Integer
End Type

Type DriverConfigurationStruct
    networkAddr As Long
    nodeAddr As NodeAddress
    lanMode As String * 1
    nodeAddressType As String * 1
    maxDataSize As Integer
    reserved1 As Integer
    lanHardwareID As String * 1
    transportTime As Integer
    reserved2 As String * 12
    majorVersion As String * 1
    minorVersion As String * 1
    ethernetFlagBits As String * 1
    selectedConfiguration As String * 1
    lanDescription As String * 80
    ioAddress1 As Integer
    ioDecodeRange1 As Integer
    ioAddress2 As Integer
    ioDecodeRange2 As Integer
    memoryAddress1 As String * 3
    memoryDecodeRange1 As Integer
    memoryAddress2 As String * 3
    memoryDecodeRange2 As String * 3
    interruptIsUsed1 As String * 1
    interruptLine1 As String * 1
    interruptIsUsed2 As String * 1
    interruptLine2 As String * 1
    dmaIsUsed1 As String * 1
    dmaLine1 As String * 1
    dmaIsUsed2 As String * 1
    dmaLine2 As String * 1
    microChannelFlagBits As String * 1
    reserved3 As String * 1
    textDescription As String * 80
End Type

Type DriverStatisticsStruct
    driverVersion As String * 2
    statisticsVersion As String * 2
    totalTxPacketCount As Long
    totalRxPacketCount As Long
    noECBAvailableCount As Integer
    packetTxTooBigCount As Integer
    packetTxTooSmallCount As Integer
    packetRxOverflowCount As Integer
    packetRxTooBigCount As Integer
    packetRxTooSmallCount As Integer
    packetTxMiscErrorCount As Integer
    packetRxMiscErrorCount As Integer
    retryTxCount As Integer
    checksumErrorCount As Integer
    hardwareRxMismatchCount As Integer
    numberOfCustomVariables As Integer
    variableData As String * 495
End Type

Type BridgeDriverStatusStruct
    boardStatus As String * 4
End Type

Type ComponentList
    components As String * 540
End Type

Type OSVersionStruct
    machineID As String * 1
    versionData As String * 41
End Type

Type PrimaryServerStruct
    number As String * 1
End Type

Type ServerAddressTableStruct
    serverUsed As String * 1
    orderNumber As String * 1
    serverNetwork As Long
    serverNode As NodeAddress
    serverSocket As Integer
    receivedTimeout As Integer
    immediateNode As NodeAddress
    sequenceNumber As String * 1
    connectionNumber As Long
    connectionOK As String * 1
    maximumTimeout As Integer
    reserved As String * 5
End Type

Type ServerNameTableStruct
    nameTable0 As String * 48
    nameTable1 As String * 48
    nameTable2 As String * 48
    nameTable3 As String * 48
    nameTable4 As String * 48
    nameTable5 As String * 48
    nameTable6 As String * 48
    nameTable7 As String * 48
End Type

Type ShellStatisticsStruct
    shellRequestsCount As Long
    operatorAbortsCount As Integer
    timeoutsCount As Integer
    writeErrorCount As Integer
    invalidReplyHeaderCount As Integer
    invalidSlotCount As Integer
    invalidSequenceNumberCount As Integer
    errorReceivingCount As Integer
    noRouterFoundCount As Integer
    beingProcessedCount As Integer
    unknownErrorCount As Integer
    invalidServerSlotCount As Integer
    networkGoneCount As Integer
    reserved As Integer
    allocateCannotFindRouteCount As Integer
    allocateNoSlotsAvailableCount As Integer
    allocateServerIsDownCount As Integer
End Type

Type ShellVersionStruct
    minor As String * 1
    major As String * 1
    rev As String * 1
End Type

Type AllKnownNetworksStruct
    numberOfNetworkAddresses As Integer
    networkAddresses(128) As Long     'up to 128 4-byte addresses
End Type

Type ServerInfoStruct
    serverType As Integer
    serverName As String * 48
End Type

Type AllKnownServersStruct
    numberOfServers As Integer
    serverInfo(50) As ServerInfoStruct
End Type

Type BridgeStatisticsStruct
    tooManyHopsCount As Integer
    unknownNetworkCount As Integer
    noSpaceForServiceCount As Integer
    noReceiveBuffersCount As Integer
    notMyNetwork As Integer
    netBIOSPropogateCount As Long
    totalPacketsServiced As Long
    totalPacketsRouted As Long
End Type

Type LOCAL_ADDRESS
    address As String * 6
    reserved As String * 2
End Type

Type LocalTablesStruct
    localNetNumbers(16) As Long '16 4-byte net numbers
    localNodeAddresses(16) As LOCAL_ADDRESS
End Type

Type RoutingInfoStruct
    routerForwardingAddress As Long
    routerBoardNumber As String * 1
    reserved As String * 2
    routeHops As String * 1
    routeTime As String * 1
End Type

Type SpecificNetworkInfoStruct
    networkAddress As Long
    hopsToNet As String * 1
    reserved  As String * 7
    routeTimeToNet As Integer
    numberOfKnownRouters As Integer
    routingInfo(47) As RoutingInfoStruct     'up to 47 structures
End Type

Type RouteSourceInfoStruct
    routeSourceAddress As NodeAddress
    routeHopsToSource As Integer
    reserved As String * 2
End Type

Type SpecificServerInfoStruct
    serverInfo As ServerInfoStruct
    serverAddress As BeginDiagnosticStruct
    hopsToServer As Integer
    reserved As Integer
    numberOfRoutes As Integer
    routeSourceInfo(47) As RouteSourceInfoStruct
End Type

Declare Function AbortSendingPackets Lib "NWIPXSPX.DLL" (ByVal connectionID%, ByVal componentNumber%) As Integer
Declare Function GetIPXSPXVersion Lib "NWIPXSPX.DLL" (ByVal connectionID%, ByVal componentNumber%, response As AllResponseData, responseData As IPXSPXVersion) As Integer
Declare Function GetIPXStatistics Lib "NWIPXSPX.DLL" (ByVal connectionID%, ByVal componentNumber%, response As AllResponseData, responseData As IPXStatisticsStruct) As Integer
Declare Function GetSPXStatistics Lib "NWIPXSPX.DLL" (ByVal connectionID%, ByVal componentNumber%, response As AllResponseData, responseData As SPXStatisticsStruct) As Integer
Declare Function ReturnReceivedPacketCount Lib "NWIPXSPX.DLL" (ByVal connectionID%, ByVal componentNumber%, response As AllResponseData, responseData As ReturnReceivedPacketStruct) As Integer
Declare Function StartCountingPkts Lib "NWIPXSPX.DLL" (ByVal connectionID%, ByVal componentNumber%, response As AllResponseData, responseData As StartCountingPacketsStruct) As Integer
Declare Function StartSendingPktsTimed Lib "NWIPXSPX.DLL" (ByVal connectionID%, ByVal componentNumber%, requestData As SendPacketsRequestStruct, response As AllResponseData, responseData As SendPacketsResponseStruct, ByVal ticks%) As Integer
Declare Function GetBridgeDriverConfiguration Lib "NWIPXSPX.DLL" (ByVal connectionID%, ByVal componentNumber%, ByVal LANBoardNumber%, response As AllResponseData, responseData As DriverConfigurationStruct) As Integer
Declare Function GetBridgeDriverStatistics Lib "NWIPXSPX.DLL" (ByVal connectionID%, ByVal componentNumber%, ByVal LANBoardNumber%, response As AllResponseData, responseData As DriverStatisticsStruct) As Integer
Declare Function GetBridgeDriverStatus Lib "NWIPXSPX.DLL" (ByVal connectionID%, ByVal componentNumber%, response As AllResponseData, responseData As BridgeDriverStatusStruct) As Integer
Declare Function GetShellDriverConfiguration Lib "NWIPXSPX.DLL" (ByVal connectionID%, ByVal componentNumber%, response As AllResponseData, responseData As DriverConfigurationStruct) As Integer
Declare Function GetShellDriverStatistics Lib "NWIPXSPX.DLL" (ByVal connectionID%, ByVal componentNumber%, response As AllResponseData, responseData As DriverStatisticsStruct) As Integer
Declare Function BeginDiagnostics Lib "NWIPXSPX.DLL" (destination As BeginDiagnosticStruct, connectionID%, compList As ComponentList) As Integer
Declare Function EndDiagnostics Lib "NWIPXSPX.DLL" (ByVal connectionID%) As Integer
Declare Function FindComponentOffset Lib "NWIPXSPX.DLL" (compList As ComponentList, ByVal componentID%) As Integer
Declare Function GetOSVersionInfo Lib "NWIPXSPX.DLL" (ByVal connectionID%, ByVal componentNumber%, response As AllResponseData, responseData As OSVersionStruct) As Integer
Declare Function GetPrimaryServerNumber Lib "NWIPXSPX.DLL" (ByVal connectionID%, ByVal componentNumber%, response As AllResponseData, responseData As PrimaryServerStruct) As Integer
Declare Function GetServerAddressTable Lib "NWIPXSPX.DLL" (ByVal connectionID%, ByVal componentNumber%, response As AllResponseData, responseData As ServerAddressTableStruct) As Integer
Declare Function GetServerNameTable Lib "NWIPXSPX.DLL" (ByVal connectionID%, ByVal componentNumber%, response As AllResponseData, responseData As ServerNameTableStruct) As Integer
Declare Function GetShellAddress Lib "NWIPXSPX.DLL" (ByVal connectionID%, ByVal componentNumber%, response As AllResponseData, responseData As IPXAddress) As Integer
Declare Function GetShellStatistics Lib "NWIPXSPX.DLL" (ByVal connectionID%, ByVal componentNumber, response As AllResponseData, responseData As ShellStatisticsStruct) As Integer
Declare Function GetShellVersionInfo Lib "NWIPXSPX.DLL" (ByVal connectionID%, ByVal componentNumber%, response As AllResponseData, responseData As ShellVersionStruct) As Integer
Declare Function GetAllKnownNetWorks Lib "NWIPXSPX.DLL" (ByVal connectionID%, ByVal componentNumber%, ByVal nextNetworkOffset%, response As AllResponseData, responseData As AllKnownNetworksStruct) As Integer
Declare Function GetAllKnownServers Lib "NWIPXSPX.DLL" (ByVal connectionID%, ByVal componentNumber%, ByVal numberServersToSkip%, response As AllResponseData, responseData As AllKnownServersStruct) As Integer
Declare Function GetBridgeStatistics Lib "NWIPXSPX.DLL" (ByVal connectionID%, ByVal componentNumber%, response As AllResponseData, responseData As BridgeStatisticsStruct) As Integer
Declare Function GetLocalTables Lib "NWIPXSPX.DLL" (ByVal connectionID%, ByVal componentNumber%, response As AllResponseData, responseData As LocalTablesStruct) As Integer
Declare Function GetSpecificNetworkInfo Lib "NWIPXSPX.DLL" (ByVal connectionID%, ByVal componentNumber%, networkAddress&, responseData As SpecificNetworkInfoStruct) As Integer
Declare Function GetSpecificServerInfo Lib "NWIPXSPX.DLL" (ByVal connectionID%, ByVal componentNumber%, server As ServerInfoStruct, response As AllResponseData, responseData As SpecificServerInfoStruct) As Integer

