VERSION 2.00
Begin Form SelectServerForm 
   Caption         =   "Attach to File Server"
   ClientHeight    =   1710
   ClientLeft      =   1095
   ClientTop       =   1485
   ClientWidth     =   6585
   Height          =   2115
   Left            =   1035
   LinkTopic       =   "Form2"
   ScaleHeight     =   1710
   ScaleWidth      =   6585
   Top             =   1140
   Width           =   6705
   Begin TextBox PasswordBox 
      Height          =   285
      Left            =   1320
      PasswordChar    =   "*"
      TabIndex        =   4
      Top             =   1200
      Width           =   3495
   End
   Begin TextBox UserNameBox 
      Height          =   285
      Left            =   1320
      TabIndex        =   3
      Top             =   720
      Width           =   3495
   End
   Begin ComboBox ServerNameBox 
      Height          =   300
      Left            =   1320
      Sorted          =   -1  'True
      TabIndex        =   2
      Top             =   240
      Width           =   3855
   End
   Begin CommandButton CancelButton 
      Caption         =   "&Cancel"
      Height          =   375
      Left            =   5520
      TabIndex        =   1
      Top             =   720
      Width           =   855
   End
   Begin CommandButton OKButton 
      Caption         =   "&OK"
      Default         =   -1  'True
      Height          =   375
      Left            =   5520
      TabIndex        =   0
      Top             =   240
      Width           =   855
   End
   Begin Label Label3 
      Alignment       =   1  'Right Justify
      Caption         =   "Password:"
      Height          =   255
      Left            =   120
      TabIndex        =   7
      Top             =   1200
      Width           =   1095
   End
   Begin Label Label2 
      Alignment       =   1  'Right Justify
      Caption         =   "User:"
      Height          =   255
      Left            =   120
      TabIndex        =   6
      Top             =   720
      Width           =   1095
   End
   Begin Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "Server:"
      Height          =   255
      Left            =   120
      TabIndex        =   5
      Top             =   240
      Width           =   1095
   End
End

Sub CancelButton_Click ()
    End
End Sub

Sub Form_Load ()
    ScanForServers

    'save the preferred connection ID, so we can restore it later
    originalPreferredServer% = GetPreferredConnectionID()

    userName$ = GetDefaultUserName()
    If (Len(userName$) = 0) Then
        MsgBox "You are not logged in to a NetWare server", MB_OK, "Error"
        End
    Else
        UserNameBox.Text = userName$
    End If

    'ServerInfoForm.UserNameLabel = userName$
End Sub

Function GetDefaultUserName () As String
'Returns a null string if the user is not logged in to any
'  NetWare file servers; otherwise returns the user's
'  username on the default file server

    Dim loginTime As DATE_AND_TIME

    connectionNumber& = GetConnectionNumber()
    userName$ = String$(48, 0)
    cCode% = GetConnectionInformation(connectionNumber&, userName$, objectType%, objectID&, loginTime)
    If (cCode% = SUCCESSFUL) Then
        GetDefaultUserName = userName$
    Else
        GetDefaultUserName = ""
    End If
End Function

Sub OKButton_Click ()
    userName$ = UCase$(UserNameBox.Text)
    serverName$ = UCase$(ServerNameBox.Text)
    password$ = UCase$(PasswordBox.Text)
    ServerInfoForm.Show
End Sub

Sub ScanForServers ()
    oID& = -1   'initialize object ID to -1 for first call to ScanBinderyObject
    Do
        serverName$ = String$(48, 0)
        cCode% = ScanBinderyObject("*", OT_FILE_SERVER, oID&, serverName$, oType%, oHasProps%, oFlag%, oSecurity%)
        If (cCode% = SUCCESSFUL) Then
            
            'take all characters of object name up to terminating null
            serverName$ = Left$(serverName$, InStr(serverName$, Chr$(0)) - 1)

            ServerNameBox.AddItem serverName$
        End If
    Loop Until cCode%
End Sub

