Attribute VB_Name = "CopyFile"
Option Explicit
Declare Function OpenFile Lib "kernel32" (ByVal lpFileName As String, lpReOpenBuff As OFSTRUCT, ByVal wStyle As Long) As Long

'Open File Flags
Public Const OF_READ As Long = &H0&
Public Const OF_WRITE As Long = &H1&
Public Const OF_CREATE As Long = &H1000&

Declare Function llseek Lib "kernel32" Alias "_llseek" (ByVal hFile As Long, ByVal lOffset As Long, ByVal iOrigin As Long) As Long
Declare Function lclose Lib "kernel32" Alias "_lclose" (ByVal hFile As Long) As Long
Declare Function GlobalAlloc Lib "kernel32" (ByVal wFlags As Long, ByVal dwBytes As Long) As Long
Declare Function GlobalFree Lib "kernel32" (ByVal hMem As Long) As Long
Declare Function GlobalLock Lib "kernel32" (ByVal hMem As Long) As Long
Declare Function GlobalUnlock Lib "kernel32" (ByVal hMem As Long) As Long

Public Const GMEM_MOVEABLE As Long = &H2&
Public Const GMEM_ZEROINIT As Long = &H40&
Public Const GHND As Long = (GMEM_MOVEABLE Or GMEM_ZEROINIT)

Declare Function hread Lib "kernel32" Alias "_hread" (ByVal hFile As Long, lpBuffer As Any, ByVal lBytes As Long) As Long
Declare Function hwrite Lib "kernel32" Alias "_hwrite" (ByVal hFile As Long, lpBuffer As Any, ByVal lBytes As Long) As Long

Public Const OFS_MAXPATHNAME As Long = 128&
Public Type OFSTRUCT
    cBytes As Byte
    fFixedDisk As Byte
    nErrCode As Integer
    Reserved1 As Integer
    Reserved2 As Integer
    szPathName(OFS_MAXPATHNAME) As Byte
End Type

Dim g_OF As OFSTRUCT

Const HFILE_ERROR = -1

Function APICopyFile(InFile$, OutFile$)
  '********************************************************
   '  InFile$ is the source file full path and file name
   '  OutFile$ is the target file full path and file name
   '
   '  CopyFile returns "true" if copy completes successfully
   '  and "false" if there is an error.
   '
   '  Based on Articel Copying Files Quickly Using Global Memory
   '  From the Visual Basic Starter Kit
   '  See also "Copying Files Quickly Using Global Memory.rtf"
   '********************************************************

    Dim inHndl&
    Dim fail&
    Dim Size&
    Dim msg&
    Dim OutHndl&
    Dim memHndl&
    Dim memAddr&
    Dim inBytes&
    Dim outBytes&
    Dim ok&
    
    
          '// open source file
          inHndl& = OpenFile(InFile$, g_OF, OF_READ)
          If inHndl& = HFILE_ERROR Then
               fail& = 1
               GoTo CopyError
          End If

          '// get size of source file
          Size& = llseek(inHndl&, 0, 2)

          '// reset file pointer to start of file
          msg& = llseek(inHndl&, 0, 0)

          '// Open target file
          OutHndl& = OpenFile(OutFile$, g_OF, OF_CREATE Or OF_WRITE)
          If OutHndl& = HFILE_ERROR Then
               fail& = 2
               GoTo CopyError
          End If
          
          '// allocate needed global memory
          memHndl& = GlobalAlloc(GHND, Size&)
          If memHndl& = 0 Then
               fail& = 3
               GoTo CopyError
          End If

          '// lock global memory
          memAddr& = GlobalLock(memHndl&)

          '// read source file into global memory
          inBytes& = hread(inHndl&, ByVal memAddr&, Size&)
          If inBytes& <> Size& Then
               fail& = 4
               GoTo CopyError
          End If

          '// write global memory to target file (alles 30544)
          outBytes& = hwrite(OutHndl&, ByVal memAddr&, Size&)
          If outBytes& <> Size& Then
               fail& = 5
               GoTo CopyError
          End If

          '// close source and target
          ok& = lclose(inHndl&)
          ok& = lclose(OutHndl&)

          '// unlock and free global memory
          ok& = GlobalUnlock(memHndl&)
          ok& = GlobalFree(memHndl&)
          ok& = DoEvents()

          '// set COPYFILE exit code
          APICopyFile = HFILE_ERROR
          Exit Function

CopyError:

          '// clean up if there was an error
          ok& = lclose(inHndl&)
          ok& = lclose(OutHndl&)
          ok& = GlobalUnlock(memHndl&)
          ok& = GlobalFree(memHndl&)
          ok& = DoEvents()

          '// return failure code to calling proc
          APICopyFile = fail&

End Function


