VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "cTips"
Attribute VB_Creatable = False
Attribute VB_Exposed = False
' Class Name:   cTips.cls - From VBPJ page 100, October 1995, Deborah Kurata
' Author:       Deborah Kurata, InStep Technologies
' Modified by:  Larry Rebich, The Bridge, Inc. 71662,205
' Date:         95/06/09 - Deborah
'               95/09/17 - Larry
' Description:  Maintains the collection of tips
' Revisions:
'
    Option Explicit
' Public: **********************************
' Public data members

' Private: *********************************
' Private data members

' Define the collection of tips
    Private m_colTips As New Collection
    
Public Function Add(sText As String) As cTip
' Add a tip to the collection
' PropertiesL
' sText     string description of the tip
' Returns:
' tipNew    tip object
    Dim tipNew As New cTip
    Static iID As Integer
    With tipNew                     'generate a unique ID
        iID = iID + 1
        .ID = "T" & Format$(iID, "00000")
        .Text = sText               'set the properties
        m_colTips.Add tipNew, .ID   'add it to the collection
    End With
    Set Add = tipNew                'return the one that was added
End Function
Public Function Count() As Long
' Provide a count of the number in the collection
    Count = m_colTips.Count
End Function
Public Sub Delete(vKey As Variant)
' Delete the member from the collection.
' Parameters:
' vKey      key or index of member to delete
    m_colTips.Remove vKey           'delete it
End Sub
Public Function NextTip() As String
' Return the next tip
    Static iLast As Integer     'save last one
    iLast = iLast + 1
    If iLast > Me.Count Or iLast < 1 Then
        iLast = 1
    End If
    NextTip = m_colTips(iLast).Text & TipNumber(iLast)
End Function
Public Function RandomTip() As String
' Return a random description
    Dim iRandom As Integer
    Randomize                       'seed the random number generator
    iRandom = Int((Me.Count) * Rnd + 1) 'get a random number
    RandomTip = m_colTips(iRandom).Text & TipNumber(iRandom)    'return the random tip
End Function
Private Function TipNumber(iTheNumber As Integer) As String
' Add the number to the message
    TipNumber = Chr$(13) & Chr$(13) & "Tip " & iTheNumber
End Function
Private Sub Class_Initialize()
    ' Set several tips - "hard coded"
    Me.Add "Beware of ghosts and goblins in your code."
    Me.Add "Watch for the wicked glitch of the west."
    Me.Add "Check all Halloween candy before eating it."
    Me.Add "Classes are ""the foundation of object-oriented programming in Visual Basic.""  Building and using them can help you develop solid, maintainable apps."
End Sub
