VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.1#0"; "COMDLG32.OCX"
Begin VB.Form frmGlobe 
   BackColor       =   &H00000000&
   Caption         =   "Direct3D Globe Sample"
   ClientHeight    =   3195
   ClientLeft      =   165
   ClientTop       =   735
   ClientWidth     =   4680
   LinkTopic       =   "Form1"
   ScaleHeight     =   3195
   ScaleWidth      =   4680
   StartUpPosition =   3  'Windows Default
   Begin MSComDlg.CommonDialog dlg 
      Left            =   720
      Top             =   120
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   327680
   End
   Begin VB.Timer Timer1 
      Enabled         =   0   'False
      Interval        =   1
      Left            =   120
      Top             =   120
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuApplyTexture 
         Caption         =   "Apply texture"
      End
      Begin VB.Menu mnu01 
         Caption         =   "-"
      End
      Begin VB.Menu mnuFileExit 
         Caption         =   "E&xit"
      End
   End
End
Attribute VB_Name = "frmGlobe"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' Based on the DirectX SDK retained mode tutorial...

' Define TEXTURE as True to use texture mapping
' Define TEXTURE as False to use material

#Const Texture = True

'Private Declare Function DirectDrawCreateClipper Lib "ddraw" (ByVal dwFlags As Long, ByRef lplpDDCLipper As IUnknown, ByVal lng2 As Long) As Long

Const pi = 3.14159265358979

Dim D3DRM As Direct3DRM
Dim Scene As Direct3DRMFrame
Dim Camera As Direct3DRMFrame
Dim Clipper As DirectDrawClipper
Dim Device As Direct3DRMDevice
Dim Viewport As Direct3DRMViewPort
Dim LightFrame As Direct3DRMFrame
Dim WorldFrame As Direct3DRMFrame
Dim Light As Direct3DRMLight
Dim Globe As Direct3DRMMeshBuilder
Dim Material As Direct3DRMMaterial
Dim Distance As Long
Sub ApplyTexture(MeshBuilder As Direct3DRMMeshBuilder, ByVal strTextureFileName As String)
    Dim Box As D3DRMBOX
    Dim MaxY As Single
    Dim MinY As Single
    Dim Height As Single
    Dim Wrap As Direct3DRMWrap
    Dim Texture As Direct3DRMTexture
    ' Bounding box
    MeshBuilder.GetBox Box
    MaxY = Box.Max.y
    MinY = Box.Min.y
    Height = MaxY - MinY
    D3DRM.CreateWrap D3DRMWRAP_CYLINDER, Nothing, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, MinY / Height, 1, -1 / Height, Wrap
    Wrap.Apply MeshBuilder
    D3DRM.LoadTexture strTextureFileName, Texture
    MeshBuilder.SetTexture Texture
End Sub
' Create a sphere (probably to improve)
Sub CreateSphere(objMeshBuilder As Direct3DRMMeshBuilder)
    Dim aVertices(1 To 1000) As D3DVECTOR
    Dim aNormals(0) As D3DVECTOR
    Dim aFaces(1 To 10000) As Long
    Dim intVertices As Long
    Const stepA = 10
    Const stepB = 10
    Dim axeZ As D3DVECTOR
    Dim origine As D3DVECTOR
    With origine
        .x = 0
        .y = 1
        .z = 0
    End With
    axeZ.x = 0
    axeZ.y = 0
    axeZ.z = 1
    Dim AxeY As D3DVECTOR
    AxeY.x = 0
    AxeY.y = 1
    AxeY.z = 0
    'aFaces(0) = 180 / stepA
    intVertices = 1
    Dim i As Integer
    Dim j As Integer
    Dim tmp As D3DVECTOR
    For i = stepA To 180 - stepA Step stepA
    For j = 0 To 360 - stepB Step stepB
            D3DRMVectorRotate tmp, origine, axeZ, i * pi / 180
            D3DRMVectorRotate aVertices(intVertices), tmp, AxeY, j * pi / 180
            intVertices = intVertices + 1
        Next
    Next
    intVertices = intVertices - 1
    Dim Index As Integer
    Index = 1
    For i = stepA To 180 - 2 * stepA Step stepA
        Dim FirstIndex As Long
        FirstIndex = Index
        For j = 0 To 360 - stepB Step stepB
            aFaces(Index) = 4
            aFaces(Index + 1) = (Index \ 5) + 1
            aFaces(Index + 2) = (Index \ 5)
            aFaces(Index + 3) = ((Index \ 5) + (360 \ stepB))
            aFaces(Index + 4) = (Index \ 5) + 1 + (360 \ stepB)
            If j = 360 - stepB Then
                aFaces(Index + 1) = FirstIndex \ 5  '+ 1
                aFaces(Index + 4) = FirstIndex \ 5 + (360 \ stepB)
            End If
            Index = Index + 5
        Next
    Next
    'Index = 1
    aFaces(Index) = (360 / stepB) - 1
    Index = Index + 1
    For i = 1 To (360 / stepB) - 1
        aFaces(Index) = i
        Index = Index + 1
    Next
    aFaces(Index) = 360 / stepB
    Index = Index + 1
    For i = 0 To (360 / stepB) - 1
        aFaces(Index) = intVertices - i - 1
        Index = Index + 1
    Next
    aFaces(Index) = 0
    objMeshBuilder.AddFaces intVertices, aVertices(1), 0, aNormals(0), aFaces(1), Nothing
End Sub
Private Sub Form_KeyPress(KeyAscii As Integer)
    Select Case Chr$(KeyAscii)
        Case "+"
            Distance = Distance + 1
        Case "-"
            Distance = Distance - 1
    End Select
    On Error Resume Next
    WorldFrame.SetPosition Scene, 0, 0, Distance
End Sub
Private Sub Form_Load()
    Distance = 15
    Direct3DRMCreate D3DRM
    
    ' Create the scene
    D3DRM.CreateFrame Nothing, Scene
    
    ' Create the camera
    D3DRM.CreateFrame Scene, Camera
    Camera.SetPosition Scene, 0, 0, 0
    
    DirectDrawCreateClipper 0&, Clipper, Nothing
    Clipper.SetHWnd 0, Me.hWnd
    D3DRM.CreateDeviceFromClipper Clipper, 0&, 320, 200, Device
    D3DRM.CreateViewport Device, Camera, 0, 0, 320, 200, Viewport
    Viewport.SetBack 5000
    Device.SetQuality D3DRMLIGHT_ON Or D3DRMFILL_SOLID Or D3DRMSHADE_GOURAUD
    
    ' Create the light frame
    D3DRM.CreateFrame Scene, LightFrame
    D3DRM.CreateFrame Scene, WorldFrame
    D3DRM.CreateLightRGB D3DRMLIGHT_DIRECTIONAL, 0.8, 0.8, 0.8, Light
    LightFrame.AddLight Light
    
    Dim light2 As Direct3DRMLight
    
    D3DRM.CreateLightRGB D3DRMLIGHT_AMBIENT, 0.15, 0.15, 0.15, light2
    Scene.AddLight light2
    Scene.SetSceneFogMode D3DRMFOG_EXPONENTIAL
    Scene.SetSceneFogEnable True
    
        
    LightFrame.SetPosition Scene, 0, 0, 0
    LightFrame.SetRotation Scene, 0, 1, 0, 0.05
    
    
    Camera.SetPosition Scene, 0, 0, 0
    Camera.SetOrientation Scene, 0, 0, 1, 0, 1, 0
    
    WorldFrame.SetPosition Scene, 0, 0, 15
    WorldFrame.SetOrientation Scene, 0, 0, 1, 0, 1, 0
    WorldFrame.SetRotation Scene, 1, 1, 1, 0.17 '0.05
    
    D3DRM.CreateMeshBuilder Globe
    CreateSphere Globe
    
    Globe.[Scale] 1, 1, 1
    Globe.SetColorRGB 1, 1, 1
    Globe.GenerateNormals
    
    
    ApplyTexture Globe, App.Path & "\globe.bmp"
    ' Save the object
    Globe.Save "Globe.x", D3DRMXOF_BINARY, 0
        

    '#Else
    '    Globe.SetColorRGB 0.1, 0.1, 1
    '    objD3DRM.CreateMaterial 5, objMaterial
    '    With objMaterial
    '        .SetEmissive 0.3, 0.3, 0.3
    '        .SetSpecular 1, 1, 1
    '    End With
    '    Globe.SetMaterial objMaterial
    '#End If
    
    WorldFrame.AddVisual Globe
    Set LightFrame = Nothing
    'Set Globe = Nothing
    Set Light = Nothing
    Me!Timer1.Enabled = True
End Sub
Private Sub Form_Unload(Cancel As Integer)
    Me!Timer1.Enabled = False
    Set WorldFrame = Nothing
    Set Scene = Nothing
    Set Camera = Nothing
    Set Viewport = Nothing
    Set Device = Nothing
    Set D3DRM = Nothing
    Set Clipper = Nothing
End Sub

Private Sub mnuApplyTexture_Click()
    With dlg
        .Filter = "Texture file (*.bmp)|*.bmp"
        .ShowOpen
        If .filename <> "" Then ApplyTexture Globe, .filename
    End With
End Sub

Private Sub Timer1_Timer()
    On Error Resume Next
    Scene.Move 1
    Viewport.Clear
    Viewport.Render Scene
    Device.Update
End Sub


