VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "CSymbolTable"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'CSymbolTable - Symbol table classe for Visual Basic 5
'Copyright (c) 1995-97 SoftCircuits Programming (R)
'Redistributed by Permission.
'
'This table is used by the CEval class. It's simply a wrapper for
'a standard collection to make it easy to store a list of symbols
'and associated values.
'
'This program may be distributed on the condition that it is
'distributed in full and unchanged, and that no fee is charged for
'such distribution with the exception of reasonable shipping and media
'charged. In addition, the code in this program may be incorporated
'into your own programs and the resulting programs may be distributed
'without payment of royalties.
'
'This example program was provided by:
' SoftCircuits Programming
' http://www.softcircuits.com
' P.O. Box 16262
' Irvine, CA 92623
Option Explicit

'Private collection to hold symbol values
Private m_Symbols As New Collection

'Add a symbol to the symbol table
'Raises run-time error if symbol already exists or if nValue is not numeric
Public Sub Add(sName As String, nValue As Variant)
    If IsSymbolDefined(sName) = False Then
        If IsNumeric(nValue) Then
            m_Symbols.Add nValue, sName
        Else
            Err.Raise vbObjectError + 1020, , "Invalid symbol value"
        End If
    Else
        Err.Raise vbObjectError + 1021, , "Symbol already defined"
    End If
End Sub

'Delete the specified symbol from the symbol table
'If the symbol is not defined, the call is ignored
Public Sub Delete(sName As String)
    If IsSymbolDefined(sName) Then
        m_Symbols.Remove sName
    End If
End Sub

'Indicates if the specified symbol name is currently defined
Public Function IsSymbolDefined(sName As String) As Boolean
    Dim nValue As Variant
    On Error Resume Next
    nValue = m_Symbols(sName)
    If Err Then
        IsSymbolDefined = False
    Else
        IsSymbolDefined = True
    End If
End Function

'Sets the value of the specified symbol
'Raises a run-time error if the symbol is not currently defined or
'if the value is non-numeric
Public Property Let Value(sName As String, nValue As Variant)
    If IsSymbolDefined(sName) = True Then
        If IsNumeric(nValue) Then
            Delete sName
            Add sName, nValue
        Else
            Err.Raise vbObjectError + 1020, , "Invalid symbol value"
        End If
    Else
        Err.Raise vbObjectError + 1022, , "Symbol not defined"
    End If
End Property

'Returns the value for the specified symbol
'Raises a run-time error if the symbol is not currently defined
Public Property Get Value(sName As String) As Variant
    If IsSymbolDefined(sName) = True Then
        Value = m_Symbols(sName)
    Else
        Err.Raise vbObjectError + 1022, , "Symbol not defined"
    End If
End Property

'Returns the number of symbols in table
Public Property Get Count() As Integer
    Count = m_Symbols.Count
End Property

