VERSION 5.00
Begin VB.Form frmNum2Text 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Number to Text Demonstration"
   ClientHeight    =   2895
   ClientLeft      =   1125
   ClientTop       =   1515
   ClientWidth     =   4200
   ForeColor       =   &H80000008&
   LinkTopic       =   "Form1"
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   2895
   ScaleWidth      =   4200
   StartUpPosition =   2  'CenterScreen
   Begin VB.TextBox txtResult 
      BackColor       =   &H8000000F&
      Height          =   1215
      Left            =   120
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   5
      Top             =   1080
      Width           =   3975
   End
   Begin VB.CommandButton cmdExit 
      BackColor       =   &H80000005&
      Cancel          =   -1  'True
      Caption         =   "E&xit"
      Height          =   375
      Left            =   2280
      TabIndex        =   4
      Top             =   2400
      Width           =   1455
   End
   Begin VB.CommandButton cmdConvert 
      BackColor       =   &H80000005&
      Caption         =   "&Convert"
      Default         =   -1  'True
      Height          =   375
      Left            =   480
      TabIndex        =   3
      Top             =   2400
      Width           =   1455
   End
   Begin VB.TextBox txtNumber 
      Height          =   285
      Left            =   120
      TabIndex        =   1
      Text            =   "1234.56"
      Top             =   360
      Width           =   3975
   End
   Begin VB.Label Label2 
      Caption         =   "Result:"
      Height          =   255
      Left            =   120
      TabIndex        =   2
      Top             =   840
      Width           =   1215
   End
   Begin VB.Label Label1 
      Caption         =   "&Number:"
      Height          =   255
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   1215
   End
End
Attribute VB_Name = "frmNum2Text"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'Num2Text - VB5 Conversion Demo
'Copyright (c) 1994-97 SoftCircuits Programming (R)
'Redistributed by permission.
'
'This program demonstrates how to convert a number to text. This demo
'converts numbers to a format you might see in a check writing program. For
'example, 123.1 is converted to "One hundred twenty-three and 10/100".
'
'This program may be distributed on the condition that it is
'distributed in full and unchanged, and that no fee is charged for
'such distribution with the exception of reasonable shipping and media
'charged. In addition, the code in this program may be incorporated
'into your own programs and the resulting programs may be distributed
'without payment of royalties.
'
'This example program was provided by:
' SoftCircuits Programming
' http://www.softcircuits.com
' P.O. Box 16262
' Irvine, CA 92623
Option Explicit

Private Sub cmdConvert_Click()
    txtResult = NumToText(Val(txtNumber))
    txtNumber.SelStart = 0
    txtNumber.SelLength = Len(txtNumber)
    txtNumber.SetFocus
End Sub

Private Sub cmdExit_Click()
    Unload Me
End Sub

Private Function NumToText(dblVal As Double) As String
    Static Ones(0 To 9) As String
    Static Teens(0 To 9) As String
    Static Tens(0 To 9) As String
    Static Thousands(0 To 4) As String
    Static bInit As Boolean
    Dim i As Integer, bAllZeros As Boolean, bShowThousands As Boolean
    Dim strVal As String, strBuff As String, strTemp As String
    Dim nCol As Integer, nChar As Integer

    'Only handles positive values
    Debug.Assert dblVal >= 0

    If bInit = False Then
        'Initialize array
        bInit = True
        Ones(0) = "zero"
        Ones(1) = "one"
        Ones(2) = "two"
        Ones(3) = "three"
        Ones(4) = "four"
        Ones(5) = "five"
        Ones(6) = "six"
        Ones(7) = "seven"
        Ones(8) = "eight"
        Ones(9) = "nine"
        Teens(0) = "ten"
        Teens(1) = "eleven"
        Teens(2) = "twelve"
        Teens(3) = "thirteen"
        Teens(4) = "fourteen"
        Teens(5) = "fifteen"
        Teens(6) = "sixteen"
        Teens(7) = "seventeen"
        Teens(8) = "eighteen"
        Teens(9) = "nineteen"
        Tens(0) = ""
        Tens(1) = "ten"
        Tens(2) = "twenty"
        Tens(3) = "thirty"
        Tens(4) = "forty"
        Tens(5) = "fifty"
        Tens(6) = "sixty"
        Tens(7) = "seventy"
        Tens(8) = "eighty"
        Tens(9) = "ninety"
        Thousands(0) = ""
        Thousands(1) = "thousand"   'US numbering
        Thousands(2) = "million"
        Thousands(3) = "billion"
        Thousands(4) = "trillion"
    End If
    'Trap errors
    On Error GoTo NumToTextError
    'Get fractional part
    strBuff = "and " & Format((dblVal - Int(dblVal)) * 100, "00") & "/100"
    'Convert rest to string and process each digit
    strVal = CStr(Int(dblVal))
    'Non-zero digit not yet encountered
    bAllZeros = True
    'Iterate through string
    For i = Len(strVal) To 1 Step -1
        'Get value of this digit
        nChar = Val(Mid$(strVal, i, 1))
        'Get column position
        nCol = (Len(strVal) - i) + 1
        'Action depends on 1's, 10's or 100's column
        Select Case (nCol Mod 3)
            Case 1  '1's position
                bShowThousands = True
                If i = 1 Then
                    'First digit in number (last in loop)
                    strTemp = Ones(nChar) & " "
                ElseIf Mid$(strVal, i - 1, 1) = "1" Then
                    'This digit is part of "teen" number
                    strTemp = Teens(nChar) & " "
                    i = i - 1   'Skip tens position
                ElseIf nChar > 0 Then
                    'Any non-zero digit
                    strTemp = Ones(nChar) & " "
                Else
                    'This digit is zero. If digit in tens and hundreds column
                    'are also zero, don't show "thousands"
                    bShowThousands = False
                    'Test for non-zero digit in this grouping
                    If Mid$(strVal, i - 1, 1) <> "0" Then
                        bShowThousands = True
                    ElseIf i > 2 Then
                        If Mid$(strVal, i - 2, 1) <> "0" Then
                            bShowThousands = True
                        End If
                    End If
                    strTemp = ""
                End If
                'Show "thousands" if non-zero in grouping
                If bShowThousands Then
                    If nCol > 1 Then
                        strTemp = strTemp & Thousands(nCol \ 3)
                        If bAllZeros Then
                            strTemp = strTemp & " "
                        Else
                            strTemp = strTemp & ", "
                        End If
                    End If
                    'Indicate non-zero digit encountered
                    bAllZeros = False
                End If
                strBuff = strTemp & strBuff
            Case 2  '10's position
                If nChar > 0 Then
                    If Mid$(strVal, i + 1, 1) <> "0" Then
                        strBuff = Tens(nChar) & "-" & strBuff
                    Else
                        strBuff = Tens(nChar) & " " & strBuff
                    End If
                End If
            Case 0  '100's position
                If nChar > 0 Then
                    strBuff = Ones(nChar) & " hundred " & strBuff
                End If
        End Select
    Next i
    'Convert first letter to upper case
    strBuff = UCase$(Left$(strBuff, 1)) & Mid$(strBuff, 2)
EndNumToText:
    'Return result
    NumToText = strBuff
    Exit Function
NumToTextError:
    strBuff = "#Error#"
    Resume EndNumToText
End Function

