VERSION 2.00
Begin Form Form1 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   Caption         =   "SocketWrench HTTP"
   ClientHeight    =   4635
   ClientLeft      =   2310
   ClientTop       =   2250
   ClientWidth     =   7110
   Height          =   5040
   Left            =   2250
   LinkTopic       =   "Form1"
   ScaleHeight     =   4635
   ScaleWidth      =   7110
   Top             =   1905
   Width           =   7230
   Begin CommandButton RetrieveButton 
      Caption         =   "Retrieve"
      Default         =   -1  'True
      Height          =   375
      Left            =   2760
      TabIndex        =   7
      Top             =   4080
      Width           =   1335
   End
   Begin TextBox SourceView 
      Height          =   3015
      Left            =   120
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   6
      TabStop         =   0   'False
      Top             =   840
      Width           =   6855
   End
   Begin TextBox ResourcePath 
      Height          =   285
      Left            =   960
      TabIndex        =   5
      Text            =   "/"
      Top             =   480
      Width           =   5055
   End
   Begin TextBox ServerPort 
      Height          =   285
      Left            =   5160
      TabIndex        =   3
      Text            =   "80"
      Top             =   120
      Width           =   855
   End
   Begin TextBox Hostname 
      Height          =   285
      Left            =   960
      TabIndex        =   1
      Top             =   120
      Width           =   3375
   End
   Begin Socket Socket1 
      AutoResolve     =   -1  'True
      Backlog         =   1
      Binary          =   -1  'True
      Blocking        =   -1  'True
      Broadcast       =   0   'False
      BufferSize      =   0
      HostAddress     =   ""
      HostFile        =   ""
      HostName        =   ""
      InLine          =   0   'False
      Interval        =   0
      KeepAlive       =   0   'False
      Left            =   6360
      Linger          =   0
      LocalPort       =   0
      LocalService    =   ""
      Protocol        =   0
      RemotePort      =   0
      RemoteService   =   ""
      ReuseAddress    =   0   'False
      Route           =   -1  'True
      SocketType      =   1
      Timeout         =   0
      Top             =   120
   End
   Begin Label Label3 
      BackStyle       =   0  'Transparent
      Caption         =   "P&ath:"
      Height          =   255
      Left            =   120
      TabIndex        =   4
      Top             =   480
      Width           =   735
   End
   Begin Label Label2 
      BackStyle       =   0  'Transparent
      Caption         =   "&Port:"
      Height          =   255
      Left            =   4560
      TabIndex        =   2
      Top             =   120
      Width           =   495
   End
   Begin Label Label1 
      BackStyle       =   0  'Transparent
      Caption         =   "&System:"
      Height          =   255
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   735
   End
End

Sub Form_Load ()
    '
    ' Initialize the socket control
    '
    Socket1.AddressFamily = AF_INET
    Socket1.Binary = True
    Socket1.Blocking = True
    Socket1.BufferSize = 1024
    Socket1.Protocol = IPPROTO_TCP
    Socket1.SocketType = SOCK_STREAM
    Socket1.RemotePort = IPPORT_HTTP
End Sub

Sub RetrieveButton_Click ()
    Dim RemoteHost As String, RemoteService As String
    Dim Resource As String, HttpCmd As String, HttpBuf As String

    RemoteHost = Trim$(HostName.Text)
    If Len(RemoteHost) = 0 Then
        MsgBox "A remote host name is required"
        HostName.SetFocus
        Exit Sub
    End If

    Resource = Trim$(ResourcePath.Text)
    If Len(Resource) = 0 Then
        MsgBox "A resource path must be specified"
        ResourcePath.SetFocus
        Exit Sub
    End If

    RetrieveButton.Enabled = False
    Screen.MousePointer = 11 ' Hourglass

    On Error Resume Next
    Socket1.HostName = RemoteHost
    If Err <> 0 Then
        Screen.MousePointer = 0
        MsgBox "The specified host is unknown"
        RetrieveButton.Enabled = True
        HostName.SetFocus
        Exit Sub
    End If
    On Error GoTo 0

    RemoteService = Trim$(ServerPort.Text)
    If Len(RemoteService) = 0 Then
        Socket1.RemotePort = IPPORT_HTTP
    Else
        Socket1.RemoteService = RemoteService
        If Err <> 0 Then
            Screen.MousePointer = 0
            MsgBox "The specified service name is invalid"
            RetrieveButton.Enabled = True
            ServerPort.SetFocus
            Exit Sub
        End If
    End If

    '
    ' Clear text box that will contain the HTML document
    '
    SourceView.Text = ""
    
    '
    ' Attempt connection to remote host
    '
    Socket1.Action = SOCKET_CONNECT

    If Not Socket1.Connected Then
        Screen.MousePointer = 0
        MsgBox "Unable to connect to remote server, error " & Socket1.LastError
        RetrieveButton.Enabled = True
        Exit Sub
    End If

    '
    ' Create command to retrieve document
    '
    HttpCmd = "GET " + Resource + Chr$(13) + Chr$(10)
    
    '
    ' Send command to HTTP server
    '
    On Error Resume Next
    Socket1.SendLen = Len(HttpCmd)
    Socket1.SendData = HttpCmd
    If Err <> 0 Then
        Screen.MousePointer = 0
        MsgBox "Unable to send data to remote server"
        Socket1.Action = SOCKET_CLOSE
        RetrieveButton.Enabled = True
        Exit Sub
    End If
    
    '
    ' Read document returned by server
    '
    Do While Not Socket1.IsClosed
        Socket1.RecvLen = 256
        HttpBuf = Socket1.RecvData
        If Socket1.RecvLen > 0 Then
            SourceView.SelStart = 65535
            SourceView.SelLength = 0
            SourceView.SelText = HttpBuf
        End If
    Loop

    '
    ' Close connection
    '
    Socket1.Action = SOCKET_CLOSE
    Screen.MousePointer = 0
    RetrieveButton.Enabled = True
End Sub

