VERSION 2.00
Begin Form MainForm 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "SocketWrench TCP"
   ClientHeight    =   4035
   ClientLeft      =   1905
   ClientTop       =   1950
   ClientWidth     =   7095
   FontBold        =   0   'False
   FontItalic      =   0   'False
   FontName        =   "MS Sans Serif"
   FontSize        =   8.25
   FontStrikethru  =   0   'False
   FontUnderline   =   0   'False
   Height          =   4725
   Left            =   1845
   LinkTopic       =   "Form1"
   ScaleHeight     =   4035
   ScaleWidth      =   7095
   Top             =   1320
   Width           =   7215
   Begin Socket Socket2 
      AutoResolve     =   -1  'True
      Backlog         =   1
      Binary          =   -1  'True
      Blocking        =   -1  'True
      Broadcast       =   0   'False
      BufferSize      =   0
      HostAddress     =   ""
      HostFile        =   ""
      HostName        =   ""
      InLine          =   0   'False
      Interval        =   0
      KeepAlive       =   0   'False
      Left            =   600
      Linger          =   0
      LocalPort       =   0
      LocalService    =   ""
      Protocol        =   0
      RemotePort      =   0
      RemoteService   =   ""
      ReuseAddress    =   0   'False
      Route           =   -1  'True
      SocketType      =   1
      Timeout         =   0
      Top             =   3480
   End
   Begin Socket Socket1 
      AutoResolve     =   -1  'True
      Backlog         =   1
      Binary          =   -1  'True
      Blocking        =   -1  'True
      Broadcast       =   0   'False
      BufferSize      =   0
      HostAddress     =   ""
      HostFile        =   ""
      HostName        =   ""
      InLine          =   0   'False
      Interval        =   0
      KeepAlive       =   0   'False
      Left            =   120
      Linger          =   0
      LocalPort       =   0
      LocalService    =   ""
      Protocol        =   0
      RemotePort      =   0
      RemoteService   =   ""
      ReuseAddress    =   0   'False
      Route           =   -1  'True
      SocketType      =   1
      Timeout         =   0
      Top             =   3480
   End
   Begin CommandButton CancelButton 
      Caption         =   "Cancel"
      Height          =   375
      Left            =   4080
      TabIndex        =   11
      Top             =   3480
      Width           =   1215
   End
   Begin CommandButton ActionButton 
      Caption         =   "Connect"
      Height          =   375
      Left            =   1800
      TabIndex        =   10
      Top             =   3480
      Width           =   1215
   End
   Begin TextBox SocketInput 
      BackColor       =   &H00FFFFFF&
      Height          =   285
      Left            =   120
      TabIndex        =   9
      Top             =   3000
      Width           =   6855
   End
   Begin ListBox SocketOutput 
      BackColor       =   &H00C0C0C0&
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "Courier New"
      FontSize        =   9.75
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   1230
      Left            =   120
      TabIndex        =   8
      Top             =   1680
      Width           =   6855
   End
   Begin Frame ServiceFrame 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Service"
      Height          =   1455
      Left            =   3600
      TabIndex        =   13
      Top             =   120
      Width           =   3375
      Begin SpinButton Spin1 
         Delay           =   150
         Height          =   285
         Left            =   1560
         Top             =   840
         Width           =   255
      End
      Begin TextBox ServicePort 
         BackColor       =   &H00FFFFFF&
         Height          =   285
         Left            =   840
         TabIndex        =   7
         Top             =   840
         Width           =   735
      End
      Begin TextBox ServiceName 
         BackColor       =   &H00FFFFFF&
         Height          =   285
         Left            =   840
         TabIndex        =   5
         Top             =   480
         Width           =   2175
      End
      Begin Label Label4 
         BackStyle       =   0  'Transparent
         Caption         =   "&Port:"
         Height          =   255
         Left            =   120
         TabIndex        =   6
         Top             =   840
         Width           =   495
      End
      Begin Label Label3 
         BackStyle       =   0  'Transparent
         Caption         =   "&Name:"
         Height          =   255
         Left            =   120
         TabIndex        =   4
         Top             =   480
         Width           =   615
      End
   End
   Begin Frame RemoteFrame 
      BackColor       =   &H00C0C0C0&
      Caption         =   "System"
      Height          =   1455
      Left            =   120
      TabIndex        =   12
      Top             =   120
      Width           =   3375
      Begin ComboBox Hostname 
         BackColor       =   &H00FFFFFF&
         Height          =   300
         Left            =   1200
         Sorted          =   -1  'True
         TabIndex        =   1
         Top             =   480
         Width           =   1935
      End
      Begin TextBox IPAddress 
         BackColor       =   &H00FFFFFF&
         Height          =   285
         Left            =   1200
         TabIndex        =   3
         Top             =   840
         Width           =   1575
      End
      Begin Label Label2 
         BackStyle       =   0  'Transparent
         Caption         =   "IP &Address:"
         Height          =   255
         Left            =   120
         TabIndex        =   2
         Top             =   840
         Width           =   1095
      End
      Begin Label Label1 
         BackStyle       =   0  'Transparent
         Caption         =   "&Hostname:"
         Height          =   255
         Left            =   120
         TabIndex        =   0
         Top             =   480
         Width           =   975
      End
   End
   Begin Menu FileMenu 
      Caption         =   "&File"
      Begin Menu ExitApp 
         Caption         =   "E&xit"
      End
   End
   Begin Menu OptionsMenu 
      Caption         =   "&Options"
      Begin Menu ServerOption 
         Caption         =   "Echo Server"
      End
   End
End
Option Explicit

Sub ActionButton_Click ()
    If Not Socket1.Connected Then
        On Error Resume Next
        HostName.Text = Trim$(HostName.Text)
        IPAddress.Text = Trim$(IPAddress.Text)
        If Len(HostName.Text) > 0 Then
            Socket1.HostName = HostName.Text
            IPAddress.Text = Socket1.HostAddress
        ElseIf Len(IPAddress.Text) > 0 Then
            Socket1.HostAddress = Trim$(IPAddress.Text)
            HostName.Text = Socket1.HostName
        Else
            MsgBox "No system name or address specified"
            Exit Sub
        End If
        ServiceName.Text = Trim$(ServiceName.Text)
        ServicePort.Text = Trim$(ServicePort.Text)
        If Len(ServiceName.Text) > 0 Then
            Socket1.RemoteService = ServiceName.Text
            ServicePort.Text = Trim$(Str$(Socket1.RemotePort))
        ElseIf Len(ServicePort) > 0 Then
            Socket1.RemotePort = Val(Trim$(ServicePort.Text))
            ServiceName.Text = Socket1.RemoteService
        Else
            MsgBox "No service name or port specified"
            Exit Sub
        End If
        Socket1.LocalPort = IPPORT_ANY
        Socket1.Action = SOCKET_CONNECT
        If Err <> 0 Then Exit Sub
        ActionButton.Enabled = False
        ActionButton.Default = False
    Else
        Socket1.Action = SOCKET_CLOSE
        ActionButton.Caption = "Connect"
        ActionButton.Default = True
        HostName.SetFocus
    End If
    Exit Sub
End Sub

Sub CancelButton_Click ()
    Unload MainForm
End Sub

Sub ExitApp_Click ()
    Unload MainForm
End Sub

Sub Form_Load ()
    Dim Host As String

    '
    ' Initialize the socket control
    '
    Socket1.AddressFamily = AF_INET
    Socket1.Binary = False
    Socket1.Blocking = False
    Socket1.BufferSize = 1024
    Socket1.Protocol = IPPROTO_IP
    Socket1.SocketType = SOCK_STREAM
    Socket1.RemoteService = "echo"

    Socket2.AddressFamily = AF_INET
    Socket2.Binary = True
    Socket2.Blocking = False
    Socket2.HostAddress = INADDR_ANY
    Socket2.Protocol = IPPROTO_IP
    Socket2.SocketType = SOCK_STREAM
    Socket2.LocalService = "echo"
    
    '
    ' Initialize hostname combo box
    '
    On Error Resume Next
    Socket1.HostFile = "HOSTS"
    If Err = 0 Then
        Host$ = Socket1.GetFirstHost
        While Host$ <> ""
            HostName.AddItem Host$
            Host$ = Socket1.GetNextHost
        Wend
    End If
    Socket1.HostFile = ""

    '
    ' Initialize the other controls
    '
    ActionButton.Caption = "Connect"
    ActionButton.Default = True
    ActionButton.Enabled = False
    ServiceName.Text = Socket1.RemoteService
    ServicePort.Text = Trim$(Str$(Socket1.RemotePort))
End Sub

Sub Form_Unload (Cancel As Integer)
    If Socket1.Connected Then Socket1.Action = SOCKET_CLOSE
    If Socket2.Listening Or Socket2.Connected Then Socket2.Action = SOCKET_CLOSE
    End
End Sub

Sub Hostname_Change ()
    If Len(HostName.Text) > 0 Or Len(IPAddress.Text) > 0 Then
        ActionButton.Enabled = True
    Else
        ActionButton.Enabled = False
    End If
End Sub

Sub Hostname_GotFocus ()
    HostName.SelStart = 0
    HostName.SelLength = Len(HostName.Text)
End Sub

Sub Hostname_KeyPress (KeyAscii As Integer)
    IPAddress.Text = ""
End Sub

Sub IPAddress_Change ()
    If Len(HostName.Text) > 0 Or Len(IPAddress.Text) > 0 Then
        ActionButton.Enabled = True
    Else
        ActionButton.Enabled = False
    End If
End Sub

Sub IPAddress_GotFocus ()
    IPAddress.SelStart = 0
    IPAddress.SelLength = Len(IPAddress.Text)
End Sub

Sub IPAddress_KeyPress (KeyAscii As Integer)
    HostName.Text = ""
End Sub

Sub ServerOption_Click ()
    If Not Socket2.Connected Then
        ServerOption.Checked = Not ServerOption.Checked
        If ServerOption.Checked Then
            Socket2.Action = SOCKET_LISTEN
        Else
            Socket2.Action = SOCKET_CLOSE
        End If
    End If
End Sub

Sub ServiceName_GotFocus ()
    ServiceName.SelStart = 0
    ServiceName.SelLength = Len(ServiceName.Text)
End Sub

Sub ServiceName_KeyPress (KeyAscii As Integer)
    ServicePort.Text = ""
End Sub

Sub ServicePort_GotFocus ()
    ServicePort.SelStart = 0
    ServicePort.SelLength = Len(ServicePort.Text)
End Sub

Sub ServicePort_KeyPress (KeyAscii As Integer)
    ServiceName.Text = ""
    If KeyAscii > Asc("9") Then
        KeyAscii = 0
        Beep
    ElseIf KeyAscii >= Asc("0") And Len(ServicePort.Text) > 5 Then
        KeyAscii = 0
        Beep
    End If
End Sub

Sub Socket1_Connect ()
    MainForm.MousePointer = 0
    ActionButton.Caption = "Close"
    ActionButton.Enabled = True
    SocketInput.SetFocus
End Sub

Sub Socket1_Disconnect ()
    Socket1.Action = SOCKET_CLOSE
    ActionButton.Caption = "Connect"
    ActionButton.Default = True
    HostName.SetFocus
End Sub

Sub Socket1_LastError (ErrCode As Integer, ErrMsg As String, Response As Integer)
    If Socket1.Action = SOCKET_CONNECT Then
        MsgBox ErrMsg, 0, "Connect"
        Response = SOCKET_ERRIGNORE
        Socket1.Action = SOCKET_CLOSE
        ActionButton.Caption = "Connect"
        ActionButton.Default = True
        ActionButton.Enabled = True
        Exit Sub
    End If
End Sub

Sub Socket1_Read (DataLength As Integer, IsUrgent As Integer)
    Dim sBuffer As String, nEol As Integer

    Socket1.RecvLen = DataLength
    sBuffer = Socket1.RecvData

    nEol = InStr(sBuffer, Chr$(13))
    If nEol > 0 Then
        sBuffer = Mid$(sBuffer, 1, nEol - 1)
    End If

    SocketOutput.AddItem sBuffer
    SocketOutput.ListIndex = SocketOutput.ListCount - 1
    SocketOutput.Selected(SocketOutput.ListIndex) = False
End Sub

Sub Socket2_Accept (SocketId As Integer)
    Socket2.Action = SOCKET_ACCEPT
End Sub

Sub Socket2_Disconnect ()
    Socket2.Action = SOCKET_CLOSE
    If ServerOption.Checked Then
        Socket2.ReuseAddress = True
        Socket2.Action = SOCKET_LISTEN
    End If
End Sub

Sub Socket2_Read (DataLength As Integer, IsUrgent As Integer)
    Socket2.RecvLen = DataLength
    Socket2.SendLen = DataLength
    Socket2.SendData = Socket2.RecvData
End Sub

Sub SocketInput_KeyPress (KeyAscii As Integer)
    If KeyAscii = 13 Then
        KeyAscii = 0
        Socket1.SendLen = Len(SocketInput.Text) + 2
        Socket1.SendData = SocketInput.Text & Chr(13) & Chr(10)
        SocketInput.Text = ""
    End If
End Sub

Sub Spin1_SpinDown ()
    Dim Value As Integer

    Value = Val(ServicePort.Text) - 1
    If Value >= 0 Then
        Socket1.RemotePort = Value
        ServiceName.Text = Socket1.RemoteService
        ServicePort.Text = Trim(Str(Value))
    Else
        Beep
    End If
End Sub

Sub Spin1_SpinUp ()
    Dim Value As Integer

    Value = Val(ServicePort.Text) + 1
    If Value > 0 Then
        Socket1.RemotePort = Value
        ServiceName.Text = Socket1.RemoteService
        ServicePort.Text = Trim(Str(Value))
    Else
        Beep
    End If
End Sub

