/*****************************************************************************
*                                                                            *
* Copyright (c) 1996-1997 Funduc Software Inc.   All rights reserved.        *
*                                                                            *
* These programs are the sole property of Funduc Software Inc. and contain   *
* proprietary information.  These routines should not by used by anyone      *
* except Funduc Software Inc.'s customers in accoordance with terms of a     *
* license.  To get one, visit us at http://home.sprynet.com/sprynet/funduc   *
* or http://ourworld.compuserve.com/homepages/funduc                         *
* or E-MAIL: funduc@sprynet.com or 102372.2530@compuserve.com                *
*                                                                            *
*****************************************************************************/

#ifndef DECENC_H
#define DECENC_H

#ifdef __cplusplus
extern "C"
{
#endif

/* Possible values for the nType parameter passed to EncodeFile() and return code from DecodeFile */
#define NONE_TYPE        0
#define UUE_TYPE         1
#define B64_TYPE         2
#define BINHEX_TYPE      3

/* Possible values for the nPrompt parameter to Decode File() */
#define PROMPT_ALL       0   /* DLL prompts for everything */
#define PROMPT_NONE      1   /* No prompts, file names passed in are used */
#define PROMPT_OVERWRITE 2   /* DLL only prompts for overwrites */

/* How many files are encoded */
int WINAPI GetNumFilesToDecode(LPCSTR szInFile);
/* 0 relative index into the array of names (see call above) */
int WINAPI GetEncodedFile(LPSTR szOutFile, int nIndex);
/* If PROMPT_NONE is used for nPrompt, the names of the files to decode are assumed to be in
   the strOutFile parameter.  That can be accomplished by calling DecodeFile() with nPrompt set to
   PROMPT_GET_FILES first. */
/* Return code is one of the Encoding types above */
int WINAPI DecodeFile(LPCSTR strInFile, LPCSTR szOutFile, int nPrompts);
/* nAppend should be 0 to overwrite the output file, 1 to append (to encode more than one file
   for example */
int WINAPI EncodeFile(LPCSTR strFileIn, LPCSTR szFileOut, int nType, BOOL bAppend); 
/* call with the name of registered application to write that to the encoded file */
void WINAPI SetEncodingApplication(LPCSTR szInFile);

/*
For 16-bit VB programming, use this code

Declare Function GetNumFilesToDecode Lib "DECENC16.DLL" (ByVal strInFile As String) As Integer
Declare Function GetEncodedFile Lib "DECENC16.DLL" (ByVal strOutFile As String, ByVal nIndex As Integer) As Integer

Declare Function EncodeFile Lib "DECENC16.DLL" (ByVal SourceFile As String, ByVal EncodedFile As String, ByVal CodeOption As Integer, ByVal xAppend As Integer) As Integer
Declare Function DecodeFile Lib "DECENC16.DLL" (ByVal strInFile As String, ByVal strOutFile As String, ByVal nPrompts As Integer) As Integer
Declare Sub SetEncodingApplication  Lib "DECENC16.DLL" (ByVal strInFile As String)
Global Const PROMPT_ALL = 0        ' DLL prompts for everything 
Global Const PROMPT_NONE = 1       ' No prompts, file names passed in are used 
Global Const PROMPT_OVERWRITE = 2  ' DLL only prompts for overwrites 
Global Const UUE = 1               ' UUENCODE 
Global Const MIME = 2              ' Base64(MIME)

Private Sub NoPrompts_Click()
    Dim x As Integer, FilesInIt As Integer
    Dim dummy As Integer
    Dim FileToDecode As String * 256
    Dim DecodedFile As String, DecodeType As Integer
    Dim FileList As String
    CommonDialog1.Filter = "AllFiles|*.*"
    CommonDialog1.ShowOpen
    FileToDecode = CommonDialog1.filename
    FilesInIt = GetNumFilesToDecode(FileToDecode)
    List1.Clear
    'I put the files into a List box
    For x = 0 To FilesInIt - 1
        dummy = GetEncodedFile(FileToDecode, x)
        List1.AddItem (FileToDecode)
    Next
    'until this it is working fine
    For x = 0 To FilesInIt - 1
        FileList = FileList + List1.List(x)
        If x < FilesInIt - 1 Then
            FileList = FileList + ";"
        End If
    Next
    dummy = DecodeFile(FileToDecode, FileList, PROMPT_NONE)

End Sub

For 32 bit VB, use these declares:

Declare Function GetNumFilesToDecode Lib "DECENC32.DLL" (ByVal strInFile As String) As Integer
Declare Function GetEncodedFile Lib "DECENC32.DLL" (ByVal strOutFile As String, ByVal nIndex As Long) As Integer

Declare Function EncodeFile Lib "DECENC32.DLL" (ByVal SourceFile As String, ByVal EncodedFile As String, ByVal CodeOption As Integer, ByVal xAppend As Integer) As Integer
Declare Function DecodeFile Lib "DECENC32.DLL" (ByVal strInFile As String, ByVal strOutFile As String, ByVal nPrompts As Integer) As Integer
Declare Sub SetEncodingApplication  Lib "DECENC32.DLL" (ByVal strInFile As String)
Global Const PROMPT_ALL = 0        ' DLL prompts for everything 
Global Const PROMPT_NONE = 1       ' No prompts, file names passed in are used 
Global Const PROMPT_OVERWRITE = 2  ' DLL only prompts for overwrites 
Global Const UUE = 1               ' UUENCODE 
Global Const MIME = 2              ' Base64(MIME)

*/

#ifdef __cplusplus
}
#endif

#endif
