/*** balloon.c ***

   Demonstrates the use of two BalloonHelp functions.

   No copyrights claimed. Donated to the public domain.

   Author:
      Alfons Hoogervorst

   E-mail:
      2:500/121.6252 (Fido)
      a.hoogervorst@dosgg.nl (Internet)

   BBS:
      DOSBoss West aka The C Programmers Board. Syshost Alex Stienstra
      31-20-6124530, V32b,V42b,CM,XA, 8 data bits, no parity, 1 stop bitt

   Necessary files:
      golfiery.h     -  prototypes of Golfiery functions
      resource.h     -  resource definitions
      balloon.rc     -  resource script for balloon
      balloon.def    -  balloon module definition file
      golfiery.dll   -  Golfiery DLL
      golfiery.lib   -  Import library

   Last revised:
      March/April, 1995

   Remarks:
      Use smart callbacks.
*******************/

#include <windows.h>
#include <golfiery.h>
#include "resource.h"

#define DLGCLASSNAME          "AhiiDialogDialogBalloon"
#define BALLOONDLL            "golfiery.dll"

#define NEWBALLOONCLASSNAME   "Ahii_NewBalloon"

HINSTANCE   _hInst;
WNDPROC     _lpfnOldProc;
HWND        _hwndMain;

HFONT       _hFontTitle, _hFontText;
char        _szTitle[255], _szText[1024];

WORD        _wStyle = BLNS_DEFAULT;
BOOL        _CustomClass = FALSE;

#ifdef __cplusplus
extern "C" {
#endif
BOOL RegisterDlgWin (void);
BOOL RegisterNewBalloonClass (void);
BOOL CALLBACK _export MainWndProc(HWND, UINT, WPARAM, LPARAM);
BOOL CreateFonts (void);
LRESULT CALLBACK _export NewBalloonWndProc(HWND, UINT, WPARAM, LPARAM);
#ifdef __cplusplus
}
#endif


int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
   LPSTR lpszCmdLine, int nCmdShow)
{
   MSG      message;
   HWND     hWndMain;

   hPrevInstance = hPrevInstance;
   lpszCmdLine = lpszCmdLine;
   nCmdShow = nCmdShow;
   _hInst = hInstance;
   _szTitle[0] = 0;
   _szText[0] = 0;

   if ( !RegisterDlgWin() || !RegisterNewBalloonClass() )
      return -1;

   _hwndMain = CreateDialogParam(_hInst, MAKEINTRESOURCE(1), NULL, NULL, NULL);
   if ( !_hwndMain ) return -2;

   // Windows passes a CmdShow parameter to the program.
   ShowWindow(_hwndMain, nCmdShow);
   UpdateWindow(_hwndMain);

   // Create fonts
   if ( !CreateFonts() ) return -3;

   // Run Message Loop
   while ( GetMessage(&message, 0, 0, 0) )
   {
      // If main window will contain modeless dialogs we must call
      //   this function. Otherwise TABBING not possible.
      if ( IsDialogMessage(_hwndMain, &message) ) continue;

      // Otherwise pass to normal message processing
      TranslateMessage(&message);
      DispatchMessage(&message);
   }

   DeleteObject(_hFontTitle);
   DeleteObject(_hFontText);
   return message.wParam;
}


BOOL RegisterDlgWin(void)
{
   WNDCLASS wndclass;

   wndclass.style = CS_HREDRAW | CS_VREDRAW;
   wndclass.lpfnWndProc = (WNDPROC)MainWndProc;

   /*** Extra window and class bytes ***/
   wndclass.cbClsExtra = 0;
   wndclass.cbWndExtra = DLGWINDOWEXTRA; // Necessary.

   wndclass.hInstance = _hInst;
   wndclass.hIcon = LoadIcon(_hInst, MAKEINTRESOURCE(1));
   wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
   wndclass.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1);

   wndclass.lpszMenuName = NULL;
   wndclass.lpszClassName = DLGCLASSNAME;

   /*** Try to register window ***/
   return (RegisterClass(&wndclass));
}


/*** RegisterNewBalloonClass ***
   Does some very interesting things: superclassing
********************************/
BOOL RegisterNewBalloonClass(void)
{
   WNDCLASS    wndclass;
   HINSTANCE   hInstGolfiery;

   /*** Get instance handle of the balloon dll ***/
   hInstGolfiery = LoadLibrary(BALLOONDLL);
   FreeLibrary(hInstGolfiery);

   /*** Retrieve info about the balloonhelp class ***/
   if ( !GetClassInfo(hInstGolfiery, BALLOONCLASSNAME, &wndclass) )
      return FALSE;

   /*** Superclass class won't be global, clear bit ***/
   wndclass.style &= ~CS_GLOBALCLASS;

   /*** New class will be valid for this instance only ***/
   _lpfnOldProc = wndclass.lpfnWndProc;
   wndclass.lpfnWndProc = NewBalloonWndProc;
   wndclass.hInstance = _hInst;
   wndclass.hbrBackground = CreateSolidBrush(RGB(192, 192, 192)) ;
   wndclass.lpszMenuName = NULL;
   wndclass.lpszClassName = (LPCSTR)NEWBALLOONCLASSNAME;

   return (RegisterClass(&wndclass));
}


BOOL CreateFonts(void)
{
   LOGFONT  logfont;
   int      nHeight, n;

   /*** Calculate a nice resolution independent font ***/
   GetObject(GetStockObject(ANSI_VAR_FONT), sizeof logfont, &logfont);
   nHeight = (logfont.lfHeight * 4) / 3;

   /*** Set all to default ***/
   for (n = 0; n < sizeof logfont; n++)
      ((LPBYTE)&logfont)[n] = 0;
   logfont.lfHeight = nHeight;
   lstrcpy(logfont.lfFaceName, "Arial");

   _hFontText = CreateFontIndirect(&logfont);

   if ( !_hFontText ) return FALSE;

   logfont.lfWeight = FW_BOLD;
   logfont.lfItalic = 1;

   _hFontTitle = CreateFontIndirect(&logfont);

   if ( !_hFontTitle ) {
      DeleteObject(_hFontText);
      return FALSE;
   }

   return TRUE;
}


BOOL CALLBACK __export MainWndProc(HWND hWnd, UINT wMessage, WPARAM wParam, LPARAM lParam)
{
   LRESULT  lResult = 0;
   BOOL     fHandled = FALSE;

   switch(wMessage)
   {
      case WM_SHOWWINDOW:
         /* Set default radiobutton */
         CheckRadioButton(hWnd, IDC_DEFAULT, IDC_LEFTBOTTOM, IDC_DEFAULT);
         break;

      case WM_COMMAND :
         switch(wParam)
         {
            case IDC_LEFTTOP :
            case IDC_DEFAULT :
            case IDC_RIGHTTOP :
            case IDC_RIGHTBOTTOM :
            case IDC_LEFTBOTTOM :
               if ( HIWORD(lParam) == BN_CLICKED ) {
                  fHandled = TRUE;
                  _wStyle &= ~BLNS_TAGPOSITION;
                  _wStyle |= ((WORD)wParam - IDC_DEFAULT);

                  CheckRadioButton(hWnd, IDC_DEFAULT, IDC_LEFTBOTTOM, (int)wParam);
               }
               break;

            /*** Click on button! ***/
            case IDC_POSDEMO :
               {
                  RECT  rcRect;

                  if ( _wStyle & BLNS_BALLOONATPOINT )
                     GetCursorPos((LPPOINT)&rcRect);
                  else GetWindowRect(GetDlgItem(hWnd, IDC_POSDEMO), &rcRect);

                  /*** Want some nice text in there :-) ***/
                  GetWindowText(GetDlgItem(hWnd, IDC_TITLE), _szTitle,
                     sizeof _szTitle);
                  GetWindowText(GetDlgItem(hWnd, IDC_TEXT), _szText,
                     sizeof _szText);

                  if ( _szTitle[0] == 0 && _szText[0] == 0 ) {
                     lstrcpy(_szTitle, "Balloon position demo");
                     SetWindowText(GetDlgItem(hWnd, IDC_TITLE), _szTitle);

                     lstrcpy(_szText, "Golfiery is also known as the DOSBoss West"
                        " project of a Ballunatic Programmer. Golfiery is a pun on the"
                        " inventors of the balloon: the Montgolfier brothers." );
                     SetWindowText(GetDlgItem(hWnd, IDC_TEXT), _szText);
                  }

                  /*** Now ready to popup our balloon ***/
                  if ( _CustomClass )
                     BalloonHelpFromClass(_hInst, NEWBALLOONCLASSNAME, hWnd, &rcRect,
                        _szTitle, _szText, _wStyle);
                  else BalloonHelpEx(hWnd, &rcRect, _szTitle, _szText, _wStyle);
               }
               break;

            case IDC_THINBORDER :
               if ( HIWORD(lParam) == BN_CLICKED ) {
                  fHandled = TRUE;
                  _wStyle ^= BLNS_THINBORDER;
               }
               break;

            case IDC_BALLOONATPOINT :
               if ( HIWORD(lParam) == BN_CLICKED ) {
                  fHandled = TRUE;
                  _wStyle ^= BLNS_BALLOONATPOINT;
               }
               break;

            case IDC_CUSTOMCLASS :
               if ( HIWORD(lParam) == BN_CLICKED ) {
                  fHandled = TRUE;
                  _CustomClass ^= 1;
               }
               break;

            case IDC_NOTAG:
               if ( HIWORD(lParam) == BN_CLICKED ) {
                  fHandled = TRUE;
                  _wStyle ^= BLNS_NOTAG;
               }
               break;


            case IDOK :
               PostMessage(hWnd, WM_CLOSE, 0, 0);
               break;

         }
         break;

      case WM_DESTROY :
         PostQuitMessage(0);
         break;

   }

   if ( !fHandled ) lResult = DefWindowProc(hWnd, wMessage, wParam, lParam);
   return lResult;
}



LRESULT CALLBACK _export NewBalloonWndProc(HWND hBalloon, UINT uMsg,
   WPARAM wParam, LPARAM lParam)
{
   LRESULT  lResult = 0;
   BOOL     fHandled = FALSE;

   switch ( uMsg ) {

      /*** You're allowed to intercept WM_DESTROY & WM_CREATE,
           but you should always forward these messages to the
           the old window procedure ***/
      case WM_CREATE:
      case WM_DESTROY:
         break;

      /***** BalloonHelp Font handling *****
      Don't send a BLNM_SETTEXTFONT, BLNM_SETTITLEFONT or a
      WM_SETFONT to an already created Balloon. These messages
      don't do anything yet. If you want use another font superclass
      the hBallooon

      Furthermore, WM_SETFONT and WM_GETFONT are mapped to BLNM_SETTEXTFONT
      and BLNM_GETTEXTFONT
      **************************************/

      /*** This messages are sent during WM_CREATE & WM_PAINT, set lResult to
           the font for the text/title. The font width and height are
           in device coordinates ***/
      case BLNM_GETTEXTFONT:
         return (LRESULT)_hFontText;

      case BLNM_GETTITLEFONT:
         return (LRESULT)_hFontTitle;

      /***** BalloonHelp ctlcolor handling *****
      The BalloonPaint code sends three WM_CTLCOLOR messages during the
      handling of the WM_PAINT message.

      HIWORD(lParam)         Default action

      CTLCOLOR_DLG           Returns the HBRUSH for the balloon's background
      CTLCOLOR_TITLEFONT     Sets text color to RGB(0, 0, 0) and back mode to
                             TRANSPARENT
      CTLCOLOR_TEXTFONT      See CTLCOLOR_TITLEFONT
      ******************************************/

      case WM_CTLCOLOR:
         /*** Get the old back brush first ***/
         lResult = CallWindowProc(_lpfnOldProc, hBalloon, WM_CTLCOLOR, wParam,
            lParam);
         switch ( HIWORD(lParam )) {
            case CTLCOLOR_TITLEFONT:
               SetTextColor((HDC)wParam, RGB(0xFF, 0, 0));
               break;
            case CTLCOLOR_TEXTFONT:
               SetTextColor((HDC)wParam, RGB(0, 0, 0xFF));
               break;
         }
         return lResult;
   }

   return fHandled ? lResult :
      CallWindowProc(_lpfnOldProc, hBalloon, uMsg, wParam, lParam);
}
