/******************************************************************************
*                    Demonstrates Win32 DLL shared memory                     *
*                           3/1/95 by Mark Gamber                             *
******************************************************************************/

#include "windows.h"

//  === Designate shared memory section, in this case a string ================

#pragma data_seg(".NAMESEG")
char szSharedName[ 256 ] = "\0";
#pragma data_seg()

//  === Global Variables (local to each instance) =============================

char szLocalName[ 256 ];

//  === DLL Entry Point =======================================================

BOOL WINAPI DllEntryPoint( HINSTANCE hInstance, DWORD dwReason, DWORD dwRes )
{
	return( TRUE );
}

//  === DLL calls to set and get the various strings ==========================

BOOL CALLBACK SetLocalName( LPSTR lpszBuffer )
{
	lstrcpy( szLocalName, lpszBuffer );
	return( TRUE );
}

BOOL CALLBACK SetSharedName( LPSTR lpszBuffer )
{
	lstrcpy( szSharedName, lpszBuffer );
	return( TRUE );
}

BOOL CALLBACK GetLocalName( LPSTR lpszBuffer )
{
	lstrcpy( lpszBuffer, szLocalName );
	return( TRUE );
}

BOOL CALLBACK GetSharedName( LPSTR lpszBuffer )
{
	lstrcpy( lpszBuffer, szSharedName );
	return( TRUE );
}

