{******************************************************************}
{ Description:                                                     }
{   This is a small sample program to demonstrate how to call some }
{   of the functions in the YGREP32.DLL from Borland's Delphi 2.   }
{   You need the YGrepInt.pas and test.txt file for this to work.  }
{   Test.txt is only used to test the SFile Search functions.      }
{                                                                  }
{ Author:                                                          }
{   Damien Lewis (louie@melbpc.org.au) - 6th August 1996           }
{ Modified:                                                        }
{   97/06/08 - Yves Roumazeilles (6.02b)                           }
{              Added the new parameter to SFileSetFlags.           }
{******************************************************************}

unit YgrepTst;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    btnTest: TButton;
    lblSearchStr: TLabel;
    rgrpTest: TRadioGroup;
    lblTextStr: TLabel;
    lblReplaceStr: TLabel;
    lblSearchResult: TLabel;
    btnExit: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    lblReplaceResult: TLabel;
    cboxMatchCase: TCheckBox;
    procedure btnTestClick(Sender: TObject);
    procedure btnExitClick(Sender: TObject);
    procedure rgrpTestClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses
  YGrepInt;    { This is the interface to the YGREP32.DLL }

var
  { Define a few global variables }
  SearchStr: array[0..50] of char;
  ReplaceStr: array[0..50] of char;
  TextStr: array[0..50] of char;
  SearchResult: array[0..50] of char;
  ReplaceResult: array[0..50] of char;

{$R *.DFM}

procedure TForm1.FormShow(Sender: TObject);
begin
  Form1.rgrpTestClick(Form1);
end;

procedure TForm1.btnTestClick(Sender: TObject);
var
  { Define some local variables }
  MatchCase: Integer;
  NoOfErrors: Integer;
  Result: Integer;
  LinesFound: LongInt;
  TempStr: String;
  ResultStr: String;
  ReplaceString: String;
  SearchFile: String;
  pGI: PtagRGrepInfo;   { Pointer to the RGrepInfo Structure }
begin
  New(pGI);             { Create a new structure and assign pointer to it }

  if cboxMatchCase.Checked = True then
    MatchCase := 1
  else
    MatchCase := 0;

  case rgrpTest.ItemIndex of
    0:
    { SAGrep Search Functions }
    begin
      NoOfErrors := 2;
      Result := SCompileAGrep(SearchStr, NoOfErrors, MatchCase);
      Result := SAGrep(TextStr);
      if Result > 0 then
        lblSearchResult.Caption := 'Match Found';
      if Result = 0 then
        lblSearchResult.Caption := 'No Match';
      if Result < 0 then
        lblSearchResult.Caption := 'Error Occurred';
    end;

    1:
    { SRGrep Search Functions }
    begin
      Result := SCompileRGrep(SearchStr, MatchCase);
      Result := SRGrep(TextStr);
      if Result > 0 then
        lblSearchResult.Caption := 'Match Found';
      if Result = 0 then
        lblSearchResult.Caption := 'No Match';
      if Result < 0 then
        lblSearchResult.Caption := 'Error Occurred';
    end;

    2:
    { SRGrep Replace Functions }
    begin
      Result := SCompileRGrep(SearchStr, MatchCase);
      Result := SRGrep(TextStr);
      Result := SRGrepSubsBuild(SearchStr, ReplaceResult, 50);
      Result := SRGrepSubstitute(TextStr, ReplaceStr, ReplaceResult, 50);
      lblSearchResult.Caption := ReplaceResult;
    end;

    3:
    { SRGrep File Search Functions }
    begin
      SearchFile := ExtractFilePath(Application.ExeName) + 'test.txt';
      if FileExists(SearchFile) then begin
        SFileSetFlags(0, 0, 1, 0, 0, 0);
        Result := SCompileRGrep(SearchStr, MatchCase);
        Result := SFileOpen(PChar(SearchFile));
        repeat
          TempStr := ResultStr;
          ResultStr := SFileRGrep;
        until ResultStr = '';
        LinesFound := SFileClose;
        lblSearchResult.Caption := IntToStr(LinesFound) + ' Lines Found';
        lblReplaceResult.Caption := 'Line: ' + TempStr;
      end else begin
        lblSearchResult.Caption := 'ERROR: Test file was not found!';
      end;
    end;

    4:
    { RGrep Search Functions }
    begin
      Result := CompileRGrep(SearchStr, MatchCase, pGI);
      Result := RGrep(TextStr, pGI);
      if Result > 0 then
        lblSearchResult.Caption := 'Match Found';
      if Result = 0 then
        lblSearchResult.Caption := 'No Match';
      if Result < 0 then
        lblSearchResult.Caption := 'Error Occurred';
    end;
  end;
  Dispose(pGI);         { Dstroy structure when finished }
end;

procedure TForm1.btnExitClick(Sender: TObject);
begin
  Close;
end;

procedure TForm1.rgrpTestClick(Sender: TObject);
begin
  SearchResult := '';
  ReplaceResult := '                                        ';
  case rgrpTest.ItemIndex of
    0:
    { Fill variables for SAGrep Search Functions }
    begin
      SearchStr := 'East Germany';
      ReplaceStr := '';
      TextStr := 'West Germany';
    end;

    1:
    { Fill variables for SRGrep Search Functions }
    begin
      SearchStr := 'Horse';
      ReplaceStr := '';
      TextStr := 'A horse! My kingdom for a horse!';
    end;

    2:
    { Fill variables for SRGrep Replace Functions }
    begin
      SearchStr := 'Horse';
      ReplaceStr := 'donkey';
      TextStr := 'A horse! My kingdom for a horse!';
    end;

    3:
    { Fill variables for SRGrep File Search Functions }
    begin
      SearchStr := 'Apples';
      ReplaceStr := '';
      TextStr := 'test.txt';
    end;

    4:
    { Fill variables for RGrep Search Functions }
    begin
      SearchStr := 'Horse';
      ReplaceStr := '';
      TextStr := 'A horse! My kingdom for a horse!';
    end;
  end;
  lblSearchStr.Caption := SearchStr;
  lblReplaceStr.Caption := ReplaceStr;
  lblTextStr.Caption := TextStr;
  lblSearchResult.Caption := SearchResult;
  lblReplaceResult.Caption := ReplaceResult;
end;

end.
