// Aggregate.cpp : implementation file
//

#include "stdafx.h"
#include "AggrNum.h"
#include "Aggregate.h"
#include <afxpriv.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAggregate

IMPLEMENT_DYNCREATE(CAggregate, CCmdTarget)

CAggregate::CAggregate()
{
	EnableAutomation();
	
	// To keep the application running as long as an OLE automation 
	//	object is active, the constructor calls AfxOleLockApp.
	
	AfxOleLockApp();

   m_lpAggrInner = NULL;
   m_lpDispatch = NULL;
}

CAggregate::~CAggregate()
{
	// To terminate the application when all objects created with
	// 	with OLE automation, the destructor calls AfxOleUnlockApp.
	
	AfxOleUnlockApp();

   if (m_lpAggrInner)
   {
      if (m_lpDispatch)
      {
         m_lpDispatch->Release();
         m_lpDispatch = NULL;
      }

      // make sure release does not reduce our ref count
      // to zero again, causing the destructor to be called
      // a second time.

      ExternalAddRef();
      m_lpAggrInner->Release();
      m_lpAggrInner = NULL;
   }
}


void CAggregate::OnFinalRelease()
{
	// When the last reference for an automation object is released
	// OnFinalRelease is called.  The base class will automatically
	// deletes the object.  Add additional cleanup required for your
	// object before calling the base class.

	CCmdTarget::OnFinalRelease();
}

const IID BASED_CODE CLSID_Number =
 {	0x19ac0303, 0xc37f, 0x11cf, 0x97, 0x20, 0, 0x20, 0xaf, 0xf3, 0x4d, 0x4d };


BOOL CAggregate::OnCreateAggregates()
{
   ::CoCreateInstance( CLSID_Number,
                       GetControllingUnknown(),
                       CLSCTX_INPROC_SERVER,
                       IID_IUnknown,
                       (LPVOID*)&m_lpAggrInner );

   if (m_lpAggrInner == NULL)
      return FALSE;

   m_lpAggrInner->QueryInterface( IID_IDispatch, (void**)&m_lpDispatch );

   // query interface will increment out reference count, must reduce
   // by one straight away otherwise will never get to zero!

   if (m_lpDispatch) 
      InternalRelease();

   return TRUE;
}

BEGIN_MESSAGE_MAP(CAggregate, CCmdTarget)
	//{{AFX_MSG_MAP(CAggregate)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_DISPATCH_MAP(CAggregate, CCmdTarget)
	//{{AFX_DISPATCH_MAP(CAggregate)
		// NOTE - the ClassWizard will add and remove mapping macros here.
	//}}AFX_DISPATCH_MAP
END_DISPATCH_MAP()

// Note: we add support for IID_IAggregate to support typesafe binding
//  from VBA.  This IID must match the GUID that is attached to the 
//  dispinterface in the .ODL file.

// {B7EBD62D-C439-11CF-9720-0020AFF34D4D}
static const IID IID_IAggregate =
{ 0xb7ebd62d, 0xc439, 0x11cf, { 0x97, 0x20, 0x0, 0x20, 0xaf, 0xf3, 0x4d, 0x4d } };

BEGIN_INTERFACE_MAP(CAggregate, CCmdTarget)
	INTERFACE_PART(CAggregate, IID_IDispatch, Dispatch)
   INTERFACE_AGGREGATE(CAggregate,m_lpAggrInner)
END_INTERFACE_MAP()

// {B7EBD62E-C439-11CF-9720-0020AFF34D4D}
IMPLEMENT_OLECREATE(CAggregate, "AGGRNUM.AGGREGATE", 0xb7ebd62e, 0xc439, 0x11cf, 0x97, 0x20, 0x0, 0x20, 0xaf, 0xf3, 0x4d, 0x4d)

/////////////////////////////////////////////////////////////////////////////
// CAggregate message handlers

//***********************************************************************************
//
// Implement IDispatch interface
//
// QueryInterface, AddRef, Release
// GetTypeInfoCount
// GetTypeInfo
// GetIDsOfNames
// Invoke
//
//***********************************************************************************

const TCHAR BASED_CODE strReset[] = _T("Reset");
 
STDMETHODIMP_(ULONG) CAggregate::XDispatch::AddRef()
{
   METHOD_PROLOGUE(CAggregate, Dispatch)
   ASSERT_VALID( pThis );
   return (ULONG)pThis->ExternalAddRef();
}
  
STDMETHODIMP_(ULONG) CAggregate::XDispatch::Release()
{
   METHOD_PROLOGUE(CAggregate, Dispatch)
   ASSERT_VALID( pThis );         
   return (ULONG)pThis->ExternalRelease();
}
 
 
STDMETHODIMP CAggregate::XDispatch::QueryInterface( REFIID iid, 
                                                  LPVOID *ppvObj )
{
   METHOD_PROLOGUE(CAggregate, Dispatch)
   ASSERT_VALID( pThis );          
   return (HRESULT)pThis->ExternalQueryInterface(&iid, ppvObj);
}
 
STDMETHODIMP CAggregate::XDispatch::GetTypeInfoCount(unsigned int *pctinfo)
{
   METHOD_PROLOGUE(CAggregate, Dispatch)
   ASSERT_VALID(pThis);

   *pctinfo = 1;
   return NOERROR; 
}

const IID BASED_CODE IID_Typelib =
 {	0xB7EBD62A, 0xC439, 0x11CF, 0x97, 0x20, 0x00, 0x20, 0xAF, 0xF3, 0x4D, 0x4D};
 
STDMETHODIMP CAggregate::XDispatch::GetTypeInfo(unsigned int itinfo,
   LCID lcid, ITypeInfo ** pptinfo )
{
   METHOD_PROLOGUE(CAggregate, Dispatch)
   ASSERT_VALID(pThis);                     

   LPTYPELIB   plib;

   if ( SUCCEEDED( ::LoadRegTypeLib( IID_Typelib, 1, 0, 0, &plib ) ) )
   {
      HRESULT hr = plib->GetTypeInfo(itinfo,pptinfo);
      plib->Release();
      return hr;
   }

   return E_FAIL;
}
 
STDMETHODIMP CAggregate::XDispatch::GetIDsOfNames(REFIID riid,
      LPOLESTR *rgszNames, unsigned int cNames, LCID lcid,
      DISPID *rgdispid )
{
   METHOD_PROLOGUE(CAggregate, Dispatch)
   ASSERT_VALID(pThis);

   USES_CONVERSION;

   if ( ! IsEqualIID(riid, IID_NULL) )
      return ResultFromScode(DISP_E_UNKNOWNINTERFACE);

   // let aggregated control fill in its matching names

   HRESULT  hr = ResultFromScode(DISP_E_UNKNOWNNAME);

   if ( pThis->m_lpDispatch )
      hr = pThis->m_lpDispatch->GetIDsOfNames( riid, rgszNames, cNames,
                                               lcid, rgdispid );

   // fillin any of the extended matching names, if a name
   // exists in both then the extended entry takes preference

#ifdef WIN32
   LPCOLESTR pReset = T2COLE( strReset );
#endif

   for( unsigned int i=0; i<cNames; i++ )
   {
#ifdef WIN32
      if ( ! wcscmp( rgszNames[0], pReset ) )
#else
      if ( ! strcmp( rgszNames[0], strReset ) )
#endif
      {
         rgdispid[0] = DISPID_RESET;
         hr = NOERROR;
      }
   }

   return hr;
}

STDMETHODIMP CAggregate::XDispatch::Invoke(DISPID dispidMember,
      REFIID riid, LCID lcid, unsigned short wFlags, DISPPARAMS *lpDispparams,
      VARIANT *pvarResult, EXCEPINFO *pexcepinfo, 
      unsigned int *puArgErr)
{
   METHOD_PROLOGUE(CAggregate, Dispatch)
   ASSERT_VALID(pThis);

   // riid is supposed to be NULL always

   if ( riid != IID_NULL )
      return ResultFromScode(DISP_E_UNKNOWNINTERFACE);

   if ( dispidMember == DISPID_RESET )
   {
      // perform a Number1 and Number2 property put on the
      // aggregate control. Setting both to 100.

      COleDispatchDriver tempDriver;
      
      tempDriver.AttachDispatch( pThis->m_lpDispatch, FALSE );
      tempDriver.SetProperty( 1, VT_I2, (short)100 );
      tempDriver.SetProperty( 2, VT_I2, (short)100 );
   
      return ResultFromScode(S_OK);
   }

   if ( pThis->m_lpDispatch )
      return pThis->m_lpDispatch->Invoke( dispidMember, riid, lcid, wFlags,
                                          lpDispparams, pvarResult, pexcepinfo, puArgErr );

   return ResultFromScode(DISP_E_MEMBERNOTFOUND);
}                             
