// getnactl.cpp : Implementation of the CGetnameCtrl OLE control class.

#include "stdafx.h"
#include "gethost.h"
#include "getnactl.h"
#include "getnappg.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNCREATE(CGetnameCtrl, COleControl)


/////////////////////////////////////////////////////////////////////////////
// Message map

BEGIN_MESSAGE_MAP(CGetnameCtrl, COleControl)
	//{{AFX_MSG_MAP(CGetnameCtrl)
	// NOTE - ClassWizard will add and remove message map entries
	//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG_MAP
	ON_OLEVERB(AFX_IDS_VERB_PROPERTIES, OnProperties)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// Dispatch map

BEGIN_DISPATCH_MAP(CGetnameCtrl, COleControl)
	//{{AFX_DISPATCH_MAP(CGetnameCtrl)
	DISP_PROPERTY_NOTIFY(CGetnameCtrl, "HostAddress", m_hostAddress, OnHostAddressChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CGetnameCtrl, "ErrorNum", m_errorNum, OnErrorNumChanged, VT_I2)
	DISP_FUNCTION(CGetnameCtrl, "GetHostName", GetHostName, VT_BSTR, VTS_NONE)
	//}}AFX_DISPATCH_MAP
	DISP_FUNCTION_ID(CGetnameCtrl, "AboutBox", DISPID_ABOUTBOX, AboutBox, VT_EMPTY, VTS_NONE)
END_DISPATCH_MAP()


/////////////////////////////////////////////////////////////////////////////
// Event map

BEGIN_EVENT_MAP(CGetnameCtrl, COleControl)
	//{{AFX_EVENT_MAP(CGetnameCtrl)
	// NOTE - ClassWizard will add and remove event map entries
	//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_EVENT_MAP
END_EVENT_MAP()


/////////////////////////////////////////////////////////////////////////////
// Property pages

// TODO: Add more property pages as needed.  Remember to increase the count!
BEGIN_PROPPAGEIDS(CGetnameCtrl, 1)
	PROPPAGEID(CGetnamePropPage::guid)
END_PROPPAGEIDS(CGetnameCtrl)


/////////////////////////////////////////////////////////////////////////////
// Initialize class factory and guid

IMPLEMENT_OLECREATE_EX(CGetnameCtrl, "GETHOST.GetnameCtrl.1",
	0x2158ea24, 0x3514, 0x11ce, 0x96, 0xf, 0x52, 0x41, 0x53, 0x48, 0x0, 0x5)


/////////////////////////////////////////////////////////////////////////////
// Type library ID and version

IMPLEMENT_OLETYPELIB(CGetnameCtrl, _tlid, _wVerMajor, _wVerMinor)


/////////////////////////////////////////////////////////////////////////////
// Interface IDs

const IID BASED_CODE IID_DGetName =
		{ 0x2158ea25, 0x3514, 0x11ce, { 0x96, 0xf, 0x52, 0x41, 0x53, 0x48, 0x0, 0x5 } };
const IID BASED_CODE IID_DGetNameEvents =
		{ 0x2158ea26, 0x3514, 0x11ce, { 0x96, 0xf, 0x52, 0x41, 0x53, 0x48, 0x0, 0x5 } };


/////////////////////////////////////////////////////////////////////////////
// Control type information

static const DWORD BASED_CODE _dwGetNameOleMisc =
	OLEMISC_INVISIBLEATRUNTIME |
	OLEMISC_ACTIVATEWHENVISIBLE |
	OLEMISC_SETCLIENTSITEFIRST |
	OLEMISC_INSIDEOUT |
	OLEMISC_CANTLINKINSIDE |
	OLEMISC_RECOMPOSEONRESIZE;

IMPLEMENT_OLECTLTYPE(CGetnameCtrl, IDS_GETNAME, _dwGetNameOleMisc)


/////////////////////////////////////////////////////////////////////////////
// CGetnameCtrl::CGetnameCtrlFactory::UpdateRegistry -
// Adds or removes system registry entries for CGetnameCtrl

BOOL CGetnameCtrl::CGetnameCtrlFactory::UpdateRegistry(BOOL bRegister)
{
	if (bRegister)
		return AfxOleRegisterControlClass(
			AfxGetInstanceHandle(),
			m_clsid,
			m_lpszProgID,
			IDS_GETNAME,
			IDB_GETNAME,
			TRUE,                       //  Insertable
			_dwGetNameOleMisc,
			_tlid,
			_wVerMajor,
			_wVerMinor);
	else
		return AfxOleUnregisterClass(m_clsid, m_lpszProgID);
}


/////////////////////////////////////////////////////////////////////////////
// CGetnameCtrl::CGetnameCtrl - Constructor

CGetnameCtrl::CGetnameCtrl()
{
	InitializeIIDs(&IID_DGetName, &IID_DGetNameEvents);

	// TODO: Initialize your control's instance data here.
}


/////////////////////////////////////////////////////////////////////////////
// CGetnameCtrl::~CGetnameCtrl - Destructor

CGetnameCtrl::~CGetnameCtrl()
{
	// TODO: Cleanup your control's instance data here.
}


/////////////////////////////////////////////////////////////////////////////
// CGetnameCtrl::OnDraw - Drawing function

void CGetnameCtrl::OnDraw(CDC* pdc, const CRect& rcBounds, const CRect& rcInvalid)
{
	// TODO: Replace the following code with your own drawing code.
	CBitmap bitmap;
	BITMAP  bmp;
	CPictureHolder picHolder;
	CRect rcSrcBounds;

	// Load bitmap
	bitmap.LoadBitmap(IDB_GETNM);
	bitmap.GetObject(sizeof(BITMAP), &bmp);
	rcSrcBounds.right = bmp.bmWidth;
	rcSrcBounds.bottom = bmp.bmHeight;

	// Create picture and render
	picHolder.CreateFromBitmap((HBITMAP)bitmap.m_hObject, NULL, FALSE);
	picHolder.Render(pdc, rcBounds, rcSrcBounds);
}


/////////////////////////////////////////////////////////////////////////////
// CGetnameCtrl::DoPropExchange - Persistence support

void CGetnameCtrl::DoPropExchange(CPropExchange* pPX)
{
	ExchangeVersion(pPX, MAKELONG(_wVerMinor, _wVerMajor));
	COleControl::DoPropExchange(pPX);
	// TODO: Call PX_ functions for each persistent custom property.
	PX_String(pPX,_T("HostAddress"),m_hostAddress,"");
}


/////////////////////////////////////////////////////////////////////////////
// CGetnameCtrl::OnResetState - Reset control to default state

void CGetnameCtrl::OnResetState()
{
	COleControl::OnResetState();  // Resets defaults found in DoPropExchange

	// TODO: Reset any other control state here.
}


/////////////////////////////////////////////////////////////////////////////
// CGetnameCtrl::AboutBox - Display an "About" box to the user

void CGetnameCtrl::AboutBox()
{
	CDialog dlgAbout(IDD_ABOUTBOX_GETNAME);
	dlgAbout.DoModal();
}


/////////////////////////////////////////////////////////////////////////////
// CGetnameCtrl message handlers

BSTR CGetnameCtrl::GetHostName() 
{
	
	// TODO: Add your dispatch handler code here
	CString 		s;
	int    			nListen_sd, nRc;
	struct 			sockaddr_in server_addr;
	WORD			wVersionRequested;
	WSADATA 		wsaData;
	char 			IPAddress[50], HName[100];
	BOOL			optionbool;
	struct hostent* hostinfo;
	unsigned long	InetAddress;


	//Initialize error property
	m_errorNum = 0;

	//Startup the sockets library
	wVersionRequested = MAKEWORD( 1, 1 );
	m_errorNum = WSAStartup( wVersionRequested, &wsaData );
	if ( m_errorNum != 0 ) 
	{
		m_errorNum = WSAGetLastError() - WSABASEERR;
		return(0);
	}

 	//Open a socket and get a handle
	nListen_sd= socket(AF_INET, SOCK_DGRAM, 0);
	if(nListen_sd < 0)
	{
		m_errorNum = WSAGetLastError() - WSABASEERR;
		return(0);
	}
	else
	{
		optionbool = TRUE;
		setsockopt(nListen_sd,SOL_SOCKET,SO_OOBINLINE,
			(const char *)&optionbool,sizeof(optionbool));
	}

	//Prepare the address structure for connection
	server_addr.sin_family = AF_INET;
	server_addr.sin_addr.s_addr = INADDR_ANY;
	server_addr.sin_port = htons(IPPORT_NAMESERVER);   

	//Connect to a remote address
	nRc=connect(nListen_sd, (struct sockaddr far *)&server_addr, 
		sizeof(server_addr));
	if  (nRc==-1) 
	{
		m_errorNum = WSAGetLastError() - WSABASEERR;
		return(0);
	}

	//Convert the entered host address to network ordered address
	memcpy((char far *)IPAddress,m_hostAddress.GetBuffer(40),40);
	InetAddress = inet_addr(IPAddress);
	if (InetAddress == INADDR_NONE)
	{
		m_errorNum = 25;	//Invalid IP Address
		return(0);
	}
	memcpy(IPAddress,&InetAddress,4);

	//Retrieve the name of the host given by the address
	hostinfo = gethostbyaddr(IPAddress,4,PF_INET);
	if  (hostinfo==0) 
	{
		m_errorNum = WSAGetLastError() - WSABASEERR;
		return(0);
	}
	else
	{
		sprintf(HName,"%s",hostinfo->h_name);
		s=HName;
	}

	shutdown(nListen_sd,0);
	WSACleanup();

	return s.AllocSysString();
}


void CGetnameCtrl::OnHostAddressChanged() 
{
	// TODO: Add notification handler code
	SetModifiedFlag();
}

void CGetnameCtrl::OnErrorNumChanged() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
}

