// popctl.cpp : Implementation of the CPopCtrl OLE control class.

#include "stdafx.h"
#include "mail.h"
#include "popctl.h"
#include "popppg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNCREATE(CPopCtrl, COleControl)


/////////////////////////////////////////////////////////////////////////////
// Message map

BEGIN_MESSAGE_MAP(CPopCtrl, COleControl)
	//{{AFX_MSG_MAP(CPopCtrl)
	// NOTE - ClassWizard will add and remove message map entries
	//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG_MAP
	ON_OLEVERB(AFX_IDS_VERB_PROPERTIES, OnProperties)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// Dispatch map

BEGIN_DISPATCH_MAP(CPopCtrl, COleControl)
	//{{AFX_DISPATCH_MAP(CPopCtrl)
	DISP_PROPERTY_NOTIFY(CPopCtrl, "ErrorNum", m_errorNum, OnErrorNumChanged, VT_I2)
	DISP_PROPERTY_NOTIFY(CPopCtrl, "UserName", m_userName, OnUserNameChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CPopCtrl, "Password", m_password, OnPasswordChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CPopCtrl, "PopSrvrAdrs", m_popSrvrAdrs, OnPopSrvrAdrsChanged, VT_BSTR)
	DISP_FUNCTION(CPopCtrl, "ListMail", ListMail, VT_BSTR, VTS_NONE)
	DISP_FUNCTION(CPopCtrl, "GetMail", GetMail, VT_BSTR, VTS_I2)
	DISP_FUNCTION(CPopCtrl, "GetStatus", GetStatus, VT_BSTR, VTS_NONE)
	DISP_FUNCTION(CPopCtrl, "POPLogoff", POPLogoff, VT_I2, VTS_NONE)
	DISP_FUNCTION(CPopCtrl, "POPLogon", POPLogon, VT_BSTR, VTS_NONE)
	DISP_FUNCTION(CPopCtrl, "DelMail", DelMail, VT_I2, VTS_I2)
	DISP_FUNCTION(CPopCtrl, "UnDelMail", UnDelMail, VT_I2, VTS_NONE)
	//}}AFX_DISPATCH_MAP
	DISP_FUNCTION_ID(CPopCtrl, "AboutBox", DISPID_ABOUTBOX, AboutBox, VT_EMPTY, VTS_NONE)
END_DISPATCH_MAP()


/////////////////////////////////////////////////////////////////////////////
// Event map

BEGIN_EVENT_MAP(CPopCtrl, COleControl)
	//{{AFX_EVENT_MAP(CPopCtrl)
	// NOTE - ClassWizard will add and remove event map entries
	//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_EVENT_MAP
END_EVENT_MAP()


/////////////////////////////////////////////////////////////////////////////
// Property pages

// TODO: Add more property pages as needed.  Remember to increase the count!
BEGIN_PROPPAGEIDS(CPopCtrl, 1)
	PROPPAGEID(CPopPropPage::guid)
END_PROPPAGEIDS(CPopCtrl)


/////////////////////////////////////////////////////////////////////////////
// Initialize class factory and guid

IMPLEMENT_OLECREATE_EX(CPopCtrl, "MAIL.PopCtrl.1",
	0x2b42f754, 0x3c62, 0x11ce, 0x96, 0xf, 0x52, 0x41, 0x53, 0x48, 0x0, 0x5)


/////////////////////////////////////////////////////////////////////////////
// Type library ID and version

IMPLEMENT_OLETYPELIB(CPopCtrl, _tlid, _wVerMajor, _wVerMinor)


/////////////////////////////////////////////////////////////////////////////
// Interface IDs

const IID BASED_CODE IID_DPOP =
		{ 0x2b42f755, 0x3c62, 0x11ce, { 0x96, 0xf, 0x52, 0x41, 0x53, 0x48, 0x0, 0x5 } };
const IID BASED_CODE IID_DPOPEvents =
		{ 0x2b42f756, 0x3c62, 0x11ce, { 0x96, 0xf, 0x52, 0x41, 0x53, 0x48, 0x0, 0x5 } };


/////////////////////////////////////////////////////////////////////////////
// Control type information

static const DWORD BASED_CODE _dwPOPOleMisc =
	OLEMISC_INVISIBLEATRUNTIME |
	OLEMISC_ACTIVATEWHENVISIBLE |
	OLEMISC_SETCLIENTSITEFIRST |
	OLEMISC_INSIDEOUT |
	OLEMISC_CANTLINKINSIDE |
	OLEMISC_RECOMPOSEONRESIZE;


IMPLEMENT_OLECTLTYPE(CPopCtrl, IDS_POP, _dwPOPOleMisc)


/////////////////////////////////////////////////////////////////////////////
// CPopCtrl::CPopCtrlFactory::UpdateRegistry -
// Adds or removes system registry entries for CPopCtrl

BOOL CPopCtrl::CPopCtrlFactory::UpdateRegistry(BOOL bRegister)
{
	if (bRegister)
		return AfxOleRegisterControlClass(
			AfxGetInstanceHandle(),
			m_clsid,
			m_lpszProgID,
			IDS_POP,
			IDB_POP,
			FALSE,                      //  Not insertable
			_dwPOPOleMisc,
			_tlid,
			_wVerMajor,
			_wVerMinor);
	else
		return AfxOleUnregisterClass(m_clsid, m_lpszProgID);
}


/////////////////////////////////////////////////////////////////////////////
// CPopCtrl::CPopCtrl - Constructor

CPopCtrl::CPopCtrl()
{
	InitializeIIDs(&IID_DPOP, &IID_DPOPEvents);

	// TODO: Initialize your control's instance data here.
}


/////////////////////////////////////////////////////////////////////////////
// CPopCtrl::~CPopCtrl - Destructor

CPopCtrl::~CPopCtrl()
{
	// TODO: Cleanup your control's instance data here.
}


/////////////////////////////////////////////////////////////////////////////
// CPopCtrl::OnDraw - Drawing function

void CPopCtrl::OnDraw(
			CDC* pdc, const CRect& rcBounds, const CRect& rcInvalid)
{
	// TODO: Replace the following code with your own drawing code.
	CBitmap bitmap;
	BITMAP  bmp;
	CPictureHolder picHolder;
	CRect rcSrcBounds;

	// Load bitmap
	bitmap.LoadBitmap(IDB_POP);
	bitmap.GetObject(sizeof(BITMAP), &bmp);
	rcSrcBounds.right = bmp.bmWidth;
	rcSrcBounds.bottom = bmp.bmHeight;

	// Create picture and render
	picHolder.CreateFromBitmap((HBITMAP)bitmap.m_hObject, NULL, FALSE);
	picHolder.Render(pdc, rcBounds, rcSrcBounds);
}


/////////////////////////////////////////////////////////////////////////////
// CPopCtrl::DoPropExchange - Persistence support

void CPopCtrl::DoPropExchange(CPropExchange* pPX)
{
	ExchangeVersion(pPX, MAKELONG(_wVerMinor, _wVerMajor));
	COleControl::DoPropExchange(pPX);

	// TODO: Call PX_ functions for each persistent custom property.

}


/////////////////////////////////////////////////////////////////////////////
// CPopCtrl::OnResetState - Reset control to default state

void CPopCtrl::OnResetState()
{
	COleControl::OnResetState();  // Resets defaults found in DoPropExchange

	// TODO: Reset any other control state here.
}


/////////////////////////////////////////////////////////////////////////////
// CPopCtrl::AboutBox - Display an "About" box to the user

void CPopCtrl::AboutBox()
{
	CDialog dlgAbout(IDD_ABOUTBOX_POP);
	dlgAbout.DoModal();
}


/////////////////////////////////////////////////////////////////////////////
// CPopCtrl message handlers
int CPopCtrl::StartSockets()
{
	WORD			wVersionRequested;
	WSADATA 		wsaData;

	wVersionRequested = MAKEWORD( 1, 1 );
	if ( WSAStartup( wVersionRequested, &wsaData ) != 0 ) 
	{
		m_errorNum = WSAGetLastError() - WSABASEERR;
		return 0;
	}
	return 1;
}

 	
int CPopCtrl::OpenSocket()
{
	skt = socket(AF_INET, SOCK_STREAM, 0);
	if(skt < 0)
	{
		m_errorNum = WSAGetLastError() - WSABASEERR;
		return 0;
	}
	return 1;
}


int CPopCtrl::RecvRemote(CString& buffer, int TimeOut)
{
	int				NumOfChars,valsize;
	char 			inbuff[500];

	buffer.Empty();	
	
	if(TimeOut==0)
		valsize=0;
	else
		valsize=sizeof(TimeOut);

	setsockopt(skt,SOL_SOCKET,SO_RCVTIMEO,(const char *)&TimeOut,valsize);
	
	if(TimeOut==0)
	{
		memset(inbuff,0,sizeof(inbuff));
		NumOfChars = recv(skt, inbuff, sizeof(inbuff), 0);

		switch(NumOfChars)
		{
			case -1	:	m_errorNum = WSAGetLastError() - WSABASEERR;
						return 0;
			case 0	:	break;
			default	:	buffer += inbuff;
						break;
		}
	}
	else
	{
		do{
			memset(inbuff,0,sizeof(inbuff));
			NumOfChars = recv(skt, inbuff, sizeof(inbuff), 0);

			switch(NumOfChars)
			{
				case -1	:	m_errorNum = WSAGetLastError() - WSABASEERR;
							if(m_errorNum==60)	//Timeout
							{	
								m_errorNum=0;
								return 1;
							}
							else
								return 0;
				case 0	:	break;
				default	:	buffer += inbuff;
							break;
			}
		}while(NumOfChars>0);
	}

	return 1;
}


int CPopCtrl::SendRemote(CString buffer, int TimeOut)
{
	setsockopt(skt,SOL_SOCKET,SO_SNDTIMEO,(const char *)&TimeOut,sizeof(TimeOut));
	if (send(skt, buffer.GetBuffer(buffer.GetLength()), buffer.GetLength(), 0)<0) 
	{
		m_errorNum = WSAGetLastError() - WSABASEERR;
		if(m_errorNum==60)	//Timeout
		{
			m_errorNum=0;
			return 1;
		}
		else
			return 0;
	}
	return 1;
}


int CPopCtrl::ConnectRemote(CString IPAdrs)
{
	struct 	sockaddr_in server_addr;
	CString	msgbuffer;

	server_addr.sin_family=AF_INET;			
	server_addr.sin_addr.s_addr = inet_addr(IPAdrs.GetBuffer(60));
	server_addr.sin_port=htons(110);   //POP3 Port

	if  (connect(skt, (struct sockaddr far *)&server_addr,sizeof(server_addr))==-1) 
	{
		m_errorNum = WSAGetLastError() - WSABASEERR;
		if(m_errorNum==60)	//Timeout
		{
			m_errorNum=0;
			return 1;
		}
		else
			return 0;
	}
	
	if(!RecvRemote(msgbuffer,1000)) return 0;
	if(msgbuffer.Left(3)!="+OK")
	{
		m_errorNum = 220;
		return 0;
	}

	return 1;
}


int CPopCtrl::CloseRemote()
{	
	CString	msgbuffer;	
	
	//Send QUIT to end conversation
	msgbuffer = "QUIT\n";

	if(!SendRemote(msgbuffer,500)) return 0;
	if(!RecvRemote(msgbuffer,0)) return 0;
	if(msgbuffer.Left(3) != "+OK")
	{
		m_errorNum = 225;
		return 0;
	}

	shutdown(skt,0);
	WSACleanup();
	return 1;
}

void CPopCtrl::OnErrorNumChanged() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
}

void CPopCtrl::OnUserNameChanged() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
}

void CPopCtrl::OnPasswordChanged() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
}

void CPopCtrl::OnPopSrvrAdrsChanged() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
}

BSTR CPopCtrl::ListMail() 
{
	// TODO: Add your dispatch handler code here
	CString s;
	CString msgbuffer;

	m_errorNum = 0;

	msgbuffer = "LIST\n";

	if(!SendRemote(msgbuffer,500)) return 0;
	if(!RecvRemote(msgbuffer,0)) return 0;
	if(msgbuffer.Left(3)!="+OK")
	{
		m_errorNum = 222;
		return 0;
	}

	if(!RecvRemote(msgbuffer,2500)) return 0;
	s = msgbuffer;

//	offset = msgbuffer.Find("\n");	
//	s = msgbuffer.Mid(offset+1,msgbuffer.GetLength()-(offset+1));
	
	return s.AllocSysString();
}

short CPopCtrl::DelMail(short msgnum) 
{
	// TODO: Add your dispatch handler code here

	CString msgbuffer;
	char	tempstr[10];

	m_errorNum = 0;

	sprintf(tempstr,"%d",msgnum);

	msgbuffer = "DELE ";
	msgbuffer += tempstr;
	msgbuffer += "\n";

	if(!SendRemote(msgbuffer,500)) return 0;
	if(!RecvRemote(msgbuffer,0)) return 0;
	if(msgbuffer.Left(3)!="+OK")
	{
		m_errorNum = 226;
		return 0;
	}

	return 1;
}

short CPopCtrl::UnDelMail() 
{
	// TODO: Add your dispatch handler code here

	CString msgbuffer;
	
	m_errorNum = 0;

	msgbuffer = "RSET\n";
	
	if(!SendRemote(msgbuffer,500)) return 0;
	if(!RecvRemote(msgbuffer,0)) return 0;
	if(msgbuffer.Left(3)!="+OK")
	{
		m_errorNum = 228;
		return 0;
	}

	return 1;
}


BSTR CPopCtrl::GetMail(short msgnum) 
{
	// TODO: Add your dispatch handler code here

	CString s;
	CString msgbuffer;
	char	tempstr[10];

	m_errorNum = 0;

	sprintf(tempstr,"%d",msgnum);

	msgbuffer = "RETR ";
	msgbuffer += tempstr;
	msgbuffer += "\n";

	if(!SendRemote(msgbuffer,500)) return 0;
	if(!RecvRemote(msgbuffer,0)) return 0;
	if(msgbuffer.Left(3)!="+OK")
	{
		m_errorNum = 227;
		return 0;
	}
	
	if(!RecvRemote(msgbuffer,2000)) return 0;
  	s = msgbuffer;

//	offset = msgbuffer.Find("\n");	
//	s = msgbuffer.Mid(offset+1,msgbuffer.GetLength()-(offset+1));

	return s.AllocSysString();
}

BSTR CPopCtrl::GetStatus() 
{
	// TODO: Add your dispatch handler code here
	CString s;
	CString msgbuffer;

	m_errorNum = 0;

	msgbuffer = "STAT\n";

	if(!SendRemote(msgbuffer,500)) return 0;
	if(!RecvRemote(msgbuffer,0)) return 0;
	if(msgbuffer.Left(3)!="+OK")
	{
		m_errorNum = 221;
		return 0;
	}

	s = msgbuffer.Mid(4,msgbuffer.GetLength());

	return s.AllocSysString();
}


BSTR CPopCtrl::POPLogon() 
{
	// TODO: Add your dispatch handler code here
	CString s;
	CString msgbuffer;

	m_errorNum = 0;

	if(!StartSockets()) return 0;

	if(!OpenSocket()) return 0;

	if(!ConnectRemote(m_popSrvrAdrs)) return 0;

	msgbuffer = "USER " + m_userName + "\n";
	if(!SendRemote(msgbuffer,500)) return 0;
	if(!RecvRemote(msgbuffer,0)) return 0;
	if(msgbuffer.Left(3)!="+OK")
	{
		m_errorNum = 223;
		return 0;
	}

	msgbuffer = "PASS " + m_password + "\n";
	if(!SendRemote(msgbuffer,500)) return 0;
	if(!RecvRemote(msgbuffer,0)) return 0;
	if(msgbuffer.Left(3)!="+OK")
	{
		m_errorNum = 224;
		return 0;
	}

	s = msgbuffer.Mid(4,msgbuffer.GetLength());

	return s.AllocSysString();	
}

		
short CPopCtrl::POPLogoff() 
{
	// TODO: Add your dispatch handler code here
	m_errorNum = 0;

	if(!CloseRemote()) return 0;
	return 0;
}




