// smtpctl.cpp : Implementation of the CSmtpCtrl OLE control class.

#include "stdafx.h"
#include "mail.h"
#include "smtpctl.h"
#include "smtpppg.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNCREATE(CSmtpCtrl, COleControl)


/////////////////////////////////////////////////////////////////////////////
// Message map

BEGIN_MESSAGE_MAP(CSmtpCtrl, COleControl)
	//{{AFX_MSG_MAP(CSmtpCtrl)
	// NOTE - ClassWizard will add and remove message map entries
	//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG_MAP
	ON_OLEVERB(AFX_IDS_VERB_PROPERTIES, OnProperties)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// Dispatch map

BEGIN_DISPATCH_MAP(CSmtpCtrl, COleControl)
	//{{AFX_DISPATCH_MAP(CSmtpCtrl)
	DISP_PROPERTY_NOTIFY(CSmtpCtrl, "OrigAdrs", m_origAdrs, OnOrigAdrsChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CSmtpCtrl, "SmtpSrvrAdrs", m_smtpSrvrAdrs, OnSmtpSrvrAdrsChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CSmtpCtrl, "ErrorNum", m_errorNum, OnErrorNumChanged, VT_I2)
	DISP_PROPERTY_NOTIFY(CSmtpCtrl, "DestUserList", m_destUserList, OnDestUserListChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CSmtpCtrl, "MailData", m_mailData, OnMailDataChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CSmtpCtrl, "OrigName", m_origName, OnOrigNameChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CSmtpCtrl, "Subject", m_subject, OnSubjectChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CSmtpCtrl, "DomainName", m_domainName, OnDomainNameChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CSmtpCtrl, "MailDate", m_mailDate, OnMailDateChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CSmtpCtrl, "CCUserList", m_cCUserList, OnCCUserListChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CSmtpCtrl, "MailTime", m_mailTime, OnMailTimeChanged, VT_BSTR)
	DISP_FUNCTION(CSmtpCtrl, "SendMail", SendMail, VT_I2, VTS_NONE)
	//}}AFX_DISPATCH_MAP
	DISP_FUNCTION_ID(CSmtpCtrl, "AboutBox", DISPID_ABOUTBOX, AboutBox, VT_EMPTY, VTS_NONE)
END_DISPATCH_MAP()


/////////////////////////////////////////////////////////////////////////////
// Event map

BEGIN_EVENT_MAP(CSmtpCtrl, COleControl)
	//{{AFX_EVENT_MAP(CSmtpCtrl)
	// NOTE - ClassWizard will add and remove event map entries
	//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_EVENT_MAP
END_EVENT_MAP()


/////////////////////////////////////////////////////////////////////////////
// Property pages

// TODO: Add more property pages as needed.  Remember to increase the count!
BEGIN_PROPPAGEIDS(CSmtpCtrl, 1)
	PROPPAGEID(CSmtpPropPage::guid)
END_PROPPAGEIDS(CSmtpCtrl)


/////////////////////////////////////////////////////////////////////////////
// Initialize class factory and guid

IMPLEMENT_OLECREATE_EX(CSmtpCtrl, "MAIL.SmtpCtrl.1",
	0x2b42f74f, 0x3c62, 0x11ce, 0x96, 0xf, 0x52, 0x41, 0x53, 0x48, 0x0, 0x5)


/////////////////////////////////////////////////////////////////////////////
// Type library ID and version

IMPLEMENT_OLETYPELIB(CSmtpCtrl, _tlid, _wVerMajor, _wVerMinor)


/////////////////////////////////////////////////////////////////////////////
// Interface IDs

const IID BASED_CODE IID_DSMTP =
		{ 0x2b42f750, 0x3c62, 0x11ce, { 0x96, 0xf, 0x52, 0x41, 0x53, 0x48, 0x0, 0x5 } };
const IID BASED_CODE IID_DSMTPEvents =
		{ 0x2b42f751, 0x3c62, 0x11ce, { 0x96, 0xf, 0x52, 0x41, 0x53, 0x48, 0x0, 0x5 } };


/////////////////////////////////////////////////////////////////////////////
// Control type information

static const DWORD BASED_CODE _dwSMTPOleMisc =
	OLEMISC_INVISIBLEATRUNTIME |
	OLEMISC_ACTIVATEWHENVISIBLE |
	OLEMISC_SETCLIENTSITEFIRST |
	OLEMISC_INSIDEOUT |
	OLEMISC_CANTLINKINSIDE |
	OLEMISC_RECOMPOSEONRESIZE;

IMPLEMENT_OLECTLTYPE(CSmtpCtrl, IDS_SMTP, _dwSMTPOleMisc)


/////////////////////////////////////////////////////////////////////////////
// CSmtpCtrl::CSmtpCtrlFactory::UpdateRegistry -
// Adds or removes system registry entries for CSmtpCtrl

BOOL CSmtpCtrl::CSmtpCtrlFactory::UpdateRegistry(BOOL bRegister)
{
	if (bRegister)
		return AfxOleRegisterControlClass(
			AfxGetInstanceHandle(),
			m_clsid,
			m_lpszProgID,
			IDS_SMTP,
			IDB_SMTP,
			TRUE,                       //  Insertable
			_dwSMTPOleMisc,
			_tlid,
			_wVerMajor,
			_wVerMinor);
	else
		return AfxOleUnregisterClass(m_clsid, m_lpszProgID);
}


/////////////////////////////////////////////////////////////////////////////
// CSmtpCtrl::CSmtpCtrl - Constructor

CSmtpCtrl::CSmtpCtrl()
{
	InitializeIIDs(&IID_DSMTP, &IID_DSMTPEvents);

	// TODO: Initialize your control's instance data here.
}


/////////////////////////////////////////////////////////////////////////////
// CSmtpCtrl::~CSmtpCtrl - Destructor

CSmtpCtrl::~CSmtpCtrl()
{
	// TODO: Cleanup your control's instance data here.
}


/////////////////////////////////////////////////////////////////////////////
// CSmtpCtrl::OnDraw - Drawing function

void CSmtpCtrl::OnDraw(
			CDC* pdc, const CRect& rcBounds, const CRect& rcInvalid)
{
	// TODO: Replace the following code with your own drawing code.
	CBitmap bitmap;
	BITMAP  bmp;
	CPictureHolder picHolder;
	CRect rcSrcBounds;

	// Load bitmap
	bitmap.LoadBitmap(IDB_SMTP);
	bitmap.GetObject(sizeof(BITMAP), &bmp);
	rcSrcBounds.right = bmp.bmWidth;
	rcSrcBounds.bottom = bmp.bmHeight;

	// Create picture and render
	picHolder.CreateFromBitmap((HBITMAP)bitmap.m_hObject, NULL, FALSE);
	picHolder.Render(pdc, rcBounds, rcSrcBounds);
}


/////////////////////////////////////////////////////////////////////////////
// CSmtpCtrl::DoPropExchange - Persistence support

void CSmtpCtrl::DoPropExchange(CPropExchange* pPX)
{
	ExchangeVersion(pPX, MAKELONG(_wVerMinor, _wVerMajor));
	COleControl::DoPropExchange(pPX);

	// TODO: Call PX_ functions for each persistent custom property.

}


/////////////////////////////////////////////////////////////////////////////
// CSmtpCtrl::OnResetState - Reset control to default state

void CSmtpCtrl::OnResetState()
{
	COleControl::OnResetState();  // Resets defaults found in DoPropExchange

	// TODO: Reset any other control state here.
}


/////////////////////////////////////////////////////////////////////////////
// CSmtpCtrl::AboutBox - Display an "About" box to the user

void CSmtpCtrl::AboutBox()
{
	CDialog dlgAbout(IDD_ABOUTBOX_SMTP);
	dlgAbout.DoModal();
}


/////////////////////////////////////////////////////////////////////////////
// CSmtpCtrl message handlers
int CSmtpCtrl::StartSockets()
{
	WORD			wVersionRequested;
	WSADATA 		wsaData;

	wVersionRequested = MAKEWORD( 1, 1 );
	if ( WSAStartup( wVersionRequested, &wsaData ) != 0 ) 
	{
		m_errorNum = WSAGetLastError() - WSABASEERR;
		return 0;
	}
	return 1;
}

 	
int CSmtpCtrl::OpenSocket()
{
	skt = socket(AF_INET, SOCK_STREAM, 0);
	if(skt < 0)
	{
		m_errorNum = WSAGetLastError() - WSABASEERR;
		return 0;
	}
	return 1;
}


int CSmtpCtrl::RecvRemote(CString& buffer)
{
	int			NumOfChars;
	char 		inbuff[500];
		
	buffer.Empty();	
	memset(inbuff,0,sizeof(inbuff));
	NumOfChars = recv(skt, inbuff, sizeof(inbuff), 0);
	
	switch(NumOfChars)
	{
		case -1	:	m_errorNum = WSAGetLastError() - WSABASEERR;
					return 0;
		case 0	:	break;
		default	:	buffer = inbuff;
					break;
	}
	
	return 1;
}


int CSmtpCtrl::SendRemote(CString buffer)
{
	if (send(skt, buffer.GetBuffer(buffer.GetLength()), buffer.GetLength(), 0)<0) 
	{
		m_errorNum = WSAGetLastError() - WSABASEERR;
		return 0;
	}
	return 1;
}


int CSmtpCtrl::ConnectRemote(CString IPAdrs)
{
	struct 	sockaddr_in server_addr;
	CString	msgbuffer;

	server_addr.sin_family=AF_INET;			
	server_addr.sin_addr.s_addr = inet_addr(IPAdrs.GetBuffer(60));
	server_addr.sin_port=htons(IPPORT_SMTP);   

	//==============================================================
	//Connect to remote address
	if  (connect(skt, (struct sockaddr far *)&server_addr,sizeof(server_addr))==-1) 
	{
		m_errorNum =  WSAGetLastError() - WSABASEERR;
		return 0;
	}
	
	if(!RecvRemote(msgbuffer)) return 0;
	if(atoi(msgbuffer.GetBuffer(4)) != 220)
	{
		m_errorNum = 210;
		return 0;
	}

	//Send HELO to setup a conversation
	msgbuffer = "HELO " + m_domainName;
	msgbuffer += "\n";
	if(!SendRemote(msgbuffer)) return 0;
	if(!RecvRemote(msgbuffer)) return 0;
	if(atoi(msgbuffer.GetBuffer(4)) != 250)
	{
		m_errorNum = 213;
		return 0;
	}

	return 1;
}


int CSmtpCtrl::SendHeaderInfo(CString from, CString to, CString cc)
{
	CString	msgbuffer;
	int	offset, prevoffset;

	//==============================================================
	//Send MAIL FROM to prepare message send
	msgbuffer = "MAIL FROM:<" + from + ">\n";
	if(!SendRemote(msgbuffer)) return 0;
	if(!RecvRemote(msgbuffer)) return 0;
	if(atoi(msgbuffer.GetBuffer(4)) != 250)
	{
		m_errorNum = 211;
		return 0;
	}
	
	//==============================================================
	//Send RCPT TO to prepare message send

	//Send TOs
	prevoffset=0;
	for(offset=0;offset<to.GetLength();offset++)
	{
		if(offset==to.GetLength()-1)
		{
			msgbuffer = "RCPT TO:<" + to.Mid(prevoffset,offset-prevoffset+1) + ">\n";
			prevoffset=offset;
			if(!SendRemote(msgbuffer)) return 0;
			if(!RecvRemote(msgbuffer)) return 0;
			if(atoi(msgbuffer.GetBuffer(4)) != 250)
			{
				m_errorNum = 212;
				return 0;
			}	
		}

		if(to.GetAt(offset)==',')
		{
			msgbuffer = "RCPT TO:<" + to.Mid(prevoffset,offset-prevoffset) + ">\n";
			prevoffset=offset+1;
			if(!SendRemote(msgbuffer)) return 0;
			if(!RecvRemote(msgbuffer)) return 0;
			if(atoi(msgbuffer.GetBuffer(4)) != 250)
			{
				m_errorNum = 212;
				return 0;
			}	
		}
	}


	//Send CCs
	prevoffset=0;
	for(offset=0;offset<cc.GetLength();offset++)
	{
		if(offset==cc.GetLength()-1)
		{
			msgbuffer = "RCPT TO:<" + cc.Mid(prevoffset,offset-prevoffset+1) + ">\n";
			prevoffset=offset;
			if(!SendRemote(msgbuffer)) return 0;
			if(!RecvRemote(msgbuffer)) return 0;
			if(atoi(msgbuffer.GetBuffer(4)) != 250)
			{
				m_errorNum = 217;
				return 0;
			}	
		}

		if(cc.GetAt(offset)==',')
		{
			msgbuffer = "RCPT TO:<" + cc.Mid(prevoffset,offset-prevoffset) + ">\n";
			prevoffset=offset+1;
			if(!SendRemote(msgbuffer)) return 0;
			if(!RecvRemote(msgbuffer)) return 0;
			if(atoi(msgbuffer.GetBuffer(4)) != 250)
			{
				m_errorNum = 217;
				return 0;
			}	
		}
	}

	return 1;
}	
	

int CSmtpCtrl::StartData()
{
	CString	msgbuffer;
	
	//Send DATA to prepare message send
	msgbuffer="DATA\n";

	if(!SendRemote(msgbuffer)) return 0;
	if(!RecvRemote(msgbuffer)) return 0;
	if(atoi(msgbuffer.GetBuffer(4)) != 354)
	{
		m_errorNum = 214;
		return 0;
	}

	return 1;
}


int CSmtpCtrl::SendData(CString buffer)
{
	CString	msgbuffer;
	int	offset,prevoffset=0,copylength;
		
	//==============================================================
	//Send mail data to prepare message send
	if(buffer.GetLength() < 500)
	{
		buffer += "\n";
		if(!SendRemote(buffer.GetBuffer(buffer.GetLength()))) return 0;
	}
	else
	{
		for(offset=0;offset<buffer.GetLength();offset+=500)
		{
			copylength = buffer.GetLength() - offset;
			if(copylength < 500)
			{			
				msgbuffer = buffer.Mid(offset,copylength) + "\n";
			}
			else
			{
				msgbuffer = buffer.Mid(offset,500);
			}
			if(!SendRemote(msgbuffer)) return 0;
		}
	}

	return 1;
}


int CSmtpCtrl::CloseRemote()
{	
	CString	msgbuffer;	
	
	//Send final <.CR/LF>
	msgbuffer = ".\n";

	if(!SendRemote(msgbuffer)) return 0;
	if(!RecvRemote(msgbuffer)) return 0;
	if(atoi(msgbuffer.GetBuffer(4)) != 250)
	{
		m_errorNum = 215;
		return 0;
	}

	//Send QUIT to end conversation
	msgbuffer = "QUIT\n";

	if(!SendRemote(msgbuffer)) return 0;
	if(!RecvRemote(msgbuffer)) return 0;
	if(atoi(msgbuffer.GetBuffer(4)) != 221)
	{
		m_errorNum = 216;
		return 0;
	}

	shutdown(skt,0);
	WSACleanup();
	return 1;
}


void CSmtpCtrl::OnOrigAdrsChanged() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
}

void CSmtpCtrl::OnSmtpSrvrAdrsChanged() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
}

void CSmtpCtrl::OnErrorNumChanged() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
}

void CSmtpCtrl::OnDestUserListChanged() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
}

void CSmtpCtrl::OnMailDataChanged() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
}

void CSmtpCtrl::OnOrigNameChanged() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
}

void CSmtpCtrl::OnSubjectChanged() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
}

void CSmtpCtrl::OnDomainNameChanged() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
}

void CSmtpCtrl::OnMailDateChanged() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
}

void CSmtpCtrl::OnCCUserListChanged() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
}

void CSmtpCtrl::OnMailTimeChanged() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
}

int CSmtpCtrl::GetSendTime()
{
	SYSTEMTIME	sys_time;
	char	timebuff[10], datebuff[15];
	char	montharray[12][4] = {"JAN" , "FEB" , "MAR" , "APR" , "MAY" , "JUN" ,
                      			 "JUL" , "AUG" , "SEP" , "OCT" , "NOV" , "DEC" };

	GetSystemTime((LPSYSTEMTIME)&sys_time); 
	sprintf(timebuff,"%02d:%02d:%02d",sys_time.wHour,sys_time.wMinute,
		sys_time.wSecond);
	
	if(sys_time.wYear>1999)
		sys_time.wYear-=2000;
	else
		sys_time.wYear-=1900;

	sprintf(datebuff,"%02d %s %2d",sys_time.wDay,montharray[sys_time.wMonth-1],
		sys_time.wYear);
	//Use the following for date/time calcs in next version
	//strftime(timebuffer, sizeof(timebuffer), "%a %b %d %H:%M:%S %Y %Z", tmClock);

	m_mailDate = datebuff;
	m_mailTime = timebuff;

	return 1;
}

short CSmtpCtrl::SendMail() 
{
	// TODO: Add notification handler code
	CString msgbuffer;

	m_errorNum = 0;

	if(!StartSockets()) return 0;

	if(!OpenSocket()) return 0;

	if(!ConnectRemote(m_smtpSrvrAdrs)) return 0;

	if(!SendHeaderInfo(m_origAdrs,m_destUserList,m_cCUserList)) return 0;


	if(!StartData()) return 0;
		
	GetSendTime();
	
	msgbuffer = "Date: " + m_mailDate + " " + m_mailTime; 
	if(!SendData(msgbuffer)) return 0;

	msgbuffer = "From: " + m_origAdrs + " (" + m_origName + ")";
	if(!SendData(msgbuffer)) return 0;

	msgbuffer = "To: "+ m_destUserList;
	if(!SendData(msgbuffer)) return 0;

	msgbuffer = "Subject: "+ m_subject;
	if(!SendData(msgbuffer)) return 0;

	msgbuffer = "Cc: " + m_cCUserList;
	if(!SendData(msgbuffer)) return 0;

//	msgbuffer = "Reply-To: " + m_origAdrs;
//	if(!SendData(msgbuffer)) return 0;

	msgbuffer = "Mailer: Toupin Mailer Custom Control (SMTP/POP OCX)";
	if(!SendData(msgbuffer)) return 0;

	msgbuffer = m_mailData;
	if(!SendData(msgbuffer)) return 0;
		
	//Close sockets
	if(!CloseRemote()) return 0;
	
	return 1;
}

