// fingectl.cpp : Implementation of the CFingerCtrl OLE control class.

#include "stdafx.h"
#include "finger.h"
#include "fingectl.h"
#include "fingeppg.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNCREATE(CFingerCtrl, COleControl)


/////////////////////////////////////////////////////////////////////////////
// Message map

BEGIN_MESSAGE_MAP(CFingerCtrl, COleControl)
	//{{AFX_MSG_MAP(CFingerCtrl)
	// NOTE - ClassWizard will add and remove message map entries
	//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG_MAP
	ON_OLEVERB(AFX_IDS_VERB_PROPERTIES, OnProperties)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// Dispatch map

BEGIN_DISPATCH_MAP(CFingerCtrl, COleControl)
	//{{AFX_DISPATCH_MAP(CFingerCtrl)
	DISP_PROPERTY_NOTIFY(CFingerCtrl, "HostAdrs", m_hostAdrs, OnHostAdrsChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CFingerCtrl, "UserName", m_userName, OnUserNameChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CFingerCtrl, "ErrorNum", m_errorNum, OnErrorNumChanged, VT_I2)
	DISP_FUNCTION(CFingerCtrl, "GetUserInfo", GetUserInfo, VT_BSTR, VTS_NONE)
	//}}AFX_DISPATCH_MAP
	DISP_FUNCTION_ID(CFingerCtrl, "AboutBox", DISPID_ABOUTBOX, AboutBox, VT_EMPTY, VTS_NONE)
END_DISPATCH_MAP()


/////////////////////////////////////////////////////////////////////////////
// Event map

BEGIN_EVENT_MAP(CFingerCtrl, COleControl)
	//{{AFX_EVENT_MAP(CFingerCtrl)
	// NOTE - ClassWizard will add and remove event map entries
	//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_EVENT_MAP
END_EVENT_MAP()


/////////////////////////////////////////////////////////////////////////////
// Property pages

// TODO: Add more property pages as needed.  Remember to increase the count!
BEGIN_PROPPAGEIDS(CFingerCtrl, 1)
	PROPPAGEID(CFingerPropPage::guid)
END_PROPPAGEIDS(CFingerCtrl)


/////////////////////////////////////////////////////////////////////////////
// Initialize class factory and guid

IMPLEMENT_OLECREATE_EX(CFingerCtrl, "FINGER.FingerCtrl.1",
	0x7e8082a0, 0x3a9e, 0x11ce, 0x96, 0xf, 0x52, 0x41, 0x53, 0x48, 0x0, 0x5)


/////////////////////////////////////////////////////////////////////////////
// Type library ID and version

IMPLEMENT_OLETYPELIB(CFingerCtrl, _tlid, _wVerMajor, _wVerMinor)


/////////////////////////////////////////////////////////////////////////////
// Interface IDs

const IID BASED_CODE IID_DFinger =
		{ 0x7e8082a1, 0x3a9e, 0x11ce, { 0x96, 0xf, 0x52, 0x41, 0x53, 0x48, 0x0, 0x5 } };
const IID BASED_CODE IID_DFingerEvents =
		{ 0x7e8082a2, 0x3a9e, 0x11ce, { 0x96, 0xf, 0x52, 0x41, 0x53, 0x48, 0x0, 0x5 } };


/////////////////////////////////////////////////////////////////////////////
// Control type information

static const DWORD BASED_CODE _dwFingerOleMisc =
	OLEMISC_INVISIBLEATRUNTIME |
	OLEMISC_ACTIVATEWHENVISIBLE |
	OLEMISC_SETCLIENTSITEFIRST |
	OLEMISC_INSIDEOUT |
	OLEMISC_CANTLINKINSIDE |
	OLEMISC_RECOMPOSEONRESIZE;

IMPLEMENT_OLECTLTYPE(CFingerCtrl, IDS_FINGER, _dwFingerOleMisc)


/////////////////////////////////////////////////////////////////////////////
// CFingerCtrl::CFingerCtrlFactory::UpdateRegistry -
// Adds or removes system registry entries for CFingerCtrl

BOOL CFingerCtrl::CFingerCtrlFactory::UpdateRegistry(BOOL bRegister)
{
	if (bRegister)
		return AfxOleRegisterControlClass(
			AfxGetInstanceHandle(),
			m_clsid,
			m_lpszProgID,
			IDS_FINGER,
			IDB_FINGER,
			TRUE,                       //  Insertable
			_dwFingerOleMisc,
			_tlid,
			_wVerMajor,
			_wVerMinor);
	else
		return AfxOleUnregisterClass(m_clsid, m_lpszProgID);
}


/////////////////////////////////////////////////////////////////////////////
// CFingerCtrl::CFingerCtrl - Constructor

CFingerCtrl::CFingerCtrl()
{
	InitializeIIDs(&IID_DFinger, &IID_DFingerEvents);

	// TODO: Initialize your control's instance data here.
}


/////////////////////////////////////////////////////////////////////////////
// CFingerCtrl::~CFingerCtrl - Destructor

CFingerCtrl::~CFingerCtrl()
{
	// TODO: Cleanup your control's instance data here.
}


/////////////////////////////////////////////////////////////////////////////
// CFingerCtrl::OnDraw - Drawing function

void CFingerCtrl::OnDraw(
			CDC* pdc, const CRect& rcBounds, const CRect& rcInvalid)
{
	// TODO: Replace the following code with your own drawing code.
	CBitmap bitmap;
	BITMAP  bmp;
	CPictureHolder picHolder;
	CRect rcSrcBounds;

	// Load bitmap
	bitmap.LoadBitmap(IDB_FINGER);
	bitmap.GetObject(sizeof(BITMAP), &bmp);
	rcSrcBounds.right = bmp.bmWidth;
	rcSrcBounds.bottom = bmp.bmHeight;

	// Create picture and render
	picHolder.CreateFromBitmap((HBITMAP)bitmap.m_hObject, NULL, FALSE);
	picHolder.Render(pdc, rcBounds, rcSrcBounds);
}


/////////////////////////////////////////////////////////////////////////////
// CFingerCtrl::DoPropExchange - Persistence support

void CFingerCtrl::DoPropExchange(CPropExchange* pPX)
{
	ExchangeVersion(pPX, MAKELONG(_wVerMinor, _wVerMajor));
	COleControl::DoPropExchange(pPX);

	// TODO: Call PX_ functions for each persistent custom property.

}


/////////////////////////////////////////////////////////////////////////////
// CFingerCtrl::OnResetState - Reset control to default state

void CFingerCtrl::OnResetState()
{
	COleControl::OnResetState();  // Resets defaults found in DoPropExchange

	// TODO: Reset any other control state here.
}


/////////////////////////////////////////////////////////////////////////////
// CFingerCtrl::AboutBox - Display an "About" box to the user

void CFingerCtrl::AboutBox()
{
	CDialog dlgAbout(IDD_ABOUTBOX_FINGER);
	dlgAbout.DoModal();
}


/////////////////////////////////////////////////////////////////////////////
// CFingerCtrl message handlers

void CFingerCtrl::OnHostAdrsChanged() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
}

void CFingerCtrl::OnUserNameChanged() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
}

void CFingerCtrl::OnErrorNumChanged() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
}

BSTR CFingerCtrl::GetUserInfo() 
{
	// TODO: Add your dispatch handler code here

	CString 		s;
	int    			nListen_sd, nRc, nChars;
	struct 			sockaddr_in server_addr;
	WORD			wVersionRequested;
	WSADATA 		wsaData;
	char 			IPAddress[20], UName[20];
	char			RecvBuff[500];
	

	//Initialize error property
	m_errorNum = 0;

	//Startup the sockets library
	wVersionRequested = MAKEWORD( 1, 1 );
	m_errorNum = WSAStartup( wVersionRequested, &wsaData );
	if ( m_errorNum != 0 ) 
	{
		m_errorNum = WSAGetLastError() - WSABASEERR;
		return(0);
	}
	 		
	//Open a socket and get a handle
	nListen_sd= socket(AF_INET, SOCK_STREAM, 0);
	if(nListen_sd < 0)
	{
		m_errorNum = WSAGetLastError() - WSABASEERR;
		return(0);
	}

	//Prepare the address structure
	memcpy(IPAddress,m_hostAdrs.GetBuffer(20),19);

	server_addr.sin_family=AF_INET;
	server_addr.sin_addr.s_addr=inet_addr(IPAddress);
	server_addr.sin_port=htons(IPPORT_FINGER);   

	//Connect to a remote address
	nRc=connect(nListen_sd, (struct sockaddr far *)&server_addr, 
		sizeof(server_addr));
	if  (nRc==-1) 
	{
		m_errorNum = WSAGetLastError() - WSABASEERR;
		return(0);
	}
	
	//Prepare the name for submission and make a request for the
	//	address of the named host
	memcpy(UName,m_userName.GetBuffer(m_userName.GetLength()),19);	
	strcat(UName,"\r\n");

	m_errorNum = send(nListen_sd, UName, strlen(UName), 0);
	if  (m_errorNum==-1) 
	{
		m_errorNum = WSAGetLastError() - WSABASEERR;
		return(0);
	}
	
	do
	{
		memset(RecvBuff,0,sizeof(RecvBuff));
		nChars = recv(nListen_sd,RecvBuff,sizeof(RecvBuff),0);
	
		switch(nChars)
		{
			case -1	:	m_errorNum = WSAGetLastError() - WSABASEERR;
						return(0);
			case 0	:	break;
			default	:	s += RecvBuff;
						break;
		}

	}while(nChars >0);
	
	shutdown(nListen_sd,0);
	WSACleanup();

	return s.AllocSysString();
}


