// whoisctl.cpp : Implementation of the CWhoisCtrl OLE control class.

#include "stdafx.h"
#include "whois.h"
#include "whoisctl.h"
#include "whoisppg.h"


#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


IMPLEMENT_DYNCREATE(CWhoisCtrl, COleControl)


/////////////////////////////////////////////////////////////////////////////
// Message map

BEGIN_MESSAGE_MAP(CWhoisCtrl, COleControl)
	//{{AFX_MSG_MAP(CWhoisCtrl)
	// NOTE - ClassWizard will add and remove message map entries
	//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_MSG_MAP
	ON_OLEVERB(AFX_IDS_VERB_PROPERTIES, OnProperties)
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// Dispatch map

BEGIN_DISPATCH_MAP(CWhoisCtrl, COleControl)
	//{{AFX_DISPATCH_MAP(CWhoisCtrl)
	DISP_PROPERTY_NOTIFY(CWhoisCtrl, "WhoisHost", m_whoisHost, OnWhoisHostChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CWhoisCtrl, "WhoisRequest", m_whoisRequest, OnWhoisRequestChanged, VT_BSTR)
	DISP_PROPERTY_NOTIFY(CWhoisCtrl, "ErrorNum", m_errorNum, OnErrorNumChanged, VT_I2)
	DISP_FUNCTION(CWhoisCtrl, "GetInfo", GetInfo, VT_BSTR, VTS_NONE)
	//}}AFX_DISPATCH_MAP
	DISP_FUNCTION_ID(CWhoisCtrl, "AboutBox", DISPID_ABOUTBOX, AboutBox, VT_EMPTY, VTS_NONE)
END_DISPATCH_MAP()


/////////////////////////////////////////////////////////////////////////////
// Event map

BEGIN_EVENT_MAP(CWhoisCtrl, COleControl)
	//{{AFX_EVENT_MAP(CWhoisCtrl)
	// NOTE - ClassWizard will add and remove event map entries
	//    DO NOT EDIT what you see in these blocks of generated code !
	//}}AFX_EVENT_MAP
END_EVENT_MAP()


/////////////////////////////////////////////////////////////////////////////
// Property pages

// TODO: Add more property pages as needed.  Remember to increase the count!
BEGIN_PROPPAGEIDS(CWhoisCtrl, 1)
	PROPPAGEID(CWhoisPropPage::guid)
END_PROPPAGEIDS(CWhoisCtrl)


/////////////////////////////////////////////////////////////////////////////
// Initialize class factory and guid

IMPLEMENT_OLECREATE_EX(CWhoisCtrl, "WHOIS.WhoisCtrl.1",
	0x2b42f74a, 0x3c62, 0x11ce, 0x96, 0xf, 0x52, 0x41, 0x53, 0x48, 0x0, 0x5)


/////////////////////////////////////////////////////////////////////////////
// Type library ID and version

IMPLEMENT_OLETYPELIB(CWhoisCtrl, _tlid, _wVerMajor, _wVerMinor)


/////////////////////////////////////////////////////////////////////////////
// Interface IDs

const IID BASED_CODE IID_DWhois =
		{ 0x2b42f74b, 0x3c62, 0x11ce, { 0x96, 0xf, 0x52, 0x41, 0x53, 0x48, 0x0, 0x5 } };
const IID BASED_CODE IID_DWhoisEvents =
		{ 0x2b42f74c, 0x3c62, 0x11ce, { 0x96, 0xf, 0x52, 0x41, 0x53, 0x48, 0x0, 0x5 } };


/////////////////////////////////////////////////////////////////////////////
// Control type information

static const DWORD BASED_CODE _dwWhoisOleMisc =
	OLEMISC_INVISIBLEATRUNTIME |
	OLEMISC_ACTIVATEWHENVISIBLE |
	OLEMISC_SETCLIENTSITEFIRST |
	OLEMISC_INSIDEOUT |
	OLEMISC_CANTLINKINSIDE |
	OLEMISC_RECOMPOSEONRESIZE;

IMPLEMENT_OLECTLTYPE(CWhoisCtrl, IDS_WHOIS, _dwWhoisOleMisc)


/////////////////////////////////////////////////////////////////////////////
// CWhoisCtrl::CWhoisCtrlFactory::UpdateRegistry -
// Adds or removes system registry entries for CWhoisCtrl

BOOL CWhoisCtrl::CWhoisCtrlFactory::UpdateRegistry(BOOL bRegister)
{
	if (bRegister)
		return AfxOleRegisterControlClass(
			AfxGetInstanceHandle(),
			m_clsid,
			m_lpszProgID,
			IDS_WHOIS,
			IDB_WHOIS,
			TRUE,                       //  Insertable
			_dwWhoisOleMisc,
			_tlid,
			_wVerMajor,
			_wVerMinor);
	else
		return AfxOleUnregisterClass(m_clsid, m_lpszProgID);
}


/////////////////////////////////////////////////////////////////////////////
// CWhoisCtrl::CWhoisCtrl - Constructor

CWhoisCtrl::CWhoisCtrl()
{
	InitializeIIDs(&IID_DWhois, &IID_DWhoisEvents);

	// TODO: Initialize your control's instance data here.
}


/////////////////////////////////////////////////////////////////////////////
// CWhoisCtrl::~CWhoisCtrl - Destructor

CWhoisCtrl::~CWhoisCtrl()
{
	// TODO: Cleanup your control's instance data here.
}


/////////////////////////////////////////////////////////////////////////////
// CWhoisCtrl::OnDraw - Drawing function

void CWhoisCtrl::OnDraw(
			CDC* pdc, const CRect& rcBounds, const CRect& rcInvalid)
{
	// TODO: Replace the following code with your own drawing code.
	CBitmap bitmap;
	BITMAP  bmp;
	CPictureHolder picHolder;
	CRect rcSrcBounds;

	// Load bitmap
	bitmap.LoadBitmap(IDB_WHOIS);
	bitmap.GetObject(sizeof(BITMAP), &bmp);
	rcSrcBounds.right = bmp.bmWidth;
	rcSrcBounds.bottom = bmp.bmHeight;

	// Create picture and render
	picHolder.CreateFromBitmap((HBITMAP)bitmap.m_hObject, NULL, FALSE);
	picHolder.Render(pdc, rcBounds, rcSrcBounds);
}


/////////////////////////////////////////////////////////////////////////////
// CWhoisCtrl::DoPropExchange - Persistence support

void CWhoisCtrl::DoPropExchange(CPropExchange* pPX)
{
	ExchangeVersion(pPX, MAKELONG(_wVerMinor, _wVerMajor));
	COleControl::DoPropExchange(pPX);

	// TODO: Call PX_ functions for each persistent custom property.

}


/////////////////////////////////////////////////////////////////////////////
// CWhoisCtrl::OnResetState - Reset control to default state

void CWhoisCtrl::OnResetState()
{
	COleControl::OnResetState();  // Resets defaults found in DoPropExchange

	// TODO: Reset any other control state here.
}


/////////////////////////////////////////////////////////////////////////////
// CWhoisCtrl::AboutBox - Display an "About" box to the user

void CWhoisCtrl::AboutBox()
{
	CDialog dlgAbout(IDD_ABOUTBOX_WHOIS);
	dlgAbout.DoModal();
}


/////////////////////////////////////////////////////////////////////////////
// CWhoisCtrl message handlers

void CWhoisCtrl::OnWhoisHostChanged() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
}

void CWhoisCtrl::OnWhoisRequestChanged() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
}

BSTR CWhoisCtrl::GetInfo() 
{
	// TODO: Add your dispatch handler code here
	CString s;
	int    			nListen_sd, nRc, nChars;
	struct 			sockaddr_in server_addr;
	WORD			wVersionRequested;
	WSADATA 		wsaData;
	char 			IPAddress[50], WhoisInfo[50];
	char			RecvBuff[500];
	

	//Initialize error property
	m_errorNum = 0;

	//Startup the sockets library
	wVersionRequested = MAKEWORD( 1, 1 );
	m_errorNum = WSAStartup( wVersionRequested, &wsaData );
	if ( m_errorNum != 0 ) 
	{
		m_errorNum = WSAGetLastError() - WSABASEERR;
		return(0);
	}
	 		
	//Open a socket and get a handle
	nListen_sd= socket(AF_INET, SOCK_STREAM, 0);
	if(nListen_sd < 0)
	{
		m_errorNum = WSAGetLastError() - WSABASEERR;
		return(0);
	}

	//Prepare the address structure
	memcpy(IPAddress,m_whoisHost.GetBuffer(20),19);

	server_addr.sin_family=AF_INET;
	server_addr.sin_addr.s_addr=inet_addr(IPAddress);
	server_addr.sin_port=htons(IPPORT_WHOIS);   

	//Connect to a remote address
	nRc=connect(nListen_sd, (struct sockaddr far *)&server_addr, 
		sizeof(server_addr));
	if  (nRc==-1) 
	{
		m_errorNum = WSAGetLastError() - WSABASEERR;
		return(0);
	}
	
	//Prepare the name for submission and make a request for the
	//	address of the named host
	memcpy(WhoisInfo,m_whoisRequest.GetBuffer(m_whoisRequest.GetLength()),19);	
	strcat(WhoisInfo,"\r\n");

	m_errorNum = send(nListen_sd, WhoisInfo, strlen(WhoisInfo), 0);
	if  (m_errorNum==-1) 
	{
		m_errorNum = WSAGetLastError() - WSABASEERR;
		return(0);
	}
	
	do
	{
		memset(RecvBuff,0,sizeof(RecvBuff));
		nChars = recv(nListen_sd,RecvBuff,sizeof(RecvBuff),0);
	
		switch(nChars)
		{
			case -1	:	m_errorNum = WSAGetLastError() - WSABASEERR;
						return(0);
			case 0	:	break;
			default	:	s += RecvBuff;
						break;
		}

	}while(nChars >0);
	
	shutdown(nListen_sd,0);
	WSACleanup();

	return s.AllocSysString();
}

void CWhoisCtrl::OnErrorNumChanged() 
{
	// TODO: Add notification handler code

	SetModifiedFlag();
}
