/******************************************************************************
*                                                                             *
*  Basics for using a ListView common control. This creates a control, adds   *
*  some icon images and allows the text and image for each item to be changed *
*  as selected by various menu items.                                         *
*                                                                             *
*   Public domain by Mark Gamber. In using the program or any included part,  *
*   the user assumes full responsibility for it's use and may not hold the    *
*   author liable for any loss or damage. If unable to accept this            *
*   restriction, the software and all included parts muct be destroyed.       *
******************************************************************************/

#define WIN32_LEAN_AND_MEAN
#include "windows.h"
#include "commctrl.h"

// ============================================================================
//  Function prototypes
// ============================================================================

BOOL WINAPI MainDlgProc( HWND, UINT, WPARAM, LPARAM );
BOOL WINAPI GetTextDlgProc( HWND, UINT, WPARAM, LPARAM );
BOOL CreateListview( HWND );
BOOL AddListviewItems( HWND );

// ============================================================================
//  Global variables
// ============================================================================

HINSTANCE hInst;

// ============================================================================
//  Program entry point
// ============================================================================

int APIENTRY WinMain( HINSTANCE hInstance, HINSTANCE hPrev, LPSTR lpCmd,
                      int nShow )
{
   hInst = hInstance;                        //  Save instance handle to global
   InitCommonControls();                  //  and enable common control library
                                                //  Main window is a dialog box
   DialogBox( hInst, MAKEINTRESOURCE( 10000 ), NULL, MainDlgProc );
   return( FALSE );
}

// ============================================================================
//  MainDlgProc(): Main window made of a dialog box
// ============================================================================

BOOL WINAPI MainDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
   switch( msg )
   {
      case WM_INITDIALOG:
         if( ! CreateListview( hDlg ) )             //  Create listview or exit
         {
            EndDialog( hDlg, TRUE );
            return( TRUE );
         }
         AddListviewItems( GetDlgItem( hDlg, 1000 ) );       //  Add some stuff
         return( TRUE );


      case WM_SIZE:                       //  Resize control if this is resized
         SetWindowPos( GetDlgItem( hDlg, 1000 ), NULL, 0, 0,
                       LOWORD( lParam ), HIWORD( lParam ),
                       SWP_NOMOVE | SWP_NOZORDER );
         break;


      case WM_COMMAND:
         if( wParam == IDCANCEL )
         {
            EndDialog( hDlg, TRUE );                 //  Close dialog on Cancel
            return( TRUE );
         }
         if( wParam >= 100 && wParam <= 103 )          //  Change listview view
         {
            DWORD dwValue;
                                               //  Get listview's current style
            dwValue = GetWindowLong( GetDlgItem( hDlg, 1000 ), GWL_STYLE );
            dwValue = dwValue & ~LVS_TYPEMASK;          //  Set style bits to 0

            if( wParam == 100 )                     //  Set new style bit based
               dwValue |= LVS_ICON;                       //  on menu selection
            if( wParam == 101 )
               dwValue |= LVS_SMALLICON;
            if( wParam == 102 )
               dwValue |= LVS_LIST;
            if( wParam == 103 )
               dwValue |= LVS_REPORT;
                                                //  Set listview style and exit
            SetWindowLong( GetDlgItem( hDlg, 1000 ), GWL_STYLE, dwValue );
            break;
         }
         if( wParam == 104 )
         {                              // Arrange items on menu item selection
            ListView_Arrange( GetDlgItem( hDlg, 1000 ), LVA_ALIGNLEFT );
            break;
         }
         if( wParam == 105 )                  //  Wanna give listview new text?
         {
            char szStr[ 128 ];
            int iCount, i;
            UINT uState;

                                          //  Are there any items there at all?
            if( ListView_GetSelectedCount( GetDlgItem( hDlg, 1000 ) ) != 1 )
               break;                                           //  Exit if not
                                                  //  How many items are there?
            iCount = ListView_GetItemCount( GetDlgItem( hDlg, 1000 ) );
            for( i = 0; i < iCount; i++ )            //  Loop through each item
            {                               //  Get focus state of current item
                             //  use focus since multiple items may be selected
               uState = ListView_GetItemState( GetDlgItem( hDlg, 1000 ),
                                               i, LVIS_FOCUSED );
               if( uState )           //  If this item has focus, get it's text
               {
                  ListView_GetItemText( GetDlgItem( hDlg, 1000 ), i, 0,
                                        szStr, 128 );
                                                  //  Now get new text for item
                  if( ! DialogBoxParam( hInst, MAKEINTRESOURCE( 10001 ), hDlg,
                                        GetTextDlgProc, (LPARAM)szStr ) )
                     break;                       //  Or exit if Cancel pressed
                               //  Apply new text to item and break for () loop
                  ListView_SetItemText( GetDlgItem( hDlg, 1000 ), i,
                                        0, szStr );
                  break;
               }
            }
            break;
         }                                        //  End of "new text" routine
         if( wParam >= 106 && wParam <= 110 )
         {
            LV_ITEM lvi;
            int iCount, i;
            UINT uState;

            if( ListView_GetSelectedCount( GetDlgItem( hDlg, 1000 ) ) != 1 )
               break;                                           //  Exit if not
                                                  //  How many items are there?
            iCount = ListView_GetItemCount( GetDlgItem( hDlg, 1000 ) );
            for( i = 0; i < iCount; i++ )            //  Loop through each item
            {                               //  Get focus state of current item
                             //  use focus since multiple items may be selected
               uState = ListView_GetItemState( GetDlgItem( hDlg, 1000 ),
                                               i, LVIS_FOCUSED );
               if( uState )           //  If this item has focus, get it's text
               {
                  lvi.mask = LVIF_IMAGE;             //  Only setting new image
                  lvi.iItem = i;                              //  For this item
                  lvi.iSubItem = 0;
                  lvi.iImage = wParam - 106;                //  Image is 0 to 4
                                                      // Set new image and exit
                  ListView_SetItem( GetDlgItem( hDlg, 1000 ), &lvi );
                  break;
               }
            }
            break;
         }
         break;


      case WM_NOTIFY:         //  This is received if an item is double-clicked
      {
         NMHDR *phdr = (NMHDR *)lParam;

         if( phdr->idFrom == 1000 )                   //  Coming from listview?
            if( phdr->code == NM_DBLCLK )       // If so, is it a double-click?
               PostMessage( hDlg, WM_COMMAND, 105, 0 );   //  Yup, post to self
                               //  Do the processing elsewhere, trigger it here
         break;
      }
   }
   return( FALSE );
}

// ============================================================================
//  CreateListview(), of course, creats and initializes the control
// ============================================================================

BOOL CreateListview( HWND hParent )
{
   HWND hList;
   RECT Rect;
   HICON hiconItem;
   HIMAGELIST himlLarge;
   HIMAGELIST himlSmall;
   int i;


   GetClientRect( hParent, &Rect );      // Make control the size of the parent
   hList = CreateWindow( WC_LISTVIEW, "", WS_BORDER |
                         WS_CHILD | LVS_ICON | WS_VISIBLE,
                         0, 0, Rect.right, Rect.bottom,
                         hParent, (HMENU)1000, hInst, NULL );      //  ID #1000
   if( ! hList )
      return( FALSE );
                //  Create two lists, one for 32x32 and another for 16x16 icons
   himlLarge = ImageList_Create( GetSystemMetrics( SM_CXICON ),
                                 GetSystemMetrics( SM_CYICON ),
                                 TRUE, 1, 1 ); 
   himlSmall = ImageList_Create( GetSystemMetrics( SM_CXSMICON ),
                                 GetSystemMetrics( SM_CYSMICON ),
                                 TRUE, 1, 1 );
   for( i = 0; i < 5; i++ )                    //  Add icons to each image list
   {
      hiconItem = LoadImage( hInst, MAKEINTRESOURCE( 1000 + i ),
                             IMAGE_ICON, 32, 32, LR_DEFAULTCOLOR );
      ImageList_AddIcon( himlLarge, hiconItem );
      DeleteObject( hiconItem );
      hiconItem = LoadImage( hInst, MAKEINTRESOURCE( 1005 + i ),
                             IMAGE_ICON, 16, 16, LR_DEFAULTCOLOR );
      ImageList_AddIcon( himlSmall, hiconItem ); 
      DeleteObject( hiconItem ); 
   }
                            //  Make the listview use the images lists and exit
   ListView_SetImageList( hList, himlLarge, LVSIL_NORMAL ); 
   ListView_SetImageList( hList, himlSmall, LVSIL_SMALL ); 
   return( TRUE );
}

// ============================================================================
//  AddListviewItems() adds a bunch of stuff to the listview control
// ============================================================================

BOOL AddListviewItems( HWND hList )
{
   LV_ITEM lvi; 
   LV_COLUMN lvc; 
   int i, iStatus;
   char szStr[ 32 ];
   RECT Rect;
   
   
   GetClientRect( hList, &Rect );                //  Get the listview RECT size
    
   lvc.mask = LVCF_FMT | LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM; 
   lvc.fmt = LVCFMT_LEFT;
   lvc.cx = Rect.right - Rect.left;                //  Make bar width of window
   lvc.pszText = "Item Status";
   lvc.iSubItem = 0;                   //  Add display column (for Report View)
   iStatus = ListView_InsertColumn( hList, 0, &lvc );
    
   lvi.mask = LVIF_IMAGE | LVIF_PARAM | LVIF_TEXT | LVIF_STATE;
   lvi.state = 0; 
   lvi.stateMask = LVIS_FOCUSED;               //  Set generic structure values
   lvi.pszText = szStr;

   for( i = 0; i < 20; i++ )                    //  Add 20 items to the control
   {
      wsprintf( szStr, "Icon #%d", i + 1 );          //  Name depends on number
      lvi.iImage = i % 5;                                          //  5 images
      lvi.iItem = i;
      lvi.iSubItem = 0; 
      lvi.lParam = 1;
      iStatus = ListView_InsertItem( hList, &lvi );     //  Add item to control
   }

   return( TRUE );
}

// ============================================================================
//  Dialog box used to get new listview item text
// ============================================================================

BOOL WINAPI GetTextDlgProc( HWND hDlg, UINT msg, WPARAM wParam, LPARAM lParam )
{
   switch( msg )
   {
      case WM_INITDIALOG:                 //  First, save passed string pointer
         SetProp( hDlg, MAKEINTATOM( 10000 ), (HANDLE)lParam );
         SetDlgItemText( hDlg, 100, (LPSTR)lParam );   //  Show any passed text
         return( TRUE );

      case WM_COMMAND:
         if( wParam == IDOK || wParam == IDCANCEL )
         {
            if( wParam == IDOK )              //  Get new text if OK is pressed
               if( ! GetDlgItemText( hDlg, 100,
                           (LPSTR)GetProp( hDlg, MAKEINTATOM( 10000 ) ),
                           128 ) )
                  break;                    //  Do nothing if no text specified

            RemoveProp( hDlg, MAKEINTATOM( 10000 ) );
            EndDialog( hDlg, ( wParam == IDOK ) );        //  Return TRUE on OK
            return( TRUE );
         }
         break;
   }
   return( FALSE );
}

// ============================================================================


