Attribute VB_Name = "SECURITY_inc"
Option Explicit

' definition for encrypt/decrypt
Public Const ENCRYPT_LEVEL_0 = 0
Public Const ENCRYPT_LEVEL_1 = 1
Public Const ENCRYPT_LEVEL_2 = 2
Public Const ENCRYPT_LEVEL_3 = 3
Public Const ENCRYPT_LEVEL_4 = 4

Public Const CRYPTO_KEY_TOO_SMALL = -1
Public Const CRYPTO_CANT_INIT_KEY = -2
Public Const CRYPTO_CANT_INIT_BUFFER = -11
Public Const CRYPTO_CANT_OPEN_FILEIN = -21
Public Const CRYPTO_CANT_CREATE_FILEOUT = -22
Public Const CRYPTO_ERROR_READING_FILEIN = -31
Public Const CRYPTO_ERROR1_WRITING_FILEOUT = -41
Public Const CRYPTO_ERROR2_WRITING_FILEOUT = -42
Public Const CRYPTO_ERROR1_WRITING_LASTBYTE = -51
Public Const CRYPTO_ERROR2_WRITING_LASTBYTE = -52
Public Const CRYPTO_BAD_LASTBYTE = -61

Public Const RUBY_MODE_MINIMUM = 1           ' speed is of the essence, security secondary.
Public Const RUBY_MODE_DESK_LOCK = 2         ' reasonable compromise of speed vs security.
Public Const RUBY_MODE_DEAD_BOLT = 4         ' default = probably good enough for most things.
Public Const RUBY_MODE_PORTABLE_SAFE = 5     ' security is more important than speed.
Public Const RUBY_MODE_ANCHORED_SAFE = 8     ' speed isn't much of a concern.
Public Const RUBY_MODE_BANK_VAULT = 10       ' your pentium has nothing better to do, anyway.
Public Const RUBY_MODE_FORT_KNOX = 16        ' be cool.

' definition for FILECRC32
Public Const OPEN_MODE_BINARY = 0
Public Const OPEN_MODE_TEXT = 1

#If Win16 Then

' structure for serialization
Type tagSERIALDATA
   Description1      As String * 50       'serialization description 1
   Description2      As String * 50       'serialization description 2
   Number            As Long              'serialization number
   Dummy             As String * 50       'reserved for future use
End Type

' structure for media-id
Type tagDOSMEDIAID
   InfoLevel            As Integer
   SerialNumber         As Long
   VolLabel             As String * 11
   FileSysType          As String * 8
End Type

#Else

' structure for serialization
Type tagSERIALDATA
   Description1      As String * 52       'serialization description 1
   Description2      As String * 52       'serialization description 2
   Number            As Long              'serialization number
   Dummy             As String * 52       'reserved for future use
End Type

' structure for dos media-id
Type tagDOSMEDIAID
   InfoLevel            As String * 2     'use cCVI for integer conversion
   SerialNumber         As String * 4     'use cCVL for long conversion
   VolLabel             As String * 11
   FileSysType          As String * 8
End Type

'  structure for get Media ID (Win95/WinNT)
Type tagMEDIAID
   VolumeName           As String
   VolumeSerialNumber   As Long
   SystemName           As String
   MaxNameLength        As Long
   FileSystemFlags      As Long
End Type

#End If

#If Win16 Then

Declare Function cGetVersion Lib "mcsec-16.dll" () As Single

Declare Function cIsSerial Lib "mcsec-16.dll" (ByVal File1 As String) As Integer
Declare Function cSerialGet Lib "mcsec-16.dll" (ByVal FILE As String, SERIALDATA As tagSERIALDATA) As Integer
Declare Function cSerialInc Lib "mcsec-16.dll" (ByVal FILE As String, ByVal Increment As Long) As Integer
Declare Function cSerialPut Lib "mcsec-16.dll" (ByVal FILE As String, SERIALDATA As tagSERIALDATA) As Integer
Declare Function cSerialRmv Lib "mcsec-16.dll" (ByVal FILE As String) As Integer

Declare Function cHashMD5 Lib "mcsec-16.dll" (Text As String) As String
Declare Function cRegistrationKey Lib "mcsec-16.dll" (ByVal RegString As String, ByVal RegCode As Long) As Long

Declare Function cFileCRC32 Lib "mcsec-16.dll" (ByVal lpFilename As String, ByVal Mode As Integer) As Long
Declare Function cStringCRC32 Lib "mcsec-16.dll" (Txt As String) As Long

Declare Function cDecrypt Lib "mcsec-16.dll" (Txt As String, Password As String, ByVal level As Integer) As String
Declare Function cEncrypt Lib "mcsec-16.dll" (Txt As String, Password As String, ByVal level As Integer) As String

Declare Function cFileDecrypt Lib "mcsec-16.dll" (ByVal File1 As String, ByVal File2 As String, Password As String, ByVal level As Integer) As Long
Declare Function cFileEncrypt Lib "mcsec-16.dll" (ByVal File1 As String, ByVal File2 As String, Password As String, ByVal level As Integer) As Long

Declare Function cDOSGetMediaID Lib "mcsec-16.dll" (ByVal nDrive As String, DOSMEDIAID As tagDOSMEDIAID) As Integer
Declare Function cDOSSetMediaID Lib "mcsec-16.dll" (ByVal nDrive As String, DOSMEDIAID As tagDOSMEDIAID) As Integer

Declare Function cGZIPFileCompress Lib "mcsec-16.dll" (ByVal File1 As String, ByVal File2 As String) As Long
Declare Function cGZIPFileExpand Lib "mcsec-16.dll" (ByVal File1 As String, ByVal File2 As String) As Long
Declare Function cGZIPStringCompress Lib "mcsec-16.dll" (Txt As String) As String
Declare Function cGZIPStringExpand Lib "mcsec-16.dll" (Txt As String) As String

Declare Function cRUBYdecrypt Lib "mcsec-16.dll" (Text As String, Key As String, ByVal Mode As Integer) As String
Declare Function cRUBYencrypt Lib "mcsec-16.dll" (Text As String, Key As String, ByVal Mode As Integer) As String
Declare Function cRUBYdecryptFile Lib "mcsec-16.dll" (ByVal FileIn As String, ByVal FileOut As String, Key As String, ByVal Mode As Integer) As Long
Declare Function cRUBYencryptFile Lib "mcsec-16.dll" (ByVal FileIn As String, ByVal FileOut As String, Key As String, ByVal Mode As Integer) As Long

#Else

Declare Function cGetVersion Lib "mcsec-32.dll" () As Single

Declare Function cIsSerial Lib "mcsec-32.dll" (ByVal File1 As String) As Integer
Declare Function cSerialGet Lib "mcsec-32.dll" (ByVal FILE As String, SERIALDATA As tagSERIALDATA) As Integer
Declare Function cSerialInc Lib "mcsec-32.dll" (ByVal FILE As String, ByVal Increment As Long) As Integer
Declare Function cSerialPut Lib "mcsec-32.dll" (ByVal FILE As String, SERIALDATA As tagSERIALDATA) As Integer
Declare Function cSerialRmv Lib "mcsec-32.dll" (ByVal FILE As String) As Integer

Declare Function cHashMD5 Lib "mcsec-32.dll" (Text As String) As String
Declare Function cRegistrationKey Lib "mcsec-32.dll" (ByVal RegString As String, ByVal RegCode As Long) As Long

Declare Function cFileCRC32 Lib "mcsec-32.dll" (ByVal lpFilename As String, ByVal Mode As Integer) As Long
Declare Function cStringCRC32 Lib "mcsec-32.dll" (Txt As String) As Long

Declare Function cDecrypt Lib "mcsec-32.dll" (Txt As String, Password As String, ByVal level As Integer) As String
Declare Function cEncrypt Lib "mcsec-32.dll" (Txt As String, Password As String, ByVal level As Integer) As String

Declare Function cFileDecrypt Lib "mcsec-32.dll" (ByVal File1 As String, ByVal File2 As String, Password As String, ByVal level As Integer) As Long
Declare Function cFileEncrypt Lib "mcsec-32.dll" (ByVal File1 As String, ByVal File2 As String, Password As String, ByVal level As Integer) As Long

Declare Function cGetMediaID Lib "mcsec-32.dll" (ByVal nDrive As String, MEDIAID As tagMEDIAID) As Integer
Declare Function cDOSGetMediaID Lib "mcsec-32.dll" (ByVal nDrive As String, DOSMEDIAID As tagDOSMEDIAID) As Integer
Declare Function cDOSSetMediaID Lib "mcsec-32.dll" (ByVal nDrive As String, DOSMEDIAID As tagDOSMEDIAID) As Integer

Declare Function cGZIPFileCompress Lib "mcsec-32.dll" (ByVal File1 As String, ByVal File2 As String) As Long
Declare Function cGZIPFileExpand Lib "mcsec-32.dll" (ByVal File1 As String, ByVal File2 As String) As Long
Declare Function cGZIPStringCompress Lib "mcsec-32.dll" (Txt As String) As String
Declare Function cGZIPStringExpand Lib "mcsec-32.dll" (Txt As String) As String

Declare Function cRUBYdecrypt Lib "mcsec-32.dll" (Text As String, Key As String, ByVal Mode As Integer) As String
Declare Function cRUBYencrypt Lib "mcsec-32.dll" (Text As String, Key As String, ByVal Mode As Integer) As String
Declare Function cRUBYdecryptFile Lib "mcsec-32.dll" (ByVal FileIn As String, ByVal FileOut As String, Key As String, ByVal Mode As Integer) As Long
Declare Function cRUBYencryptFile Lib "mcsec-32.dll" (ByVal FileIn As String, ByVal FileOut As String, Key As String, ByVal Mode As Integer) As Long

#End If
