// displays measured values as horizontal bar with coloured regions
// (c) 1997 B. Luevelsmeyer - Freeware, use for any purpose
// Usage: initially supply brushes to SetzeBalkenFarben() (terminate list with 0)
// when available supply values to Balken_SetVal()

// Variable names etc in german; sorry no time to translate

#include <windows.h>
#include <windowsx.h>

#include <malloc.h>

#include "balken.h"


static HINSTANCE this_DLL;


#define KlasseAnlegen(name)		                           \
	{ WNDCLASS wc;                                             \
	  wc.style = CS_OWNDC | CS_HREDRAW | CS_VREDRAW | CS_GLOBALCLASS;     \
	  wc.lpfnWndProc = name##Proc;                             \
	  wc.cbClsExtra = 0;                                       \
	  wc.cbWndExtra = sizeof(lp##name##_Property);             \
	  wc.hInstance = this_DLL;                                 \
	  wc.hIcon = 0;                                            \
	  wc.hCursor = 0;			                   \
	  wc.hbrBackground = 0;				           \
	  wc.lpszMenuName = 0;					   \
	  wc.lpszClassName = name##Klasse;                         \
	  if(!RegisterClass(&wc)) return FALSE;                    \
	}

#define PropertyPointer_Offset 0
#define MaxBalkenBereiche 10
typedef struct { double grenzen[MaxBalkenBereiche+1];          	// The values where colour changes; colour i lasts from value i to value i+1
		 HBRUSH farben[MaxBalkenBereiche];             	// the brushes for colour i; list terminated with 0
		 HDC dc;					// DC kept for performance
		 SIZE cli;					// to avoid frequent `GetClientRect()
	       } Balken_Property, *lpBalken_Property;
#define prop_pointer(balken) ((lpBalken_Property)GetWindowLong(balken,PropertyPointer_Offset))


static BOOL Balken_OnCreate(HWND balken, LPCREATESTRUCT lpCreateStruct)
	// you may supply lpBalken_Property as lpParam at CreateWindow() (dc calculated here anyway)
{
	lpBalken_Property zeiger = malloc(sizeof(Balken_Property));
	if(!zeiger) return FALSE;
	SetWindowLong(balken,PropertyPointer_Offset,(DWORD)zeiger);
	if(lpCreateStruct && lpCreateStruct->lpCreateParams) *zeiger = *(lpBalken_Property)lpCreateStruct->lpCreateParams;
	else *zeiger->farben = 0;
	zeiger->dc = GetDC(balken);
	// cli calculated at WM_SIZE (first soon after WM_CREATE)
	return TRUE;
}


static void Balken_OnPaint(HWND balken)
{
	RECT cli = {0,0};	// left and top always 0
	lpBalken_Property prop = prop_pointer(balken);

	// search index with max. value
	int index,maxindex=0;
	double maxval=prop->grenzen[0];
	while(prop->farben[maxindex]) if(prop->grenzen[++maxindex]>maxval) maxval=prop->grenzen[maxindex];

	// declare as repainted
	ValidateRect(balken,0);

	// get dimensions of Balken into right and bottom
	*(SIZE*)&cli.right = prop->cli;

	if(maxval>prop->grenzen[0])	// no paint with less than 2 Borders (i.e. less than 1 colour)
		{ int breite = cli.right;
		  cli.right = 0;
		  // paint regions up to max. index
		  for(index=0; index<maxindex; cli.left=cli.right, index++)
		  		// omit region if upper border lower than maximum encountered up to now
			if(prop->grenzen[index+1]>=prop->grenzen[index])
				{ cli.right = (prop->grenzen[index+1]-prop->grenzen[0])/(maxval-prop->grenzen[0])*breite;
				  FillRect(prop->dc,&cli,prop->farben[index]);
				}
		}
}


static void Balken_OnDestroy(HWND balken)
{
	free(prop_pointer(balken));
}


static void Balken_OnSize(HWND balken, UINT state, int cx, int cy)
{
	lpBalken_Property prop = prop_pointer(balken);
	prop->cli.cx = cx;
	prop->cli.cy = cy;
}

static LRESULT CALLBACK BalkenProc(HWND balken, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch(msg) { HANDLE_MSG(balken,WM_CREATE,Balken_OnCreate);
		      HANDLE_MSG(balken,WM_PAINT,Balken_OnPaint);
		      HANDLE_MSG(balken,WM_DESTROY,Balken_OnDestroy);
		      case WM_ERASEBKGND: return TRUE;
		      case WM_NCHITTEST: return HTTRANSPARENT;	// don't care for mouse; parent will do
		      HANDLE_MSG(balken,WM_SIZE,Balken_OnSize);
		      default: return DefWindowProc(balken,msg,wParam,lParam);
		    }
	
}


int APIENTRY LibMain(HINSTANCE hinstDLL, DWORD reason, LPVOID lpvReserved)
{
	switch(reason) { case DLL_PROCESS_ATTACH: this_DLL = hinstDLL;
						  KlasseAnlegen(Balken);
						  return TRUE;
			 case DLL_PROCESS_DETACH: UnregisterClass(BalkenKlasse,this_DLL);
			 			  return TRUE;
			 case DLL_THREAD_ATTACH:
			 case DLL_THREAD_DETACH: return TRUE;
			 default: return FALSE;
		       }
}


__declspec(dllexport) void WINAPI Balken_SetVal(const HWND balken, const int index, const double neuer_Wert)
	// get new value for one border
{
	lpBalken_Property prop = prop_pointer(balken);
	if(prop->grenzen[index] != neuer_Wert) { prop->grenzen[index] = neuer_Wert;
						 InvalidateRect(balken,0,FALSE);
					       }
}


__declspec(dllexport) void WINAPI SetzeBalkenFarben(const HWND balken, const HBRUSH * brushes)
	// get list of brushes, 0-terminated
{
	HBRUSH *ziel; for(ziel=prop_pointer(balken)->farben;*brushes;*ziel++=*brushes++) ;
}

