//**************************************
// 386.H
// by Alex Shmidt, Nov 1993
//
// useful defines for system structures
//**************************************

#ifndef _386_H
#define _386_H

#pragma pack (1)

// 80386/80486 exceptions
#define DIVIDE_ERROR     0      // fault
#define DEBUGGER_INT     1      // fault or trap
#define NONMASKABLE_INT  2      // interrupt
#define BREAKPOINT       3      // trap
#define OVERFLOW_INT     4      // trap - interrupt on overflow ( INTO )
#define BOUND_VIOLATION  5      // fault - array boundary violation ( BOUND )
#define INVALID_OPCODE   6      // fault
#define MATH_NOT_AVL     7      // fault - coprocessor not available
#define DOUBLE_FAULT     8      // abort
#define MATHSEG_OVERRUN  9      // coprocessor segment overrun (reserved on 486)
#define INVALID_TSS      10     // fault
#define SEG_NOT_PRESENT  11     // fault
#define STACK_EXCEPTION  12     // fault
#define GENERAL_PROTECT  13     // fault - General Protection Violation
#define PAGE_FAULT       14     // fault
#define RESERVED_EXCEPT  15
#define MATH_ERROR       16     // fault - coprocessor error
#define ALIGNMENT_CHECK  17     // fault - ( 80486 only )

// Task Segment State
typedef struct {
 WORD  TSS_Back_Link;      // Selector of the TSS previously executing
 WORD  padding1;
 DWORD TSS_esp0;           // ESP for RING 0 execution
 WORD  TSS_ss0;            // SS for RING 0 execution
 WORD  padding2;
 DWORD TSS_esp1;           // ESP for RING 1 execution
 WORD  TSS_ss1;            // SS for RING 1 execution
 WORD  padding3;
 DWORD TSS_esp2;           // ESP for RING 2 execution
 WORD  TSS_ss2;            // SS for RING 2 execution
 WORD  padding4;
 DWORD TSS_cr3;            // Task CR3 ( page directory address )
 DWORD TSS_eip;            // Task EIP
 DWORD TSS_EFlags;         // Task EFLAGS register
 DWORD TSS_eax;
 DWORD TSS_ecx;
 DWORD TSS_edx;
 DWORD TSS_ebx;
 DWORD TSS_esp;
 DWORD TSS_ebp;
 DWORD TSS_esi;
 DWORD TSS_edi;
 WORD  TSS_es;
 WORD  padding5;
 WORD  TSS_cs;
 WORD  padding6;
 WORD  TSS_ss;
 WORD  padding7;
 WORD  TSS_ds;
 WORD  padding8;
 WORD  TSS_fs;
 WORD  padding9;
 WORD  TSS_gs;
 WORD  padding10;
 WORD  TSS_LDTR;           // Selector for the task LDT
 WORD  padding11;
 WORD  TSS_Trap_Word;      // contains T bit ( trap on task switch )
 WORD  TSS_IOBP;           // a base of IO permission bitmap
}TSS_386,* PTSS_386,far *LPTSS_386;

// Segment Descriptors
typedef struct {
 WORD Seg_Desc_Limit_0_15;   // Limit bits 0 - 15
 WORD Seg_Desc_Base_0_15;    // Base BITS 0 - 15
 BYTE Seg_Desc_Base_16_23;   // Base BITS 16 - 23
 BYTE Seg_Desc_Access_Right; // Access right byte
 BYTE Seg_Desc_Gran_Byte;    // Granularity, etc
 BYTE Seg_Desc_Base_24_31;   // Base bits 24 - 31
}SEGDESCRIPTOR,*PSEGDESCTIPTOR,far *LPSEGDESCRIPTOR;

typedef struct {
 WORD Offset_O_15;            // entry point's offset, lower 16
 WORD Selector;               // entry point's selector
 BYTE DWord_Count;            // (D)Word parameter count
 BYTE Access_Rights;          // present, dpl, system, type
 WORD Offset_16_31;           // entry point's offset, upper 16
}CALLGATEDESCRPT,* PCALLGATEDESCRPT, far *LPCALLGATEDESCRPT;

// Descriptor types
#define  DESC_MASK    0x0f     /* TYPE field for system and gate descriptors */

#define DESC_TYPE_UNUSED            0       // invalid descriptor
#define DESC_TYPE_286_TSS           1       // 80286 TSS descriptor
#define DESC_TYPE_LDT               2
#define DESC_TYPE_BUSY_286_TSS      3
#define DESC_TYPE_286_CALL_GATE     4       // 286 call gate
#define DESC_TYPE_TASK_GATE         5
#define DESC_TYPE_286_INT_GATE      6
#define DESC_TYPE_286_TRAP_GATE     7
#define DESC_TYPE_386_TSS           9       // 80386/80486 TSS
#define DESC_TYPE_BUSY_386_TSS      11      // 80386/80486 busy TSS
#define DESC_TYPE_386_CALL_GATE     12      // 80386/80486 call gate
#define DESC_TYPE_386_INT_GATE      14      // 80386/80486 interrupt gate
#define DESC_TYPE_386_TRAP_GATE     15      // 80386/80486 trap gate

#define CALLGATE_DDCOUNT_MASK       0x1f    // dword count < 32

/* CR0 bit assignments */
#define  PE_Mask           0x1   /* 1 = Protected Mode */
#define  PE_Bit            0
#define  MP_Mask           0x2   /* 1 = Monitor Coprocessor */
#define  MP_Bit            1
#define  EM_Mask           0x4   /* 1 = Emulate Math Coprocessor */
#define  EM_Bit            2
#define  TS_Mask           0x8   /* 1 = Task Switch occured */
#define  TS_Bit            3
#define  ET_Mask           0x10  /* 1 = 387 present, 0 = 287 present */
#define  ET_Bit            4
#define  PG_Mask      0x80000000 /* 1 = paging enabled, 0 = paging disabled */
#define  PG_Bit            31


/* EFLAGs bit assignments */
#define  CF_Mask           0x1      /* Carry flag */
#define  CF_Bit            0
#define  PF_Mask           0x2      /* Parity flag */
#define  PF_Bit            2
#define  AF_Mask           0x10     /* Aux flag */
#define  AF_Bit            4
#define  ZF_Mask           0x40     /* Zero flag */
#define  ZF_Bit            6
#define  SF_Mask           0x80     /* Sign flag */
#define  SF_Bit            7
#define  TF_Mask           0x100    /* Trace flag */
#define  TF_Bit            8
#define  IF_Mask           0x200    /* Int flag */
#define  IF_Bit            9
#define  DF_Mask           0x400    /* Direction flag */
#define  DB_Bit            10
#define  OF_Mask           0x800    /* Overflow flag */
#define  OF_Bit            11
#define  IOPL_Mask         0x3000   /* IOPL flags */
#define  IOPL_Bit0         12
#define  IOPL_Bit1         13
#define  NT_Mask           0x4000   /* Nested task flag */
#define  NT_Bit            14
#define  RF_Mask           0x10000  /* Resume flag */
#define  RF_Bit            16
#define  VM_Mask           0x20000  /* Virtual Mode flag */
#define  VM_Bit            17


/*******************************************************************/
/* PAGE TABLE EQUATES */
/*******************************************************************/

/* Linear address breakdown */

#define LIN_DIR      0xffc00000        /* page directory */
#define LIN_PAGE     0x003ff000        /* page number */
#define LIN_OFFSET   0x00000fff        /* offset */

#define PAGE_FRAME_ADS_MASK (LIN_DIR | LIN_PAGE) // page frame adress 12 - 31
#define PAGE_PWT              8           // page write-through ( 486 only )
#define PAGE_PCD              0x10        // page cache disable ( 486 only )

#define PTABLE_SIZE           1024
#define P_SIZE                0x1000         /* page size */

/*******************************************************************

        Page table entry bits

*******************************************************************/

#define  P_PRES            0x1            /* page present bit (1 - present)*/
#define  P_WRITE           0x2            /* write access bit */
#define  P_USER            0x4            /* 1 - User mode , 0 - Supervisor */
#define  P_ACC             0x20           /* page accessed (write, read, fetch)*/
#define  P_DIRTY           0x40           /* page 'dirty'(written) */

#define  P_AVAIL           (P_PRES+P_WRITE+P_USER) /* avail to everyone & present */

/*******************************************************************

   Page types - definition of the OS reserved bits in the page table
               entry.
*******************************************************************/

#define  PG_TYPE            0xE00         /* TYPE bits in PTE */

/*******************************************************************

         Page types for page allocator calls (Windows specific)

*******************************************************************/
#define  PG_VM              0
#define  PG_SYS             1
#define  PG_RESERVED1       2
#define  PG_PRIVATE         3
#define  PG_RESERVED2       4
#define  PG_RELOCK          5             /* PRIVATE to MMGR */
#define  PG_INSTANCE        6
#define  PG_HOOKED          7
#define  PG_IGNORE          0xFFFFFFFF


/*******************************************************************

         Types for page table entries

*******************************************************************/
#define  PgT_VM              (PG_VM << 9)
#define  PgT_SYS             (PG_SYS << 9)
#define  PgT_RESERVED1       (PG_RESERVED1 << 9)
#define  PgT_PRIVATE         (PG_PRIVATE << 9)
#define  PgT_RESERVED2       (PG_RESERVED2 << 9)
#define  PgT_RELOCK          (PG_RELOCK << 9)
#define  PgT_INSTANCE        (PG_INSTANCE << 9)
#define  PgT_HOOKED          (PG_HOOKED << 9)

/*******************************************************************

  Definitions for the access byte in a descriptor

*******************************************************************/


/* Following fields are common to segment and control descriptors */

#define  D_PRES         0x80           /* present in memory */
#define  D_NOTPRES      0              /* not present in memory */

#define  D_DPL0         0              /* Ring 0 */
#define  D_DPL1         0x20           /* Ring 1 */
#define  D_DPL2         0x40           /* Ring 2 */
#define  D_DPL3         0x60           /* Ring 3 */

#define  D_SEG          0x10           /* Segment descriptor */
#define  D_CTRL         0              /* Control descriptor */

#define  D_GRAN_BYTE    000            /* Segment length is byte granular */
#define  D_GRAN_PAGE    0x80           /* Segment length is page granular */
#define  D_DEF16        000            /* Default operation size is 16 bits */
#define  D_DEF32        0x40           /* Default operation size is 32 bits */


/* Following fields are specific to segment descriptors */

#define  D_CODE         0x08           /* code */
#define  D_DATA         0              /* data */

#define  D_RX           0x02           /* if code, readable */
#define  D_X            0              /* if code, exec only */
#define  D_W            0x02           /* if data, writable */
#define  D_R            0              /* if data, read only */

#define  D_C            0x04           /* if code, conforming */
#define  D_E            0x04           /* if data, expand-down */

#define  D_ACCESSED     1              /* segment accessed bit */


/* Useful combination access rights bytes */

#define  GATE32_RING3   (D_PRES+D_DPL3+D_CTRL+DESC_TYPE_386_CALL_GATE)
#define  RW_Data_Type   (D_PRES+D_SEG+D_DATA+D_W)
#define  R_Data_Type    (D_PRES+D_SEG+D_DATA+D_R)
#define  Code_Type      (D_PRES+D_SEG+D_CODE+D_RX)

#define  D_PAGE32       (D_GRAN_PAGE+D_DEF32)      /* 32 bit Page granular */

/* Masks for selector fields */

#define  SELECTOR_MASK  0xfff8         /* selector index */
#define  SEL_LOW_MASK   0xf8           /* mask for low byte of sel indx */
#define  TABLE_MASK     0x04           /* table bit */
#define  RPL_MASK       0x03           /* privilige bits */
#define  RPL_CLR        ~0x03          /* clear ring bits */

#define MAKEBASE(base015, base1623, base2431) \
        ((DWORD)(((WORD)(base2431) << 8) | (WORD)(base1623)) << 16) | \
        ((WORD)(base015))

#define MAKELIMIT(limit015, limit1619) \
        ((DWORD)((WORD)(limit1619) & 0x000f) << 16) | (WORD)(limit015)

#define MAKELPG(dir,tab) (((DWORD)((dir) & 0x3ff) << 10 ) | ((tab) & 0x3ff))

#define MAKELIN(dir,tab,off) ((MAKELPG(dir,tab) << 12) | ((off) & 0xfff))

#endif // _386_H
