/**********************************************
GATEVIEW.H
by Alex Shmidt
**********************************************/

// controls
#define IDLB_PDIR               101
#define IDPB_PDIR               102
#define IDPB_GDT                103
#define IDPB_IDT                104
#define IDPB_LDT                105
#define IDPB_TASK               106
#define IDPB_CRDR               107
#define IDPB_VM                 108
#define IDPB_VXD                109
#define IDS_HDR                 110
#define IDS_GRAY                111
#define IDS_EVENTS              112
#define IDPB_FAULT              113

#define IDLB_EVENT              201
#define IDPB_CLEAR              202
#define IDPB_STOPVM             203
#define IDPB_HELP               204
#define IDPB_EXIT               205
#define IDPB_ONTOP              206

char *control_msg[] = {
   "Sys_Critical_Init",       //0
   "Device_Init",             //1
   "Init_Complete",           //2
   "Sys_VM_Init",             //3
   "Sys_VM_Terminate",        //4
   "System_Exit",             //5
   "Sys_Critical_Exit",       //6
   "Create_VM",               //7
   "VM_Critical_Init",        //8
   "VM_Init",                 //9
   "VM_Terminate",            //a
   "VM_Not_Executeable",      //b
   "Destroy_VM",              //c
   "VM_Suspend",              //d
   "VM_Resume",               //e
   "Set_Device_Focus",        //f
   "Begin_Message_Mode",      //10
   "End_Message_Mode",        //11
   "Reboot_Processor",        //12
   "Query_Destroy",           //13
   "Debug_Query",             //14
   "Begin_PM_App",            //15
   "End_PM_App",              //16
   "Device_Reboot_Notify",    //17
   "Crit_Reboot_Notify",      //18
   "Close_VM_Notify ",        //19
   "Power_Event" };           //1a

char *CB_Flags[17]={"VMStat_Exclusive",
               "VMStat_Background",
               "VMStat_Creating",
               "VMStat_Suspended",
               "VMStat_Not_Executeable",
               "VMStat_PM_Exec",
               "VMStat_PM_App",
               "VMStat_PM_Use32",
               "VMStat_VxD_Exec",
               "VMStat_High_Pri_Back",
               "VMStat_Blocked",
               "VMStat_Awakening",
               "VMStat_PageableV86",
               "VMStat_V86IntsLocked",
               "VMStat_TS_Sched",
               "VMStat_Idle",
               "VMStat_Closing"};
