/*********************************************************
  RINGO   -- Installable VxD
  RINGO.C -- startup code
  by Alex Shmidt, November 1993
*********************************************************/

/* define CALLGATE_386 to use CALLGATE.386 instead of LDT callgate approach */
//#define CALLGATE_386

#include <windows.h>
#include "386.h"
#include "callgate.h"
#include "lockhigh.h"

#ifdef CALLGATE_386
GATEPROC GetFirstCallGateVxD (FARPROC,BYTE);
void     DestroyInitGateVxD (WORD);
#endif

VOID WINAPI RingoInit(void);
VOID WINAPI SeeYouAtRing0(void);
GATEPROC    GetLdtRing0CallGate (FARPROC,BYTE,WORD);

GATEPROC GDT_Gate,LDT_Gate;

int FAR PASCAL LibMain ( HANDLE hInstance, WORD wDataSeg,
                         WORD cbHeapSize, LPSTR lpszCmdLine )
{
   if (!(GetWinFlags () & WF_ENHANCED))   /*VxDs exist in enhanced mode only*/
      return 0;

   /* get the first call gate */
#ifdef CALLGATE_386                 // get the GDT one from CALLGATE.386
   if (!(LDT_Gate = GetFirstCallGateVxD ((FARPROC)RingoInit,sizeof(GPARAM)/4)))
#else
   if (!(LDT_Gate = GetLdtRing0CallGate ((FARPROC)RingoInit,sizeof(GPARAM)/4,0)))
#endif
      return 0;

   GlobalPageLockHigh (SELECTOROF(SeeYouAtRing0));

   /*** get the GDT call gate ***/
   GDT_Gate = (GATEPROC)LDT_Gate (INITRINGO,sizeof(GPARAM)/4,(DWORD)SeeYouAtRing0);

   if (cbHeapSize)
      UnlockData (0);
   return (1);
}

int FAR PASCAL _export WEP (int nParameter)
{
   if (GDT_Gate)
   {
      (LDT_Gate)(EXITRINGO,HIWORD(GDT_Gate),0); // destroy our VxD
// free the first call gate
#ifdef CALLGATE_386
      DestroyInitGateVxD (HIWORD(LDT_Gate));
#else
      FreeSelector (HIWORD(LDT_Gate));
#endif
   }
   GlobalPageUnlock (SELECTOROF(SeeYouAtRing0));
   return (1);
}

/*** allocates a new LDT call gate selector or remaps the old one ***/
char vendor[] = "MS-DOS";
GATEPROC GetLdtRing0CallGate (FARPROC gproc, BYTE params,WORD gatesel)
{
#define VENDOR_SPECIFIC_API 0x168a
WORD ldt_map;
WORD (far * entryp)(void);
LPCALLGATEDESCRPT  CGateDescriptor;
WORD RW_ldt_map;   /* ldt map selector fixes segment read-only problem */
WORD CGateSelector;
DWORD initgate_flat;

   _asm {
   mov     si, offset vendor
   mov     ax, VENDOR_SPECIFIC_API
   int     2fh
   or      al, al
   jnz     no_vendor
   mov     word ptr [entryp], di          /* private entry point */
   mov     word ptr [entryp+2], es
   mov     ax, 100h
   }
   ldt_map = entryp();                    /* returns LDT map selector */
   _asm    jnc vendor_ok
no_vendor:
   return  0;

vendor_ok:

   // When run under SoftICE/W LDT alias returns read_only, give us a good one
   if (!(RW_ldt_map = AllocSelector(SELECTOROF((void FAR *)&GDT_Gate))))
      return 0;
   SetSelectorBase(RW_ldt_map, GetSelectorBase(ldt_map));
   SetSelectorLimit(RW_ldt_map, GetSelectorLimit(ldt_map));

   if ((CGateSelector = gatesel) == 0)          // we might already have one
      // Get a selector for the call gate
      if (!(CGateSelector = AllocSelector(0)))  // get a fresh one
      {
         FreeSelector (RW_ldt_map);
         return 0;
      }

   // create a pointer to write into the LDT
   CGateDescriptor = MAKELP(RW_ldt_map,CGateSelector & SELECTOR_MASK);

   //*************************************
   // build 32-bit ring 3-to-0 call gate *
   //*************************************
   initgate_flat = GetSelectorBase (SELECTOROF(gproc)) + (DWORD)OFFSETOF(gproc);
   CGateDescriptor->Offset_O_15 =  LOWORD (initgate_flat);
   CGateDescriptor->Offset_16_31 = HIWORD (initgate_flat);
   CGateDescriptor->Selector = 0x28;                // ring0 flat code seg
   CGateDescriptor->DWord_Count = params & CALLGATE_DDCOUNT_MASK;
   CGateDescriptor->Access_Rights = GATE32_RING3;   //pres,sys,dpl3,32CallGate

   FreeSelector (RW_ldt_map);                       // don't need you any more
   return ((GATEPROC)MAKELP(CGateSelector,0));
}

#ifdef CALLGATE_386
char cgate386[] = "CallGate";                      // CALLGATE.386 signature
/* CALLGATE.386 services */
#define CREATE_CALLGATE    0
#define DESTROY_CALLGATE   1
GATEPROC GetFirstCallGateVxD (FARPROC gproc, BYTE params)
{
WORD sel = SELECTOROF(gproc);
WORD off = OFFSETOF(gproc) ;

   _asm {
   push  es
   mov   si, offset cgate386
   mov   ax, 168ah
   mov   dx, CREATE_CALLGATE
   mov   es, sel;
   mov   di, off;
   mov   cl, params;
   int   2fh
   pop   es
   }
}

void DestroyInitGateVxD (WORD gatesel)
{
   _asm {
   mov   si, offset cgate386
   mov   ax, 168ah
   mov   dx, DESTROY_CALLGATE
   mov   cx, gatesel
   int   2fh
   }
}
#endif

/* gets system data structures */
DWORD WINAPI _export GetSys (LPVOID sysstruc)
{
   return (GDT_Gate)(Get386_Svc,0,(DWORD)sysstruc);
}

/* alternative to DPMI */
DWORD WINAPI _export MapPhysToLinear (DWORD physaddr, WORD mapsize)
{
   return (GDT_Gate)(PhysToLin_Svc,mapsize,physaddr);
}

/* connects out clients with the System_control stram */
void WINAPI _export GateRegisterWindow (HWND hwnd)
{
   (GDT_Gate)(Register_Hwnd_Svc,hwnd,(DWORD)(FARPROC)PostMessage);
}

void WINAPI _export GateUnregisterWindow (HWND hwnd)
{
   (GDT_Gate)(Unregister_Hwnd_Svc,0,0);
}

/* DOS fun */
void WINAPI _export NoDosBox (WORD stop)
{
   (GDT_Gate)(StopVM_Svc,(stop==7)?stop:0xFFFF,0);
}

DWORD WINAPI _export GateGetFault (WORD fault, DWORD lpfaultstruct)
{
   return ((GDT_Gate)(GetFault_Svc,fault,lpfaultstruct));
}
