/*
 *  This file forms part of "TKERN" - "Troy's Kernel for Windows".
 *
 *  Copyright (C) 1994  Troy Rollo <troy@cbme.unsw.EDU.AU>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	__STDIO_H
#define	__STDIO_H

#ifndef __TKPROTO
#include <sys/tkproto.h>
#endif

#ifndef	NULL
#ifdef __STDC__
#define NULL 0
#else
#define	NULL (void *) 0
#endif
#endif

#ifdef __cplusplus
extern "C" {
#endif
typedef	struct
{
	int	fd;
	unsigned flags;
	int	modes;

	/* Buffering stuff */

	unsigned char	ungetchar;
	int	bufsize;
	int	bufidx;
	int	readsize;
	unsigned char	*buffer;
}	FILE;

#define	__FL_ERROR	0x0001
#define	__FL_EOF	0x0002
#define	__FL_UNGET	0x0004
#define	__FL_MODIFIED	0x0008
#define	__FL_EMPTY	0x0010
#define	__FL_READ	0x0020
#define	__FL_WRITE	0x0040

extern	FILE	_iob[];

#define	stdin	(&_iob[0])
#define	stdout	(&_iob[1])
#define	stderr	(&_iob[2])

#define	EOF	((int) -1)

/* Buffered I/O functions. We supply these */
/* Input */
extern	int	ungetc __TKPROTO((char __c, FILE *__fp));
extern	int	getc __TKPROTO((FILE * __fp));
extern	int	scanf __TKPROTO((char const *__format, ...));
extern	int	fscanf __TKPROTO((FILE *__fp, char const *__format, ...));
extern	int	vfscanf __TKPROTO((FILE *__fp, char const *__format, void *__arglist));
extern	char	*fgets __TKPROTO((char *__buffer, int __size, FILE *__fp));
extern	char	*gets __TKPROTO((char *__buffer));
extern	int	fread __TKPROTO((char *__buffer, int __size, int __count, FILE *__fp));

/* Output */
extern	int	putc __TKPROTO((char __c, FILE *__fp));
extern	int	printf __TKPROTO((char const *__format, ...));
extern	int	fprintf __TKPROTO((FILE *__fp, char const *__format, ...));
extern	int	vfprintf __TKPROTO((FILE *__fp, char const *__format, void *__arglist));
extern	int	fputs __TKPROTO((char const *__buffer, FILE *__fp));
extern	int	puts __TKPROTO((char const *__buffer));
extern	int	fwrite __TKPROTO((char const *__buffer, int __size, int __count, FILE *__fp));

/* Open/close */
extern	FILE	*fopen __TKPROTO((char const *__filename, char const *__mode));
extern	FILE	*fdopen __TKPROTO((int __fd, char const *__mode));
extern	FILE	*freopen __TKPROTO((char const *__path, char const *__mode, FILE *__fp));
extern	int	fclose __TKPROTO((FILE *__fp));
extern	FILE	*tmpfile __TKPROTO((void));

/* Positioning */
extern	long	ftell __TKPROTO((FILE *__fp));
extern	long	fseek __TKPROTO((FILE *__fp, long __offset, int __from));
extern	void	rewind __TKPROTO((FILE *__fp));
extern	int	feof __TKPROTO((FILE *__fp));
extern	int	ferror __TKPROTO((FILE *__fp));

/* Buffering */
extern	int	fflush __TKPROTO((FILE *__fp));
extern	int	flushall __TKPROTO((FILE *__fp));

#define	fileno(f)	(f)->fd
#define	_fileno(f)	(f)->fd


#define	getchar() getc(stdin)
#define	ungetchar() ungetc(stdin)
#define putchar(c) putc(c, stdout)
#define	vprintf(f, v) vfprintf(stdout, f, v)
#define	vscanf(f, v) vfscanf(stdin, f, v)

/* Other stdio functions - we expect these to be supplied by the native
 * C library.
 */

extern	int	system __TKPROTO((char const *__command));
extern	void	perror __TKPROTO((char const *__string));
extern	char	*strerror __TKPROTO((int __errno));
extern	int	remove __TKPROTO((char const *__path));
extern	int	rename __TKPROTO((char const *__from, char const *__to));
extern	char	*sscanf __TKPROTO((char const *__string, char const *__format, ...));
extern	char	*sprintf __TKPROTO((char *__string, char const *__format, ...));
extern	char	*tmpnam __TKPROTO((char *__seed));
extern	int	vsprintf __TKPROTO((char *__string, char const *__format, void *__arglist));
extern	int	vsscanf __TKPROTO((char const *__string, char const *__format, void *__arglist));
		 

#ifdef __cplusplus
}
#endif

#endif /* __STDIO_H */
