/*
 *  This file forms part of "TKERN" - "Troy's Kernel for Windows".
 *
 *  Copyright (C) 1994  Troy Rollo <troy@cbme.unsw.EDU.AU>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __TKIOCTL_H
#define	__TKIOCTL_H

#ifndef __TKPROTO
#include <sys/tkproto.h>
#endif

#define	TK_IOCTL_PARM_TYPE	0xff000000l
#define	TK_IOCTL_PARM_SIZE	0x00ff0000l
#define	TK_IOCTL_DEV_ID		0x0000ff00l
#define	TK_IOCTL_NUMBER		0x000000ffl
#define	TK_IOCTL_READ_STRING	0x01000000l
#define	TK_IOCTL_WRITE_STRING	0x02000000l
#define	TK_IOCTL_READ_INT	0x04000000l
#define	TK_IOCTL_WRITE_INT	0x08000000l
#define	_IO(x, y)		(((unsigned long) (unsigned char) 'x'<<8) | y)
#define	_IORS(x, y, t)		(TK_IOCTL_READ_STRING | ((unsigned long) sizeof(t) << 16) | ((unsigned long) (unsigned char) 'x'<<8) | y)
#define	_IOWS(x, y, t)		(TK_IOCTL_WRITE_STRING | ((unsigned long) sizeof(t) << 16) | ('x'<<8) | y)
#define	_IORWS(x, y, t)		(TK_IOCTL_READ_STRING | TK_IOCTL_WRITE_STRING | ((unsigned long) sizeof(t) << 16) | ((unsigned long) (unsigned char) 'x'<<8) | y)
#define	_IOR(x, y, t)		(TK_IOCTL_READ_INT | ((unsigned long) sizeof(t) << 16) | ((unsigned long) (unsigned char) 'x'<<8) | y)
#define	_IOW(x, y, t)		(TK_IOCTL_WRITE_INT | ((unsigned long) sizeof(t) << 16) | ((unsigned long) (unsigned char) 'x'<<8) | y)
#define	_IOWRI(x, y, t)		(TK_IOCTL_READ_INT | TK_IOCTL_WRITE_INT | ((unsigned long) sizeof(t) << 16) | ((unsigned long) (unsigned char) 'x'<<8) | y)

int	ioctl __TKPROTO((int, long, ...));

#ifndef	__TKTTY_H
#include <sys\tty.h>
#endif

#endif /* __TKIOCTL_H */
