/*
 *  This file forms part of "TKERN" - "Troy's Kernel for Windows".
 *
 *  Copyright (C) 1994  Troy Rollo <troy@cbme.unsw.EDU.AU>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <fcntl.h>
#include <errno.h>
#include <io.h>

extern	int	nError;

int
file_open(	char const *pchFile,
		int	nMode,
		int	nAccess)
{
	int	nResult;

	nResult = open(pchFile, nMode, nAccess);
	nError = errno;
	return nResult;
}

int
file_close(	int	id)
{
	int	nResult;

	nResult = close(id);
	nError = errno;
	return nResult;
}

long
file_seek(	int	id,
		long	nPosition,
		int	nStart)
{
	long	nResult;

	nResult = lseek(id, nPosition, nStart);
	nError = errno;
	return nResult;
}

int
file_read(	int	id,
		char	*pchData,
		int	nBytes)
{
	int	nResult;

	nResult = read(id, pchData, nBytes);
	nError = errno;
	return nResult;
}

int
file_write(	int	id,
		char	const	*pchData,
		int	nBytes)
{
	int	nResult;

	nResult = write(id, pchData, nBytes);
	nError = errno;
	return nResult;
}

int
file_ioctl(void)
{
	nError = EINVAL;
	return -1;
}


