/*
 *  This file forms part of "TKERN" - "Troy's Kernel for Windows".
 *
 *  Copyright (C) 1994  Troy Rollo <troy@cbme.unsw.EDU.AU>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <windows.h>
#include <toolhelp.h>
#include <stdlib.h>
#include <memory.h>
#include <string.h>
#include <alloc.h>
#include <stdarg.h>
#include <errno.h>
#include <sys/tfile.h>
#include <sys/task.h>
#include <sys/ioctl.h>
#include <sys/wait.h>
#include <sys/tkern.h>

HWND	hwndManager = 0;

static	void task_is_dead(int	iTask);


/* Note that at the end of this we execute the tkern file manager.
 * this is a tkern executable which handles all access to all file
 * type objects. It has to be done this way because files and windows
 * and sockets etc are per task objects. Without doing this, we can't
 * pass objects from a parent task to a child task.
 */

#pragma argsused
BOOL	CALLBACK _export
LibMain(HINSTANCE hInstance,
	WORD	wDataSeg,
	WORD	cbHeapsize,
	LPSTR	strCmdLine)
{
	files_init();
	if (WinExec("tkfmangr", SW_HIDE) < 32)
	{
		files_cleanup();
		return FALSE;
	}
	process_init();
	return TRUE;
}



int far _export
tkern_register_manager(HWND hwndManager_)
{
	if (hwndManager)
		return 0;
	hwndManager = hwndManager_;
	tkern_wakeup_call();
	return 1;
}



void	far _export
tkern_wakeup_call(void)
{
	int	i, iTask;

	if (!nSleepers)
		return;
	for (i = 0; i < TNTASK; i++)
	{
		if (_tasks[i].nFlags & TF_ASLEEP)
		{
			for (iTask = i;
			     _tasks[iTask].hTask == HTASK_FLEDGELING;
			     iTask = _tasks[iTask].iParent);
			PostAppMessage(_tasks[iTask].hTask, TKWM_WAKEUP, 0, 0);
			_tasks[i].nFlags &= ~TF_ASLEEP;
			nSleepers--;
		}
	}
}

void	far _export
tkern_kill_ok(void)
{
	if (!nTasks)
	{
		SendMessage(hwndManager, TKWM_ALLDONE, 0, 0);
	}
}

int	far _export
tkern_errno(void)
{
	struct	task *pt;

	pt = GetTaskInfo();
	return pt->nError;
}

void	far _export
tkern_seterrno(int nError_, int	iTask)
{
	_tasks[iTask].nError = nError_;
}

