#if ! defined( SERIAL_PORT_CLASS_HEADER )

/*
** Author: Samuel R. Blackburn
** CI$: 76300,326
** Internet: sammy@sed.csc.com
**
** You can use it any way you like.
*/

#define SERIAL_PORT_CLASS_HEADER

class CSerialPort : public CObject
{
   private:

      void m_Initialize( DWORD input_buffer_size, DWORD output_buffer_size );

   protected:

      HANDLE m_FileHandle;

      DWORD m_ErrorCode;

      CDeviceControlBlock m_DeviceControlBlock;

      HANDLE m_ReceivedACharacterEvent;

      COverlapped m_ReadingOverlapped;

   public:

      CSerialPort();
     ~CSerialPort();

      enum Parity
      {
         parityNone  = 0,
         parityOdd   = 1,
         parityEven  = 2,
         parityMark  = 3,
         paritySpace = 4
      };

      /*
      ** Methods
      */

      BOOL OpenSynchronously();
      BOOL OpenAsynchronously();

      BOOL ReadSynchronously( CByteArray& where_to_put_bytes );
      BOOL ReadAsynchronously( const HANDLE event_to_set_when_data_comes_in );

      BOOL WriteSynchronously( const CByteArray& what_to_write );
      BOOL WriteAsynchronously( const HANDLE event_to_set_when_data_is_written, const CByteArray& what_to_write );

      virtual BOOL Close( void );
      virtual BOOL Open();

      virtual BOOL SetBaud( DWORD new_baud_rate );
      virtual BOOL SetParity( Parity new_parity_setting );
      BOOL SetStopBits( DWORD stop_bits );
      BOOL SetDataBits( DWORD data_bits );


      /*
      ** Helpers
      */

      inline  BOOL Read( CByteArray& where_to_put_bytes ) { return( ReadSynchronously( where_to_put_bytes ) ); }
      inline  BOOL Read( const HANDLE event ) { return( ReadAsynchronously( event ) ); }

      /*
      ** Operators
      ** << & >>
      */
};

#endif // SERIAL_PORT_CLASS_HEADER
