#include <wfc.h>
#pragma hdrstop

/*
** Author: Samuel R. Blackburn
** CI$: 76300,326
** Internet: sammy@sed.csc.com
**
** You can use it any way you like as long as you don't try to sell it.
**
** Any attempt to sell WFC in source code form must have the permission
** of the original author. You can produce commercial executables with
** WFC but you can't sell WFC.
**
** Copyright, 1995, Samuel R. Blackburn
**
** $Workfile: $
** $Revision: $
** $Modtime: $
*/

#if defined( _DEBUG )
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#define new DEBUG_NEW
#endif

/*
** CUINT64
*/

CUINT64::CUINT64()
{
   Empty();
}

CUINT64::CUINT64( const CUINT64& source )
{
   Empty();
   Copy( source );
}

CUINT64::CUINT64( const UINT64 * source )
{
   Empty();
   Copy( source );
}

void CUINT64::Copy( const CUINT64& source )
{
   Copy( (const UINT64 *) &source );
}

void CUINT64::Copy( const UINT64 * source )
{
   ASSERT( source != NULL );

   if ( source == NULL )
   {
      Empty();
      return;
   }

   lsw = source->lsw;
   msw = source->msw;
}

#if defined( _DEBUG )

void CUINT64::Dump( CDumpContext& dump_context ) const
{
   dump_context << " a CUINT64 at " << (void *) this << "\n";
   dump_context << "{\n";
   dump_context << "   lsw = " << lsw << "\n";
   dump_context << "   msw = " << msw << "\n";
   dump_context << "}\n";
}

#endif // _DEBUG

void CUINT64::Empty( void )
{
   lsw = 0;
   msw = 0;
}

/*
** CMTFDateTime
*/

CMTFDateTime::CMTFDateTime()
{
   Empty();
}

CMTFDateTime::CMTFDateTime( const CMTFDateTime& source )
{
   Empty();
   Copy( source );
}

CMTFDateTime::CMTFDateTime( const MTF_DATE_TIME * source )
{
   Empty();
   Copy( source );
}

void CMTFDateTime::Convert( CTime& destination ) const
{
   int year    = 0;
   int month   = 0;
   int day     = 0;
   int hours   = 0;
   int minutes = 0;
   int seconds = 0;

   BYTE temp_byte = 0;

   /* Compressed date structure for storing dates in minimal space on tape
   **  BYTE 0    BYTE 1    BYTE 2    BYTE 3    BYTE 4
   ** 76543210  76543210  76543210  76543210  76543210
   ** yyyyyyyy  yyyyyymm  mmdddddh  hhhhmmmm  mmssssss
   */

   /*
   ** Year
   */

   temp_byte = dt_field[ 1 ];

   bit_clear( temp_byte, 0 );
   bit_clear( temp_byte, 1 );

   year = ( 256 * dt_field[ 0 ] ) + temp_byte;

   TRACE( "CMTFDateTime::Convert() : year is %d\n", year );

   /*
   ** Month
   */

   temp_byte = dt_field[ 2 ] >> 6;

   month = ( dt_field[ 1 ] % 3 ) + temp_byte;

   TRACE( "CMTFDateTime::Convert() : month is %d\n", month );

   /*
   ** Day
   */

   temp_byte = dt_field[ 2 ];

   bit_clear( temp_byte, 7 );
   bit_clear( temp_byte, 6 );

   day = temp_byte >> 1;

   TRACE( "CMTFDateTime::Convert() : day is %d\n", day );

   /*
   ** Hours
   */

   temp_byte = dt_field[ 3 ];

   hours = temp_byte >> 4;

   if ( bit_test( dt_field[ 2 ], 0 ) == 1 )
   {
      hours += 16;
   }

   TRACE( "CMTFDateTime::Convert() : hours is %d\n", hours );

   /*
   ** Minutes
   */

   minutes = dt_field[ 4 ] >> 6;

   temp_byte = (BYTE) ( dt_field[ 3 ] % 16 );

   minutes += ( temp_byte << 2 );

   TRACE( "CMTFDateTime::Convert() : minutes is %d\n", minutes );

   /*
   ** Seconds
   */

   seconds = dt_field[ 4 ];

   bit_clear( seconds, 7 );
   bit_clear( seconds, 6 );

   TRACE( "CMTFDateTime::Convert() : seconds is %d\n", seconds );

   destination = CTime( year, month, day, hours, minutes, seconds );
}

void CMTFDateTime::Copy( const CTime& source )
{
   return;
}

void CMTFDateTime::Copy( const CMTFDateTime& source )
{
   Copy( (const MTF_DATE_TIME *) &source );
}

void CMTFDateTime::Copy( const MTF_DATE_TIME * source )
{
   ASSERT( source != NULL );

   if ( source == NULL )
   {
      Empty();
      return;
   }

   int index = 0;

   while( index < sizeof( dt_field ) )
   {
      dt_field[ index ] = source->dt_field[ index ];
      index++;
   }
}

#if defined( _DEBUG )

void CMTFDateTime::Dump( CDumpContext& dump_context ) const
{
   dump_context << " a CMTFDateTime at " << (void *) this << "\n";
   dump_context << "{\n";
   dump_context << "   dt_field[ 0 ] = " << dt_field[ 0 ] << "\n";
   dump_context << "   dt_field[ 1 ] = " << dt_field[ 1 ] << "\n";
   dump_context << "   dt_field[ 2 ] = " << dt_field[ 2 ] << "\n";
   dump_context << "   dt_field[ 3 ] = " << dt_field[ 3 ] << "\n";
   dump_context << "   dt_field[ 4 ] = " << dt_field[ 4 ] << "\n";
   dump_context << "}\n";
}

#endif // _DEBUG

void CMTFDateTime::Empty( void )
{
   dt_field[ 0 ] = 0;
   dt_field[ 1 ] = 0;
   dt_field[ 2 ] = 0;
   dt_field[ 3 ] = 0;
   dt_field[ 4 ] = 0;
}

/*
** CMTFTapeAddress
*/

CMTFTapeAddress::CMTFTapeAddress()
{
   Empty();
}

CMTFTapeAddress::CMTFTapeAddress( const CMTFTapeAddress& source )
{
   Empty();
   Copy( source );
}

CMTFTapeAddress::CMTFTapeAddress( const MTF_TAPE_ADDRESS * source )
{
   Empty();
   Copy( source );
}

void CMTFTapeAddress::Copy( const CMTFTapeAddress& source )
{
   Copy( (const MTF_TAPE_ADDRESS *) &source );
}

void CMTFTapeAddress::Copy( const MTF_TAPE_ADDRESS * source )
{
   ASSERT( source != NULL );

   if ( source == NULL )
   {
      Empty();
      return;
   }

   elmdata_size = source->elmdata_size;
   data_offset = source->data_offset;
}

#if defined( _DEBUG )

void CMTFTapeAddress::Dump( CDumpContext& dump_context ) const
{
   dump_context << " a CMTFTapeAddress at " << (void *) this << "\n";
   dump_context << "{\n";
   dump_context << "   elmdata_size = " << elmdata_size << "\n";
   dump_context << "   data_offset = " << data_offset << "\n";
   dump_context << "}\n";
}

#endif // _DEBUG

void CMTFTapeAddress::Empty( void )
{
   elmdata_size = 0;
   data_offset  = 0;
}

/*
** CMTFDataBlockHeader
*/

CMTFDataBlockHeader::CMTFDataBlockHeader()
{
   Empty();
}

CMTFDataBlockHeader::CMTFDataBlockHeader( const CMTFDataBlockHeader& source )
{
   Empty();
   Copy( source );
}

CMTFDataBlockHeader::CMTFDataBlockHeader( const MTF_DB_HDR * source )
{
   Empty();
   Copy( source );
}

void CMTFDataBlockHeader::Copy( const CMTFDataBlockHeader& source )
{
   Copy( (const MTF_DB_HDR *) &source );
}

void CMTFDataBlockHeader::Copy( const MTF_DB_HDR * source )
{
   ASSERT( source != NULL );

   if ( source == NULL )
   {
      Empty();
      return;
   }

   block_type[ 0 ] = source->block_type[ 0 ];
   block_type[ 1 ] = source->block_type[ 1 ];
   block_type[ 2 ] = source->block_type[ 2 ];
   block_type[ 3 ] = source->block_type[ 3 ];

   block_attribs      = source->block_attribs;
   offset_to_data     = source->offset_to_data;
   machine_os_id      = source->machine_os_id;
   machine_os_version = source->machine_os_version;

   displayable_size.lsw = source->displayable_size.lsw;
   displayable_size.msw = source->displayable_size.msw;

   logical_block_address.lsw = source->logical_block_address.lsw;
   logical_block_address.msw = source->logical_block_address.msw;

   session_id.lsw = source->session_id.lsw;
   session_id.msw = source->session_id.msw;

   control_block_id = source->control_block_id;
   
   string_storage.elmdata_size = source->string_storage.elmdata_size;
   string_storage.data_offset  = source->string_storage.data_offset;

   os_specific_data.elmdata_size = source->os_specific_data.elmdata_size;
   os_specific_data.data_offset  = source->os_specific_data.data_offset;

   string_type = source->string_type;
   reserved    = source->reserved;
   hdr_chksm   = source->hdr_chksm;
}

#if defined( _DEBUG )

void CMTFDataBlockHeader::Dump( CDumpContext& dump_context ) const
{
   TCHAR block_type_string[ 5 ];
   CMTFTapeAddress tape_address;
   CUINT64 temp_uint;

   block_type_string[ 0 ] = block_type[ 0 ];
   block_type_string[ 1 ] = block_type[ 1 ];
   block_type_string[ 2 ] = block_type[ 2 ];
   block_type_string[ 3 ] = block_type[ 3 ];
   block_type_string[ 4 ] = 0x00;

   dump_context << " a CMTFDataBlockHeader at " << (void *) this << "\n";
   dump_context << "{\n";
   dump_context << "   block_type[4]      = " << block_type_string  << "\n";
   dump_context << "   block_attribs      = " << block_attribs      << "\n";
   dump_context << "   offset_to_data     = " << offset_to_data     << "\n";
   dump_context << "   machine_os_id      = " << machine_os_id      << "\n";
   dump_context << "   machine_os_version = " << machine_os_version << "\n";

   dump_context << "   displayable_size is";
   temp_uint.Copy( &displayable_size );
   temp_uint.Dump( dump_context );

   dump_context << "   logical_block_address is";
   temp_uint.Copy( &logical_block_address );
   temp_uint.Dump( dump_context );

   dump_context << "   session_id is";
   temp_uint.Copy( &session_id );
   temp_uint.Dump( dump_context );
   dump_context << "   control_block_id = " << control_block_id << "\n";
   dump_context << "   string_storage is";
   tape_address.Copy( &string_storage );
   tape_address.Dump( dump_context );
   
   dump_context << "   os_specific_data is";
   tape_address.Copy( &string_storage );
   tape_address.Dump( dump_context );

   dump_context << "   string_type = " << string_type << "\n";
   dump_context << "   reserved    = " << reserved    << "\n";
   dump_context << "   hdr_chksm   = " << hdr_chksm   << "\n";
   dump_context << "}\n";
}

#endif // _DEBUG

void CMTFDataBlockHeader::Empty( void )
{
   block_type[ 0 ] = 0;
   block_type[ 1 ] = 0;
   block_type[ 2 ] = 0;
   block_type[ 3 ] = 0;

   block_attribs      = 0;
   offset_to_data     = 0;
   machine_os_id      = 0;
   machine_os_version = 0;

   displayable_size.lsw = 0;
   displayable_size.msw = 0;

   logical_block_address.lsw = 0;
   logical_block_address.msw = 0;

   session_id.lsw = 0;
   session_id.msw = 0;

   control_block_id = 0;
   
   string_storage.elmdata_size = 0;
   string_storage.data_offset  = 0;

   os_specific_data.elmdata_size = 0;
   os_specific_data.data_offset  = 0;

   string_type = 0;
   reserved    = 0;
   hdr_chksm   = 0;
}

/*
** CMTFTape
*/

CMTFTape::CMTFTape()
{
   Empty();
}

CMTFTape::CMTFTape( const CMTFTape& source )
{
   Empty();
   Copy( source );
}

CMTFTape::CMTFTape( const MTF_TAPE * source )
{
   Empty();
   Copy( source );
}

void CMTFTape::Copy( const CMTFTape& source )
{
   Copy( (const MTF_TAPE *) &source );
}

void CMTFTape::Copy( const MTF_TAPE * source )
{
   ASSERT( source != NULL );

   if ( source == NULL )
   {
      Empty();
      return;
   }

   block_header.block_type[ 0 ] = source->block_header.block_type[ 0 ];
   block_header.block_type[ 1 ] = source->block_header.block_type[ 1 ];
   block_header.block_type[ 2 ] = source->block_header.block_type[ 2 ];
   block_header.block_type[ 3 ] = source->block_header.block_type[ 3 ];

   block_header.block_attribs      = source->block_header.block_attribs;
   block_header.offset_to_data     = source->block_header.offset_to_data;
   block_header.machine_os_id      = source->block_header.machine_os_id;
   block_header.machine_os_version = source->block_header.machine_os_version;

   block_header.displayable_size.lsw = source->block_header.displayable_size.lsw;
   block_header.displayable_size.msw = source->block_header.displayable_size.msw;

   block_header.logical_block_address.lsw = source->block_header.logical_block_address.lsw;
   block_header.logical_block_address.msw = source->block_header.logical_block_address.msw;

   block_header.session_id.lsw = source->block_header.session_id.lsw;
   block_header.session_id.msw = source->block_header.session_id.msw;

   block_header.control_block_id = source->block_header.control_block_id;
   
   block_header.string_storage.elmdata_size = source->block_header.string_storage.elmdata_size;
   block_header.string_storage.data_offset  = source->block_header.string_storage.data_offset;

   block_header.os_specific_data.elmdata_size = source->block_header.os_specific_data.elmdata_size;
   block_header.os_specific_data.data_offset  = source->block_header.os_specific_data.data_offset;

   block_header.string_type = source->block_header.string_type;
   block_header.reserved    = source->block_header.reserved;
   block_header.hdr_chksm   = source->block_header.hdr_chksm;

   tape_id_number            = source->tape_id_number;
   tape_attributes           = source->tape_attributes;
   tape_seq_number           = source->tape_seq_number;
   password_encryption_algor = source->password_encryption_algor;
   ecc_alg                   = source->ecc_alg;
   otc_type                  = source->otc_type;

   tape_name.elmdata_size = source->tape_name.elmdata_size;
   tape_name.data_offset  = source->tape_name.data_offset;

   tape_description.elmdata_size = source->tape_description.elmdata_size;
   tape_description.data_offset  = source->tape_description.data_offset;

   tape_password.elmdata_size = source->tape_password.elmdata_size;
   tape_password.data_offset  = source->tape_password.data_offset;

   software_name.elmdata_size = source->software_name.elmdata_size;
   software_name.data_offset  = source->software_name.data_offset;

   logical_block_size = source->logical_block_size;
   software_vendor_id = source->software_vendor_id;
   
   tape_date.dt_field[ 0 ] = source->tape_date.dt_field[ 0 ];
   tape_date.dt_field[ 1 ] = source->tape_date.dt_field[ 1 ];
   tape_date.dt_field[ 2 ] = source->tape_date.dt_field[ 2 ];
   tape_date.dt_field[ 3 ] = source->tape_date.dt_field[ 3 ];
   tape_date.dt_field[ 4 ] = source->tape_date.dt_field[ 4 ];

   tape_format_version_major = source->tape_format_version_major;
}

#if defined( _DEBUG )

void CMTFTape::Dump( CDumpContext& dump_context ) const
{
   dump_context << " a CMTFDataBlockHeader at " << (void *) this << "\n";
   dump_context << "{\n";
   CMTFDataBlockHeader header( &block_header );
   dump_context << "   block_header is";
   header.Dump( dump_context );
   dump_context << "   tape_id_number                = " << tape_id_number                << "\n";
   dump_context << "   tape_attributes               = " << tape_attributes               << "\n";
   dump_context << "   tape_seq_number               = " << tape_seq_number               << "\n";
   dump_context << "   password_encryption_algor     = " << password_encryption_algor     << "\n";
   dump_context << "   ecc_alg                       = " << ecc_alg                       << "\n";
   dump_context << "   otc_type                      = " << otc_type                      << "\n";
   dump_context << "   tape_name.elmdata_size        = " << tape_name.elmdata_size        << "\n";
   dump_context << "   tape_name.data_offset         = " << tape_name.data_offset         << "\n";
   dump_context << "   tape_description.elmdata_size = " << tape_description.elmdata_size << "\n";
   dump_context << "   tape_description.data_offset  = " << tape_description.data_offset  << "\n";
   dump_context << "   tape_password.elmdata_size    = " << tape_password.elmdata_size    << "\n";
   dump_context << "   tape_password.data_offset     = " << tape_password.data_offset     << "\n";
   dump_context << "   software_name.elmdata_size    = " << software_name.elmdata_size    << "\n";
   dump_context << "   software_name.data_offset     = " << software_name.data_offset     << "\n";
   dump_context << "   logical_block_size            = " << logical_block_size            << "\n";
   dump_context << "   software_vendor_id            = " << software_vendor_id            << "\n";
   dump_context << "   tape_date.dt_field[ 0 ]       = " << tape_date.dt_field[ 0 ]       << "\n";
   dump_context << "   tape_date.dt_field[ 1 ]       = " << tape_date.dt_field[ 1 ]       << "\n";
   dump_context << "   tape_date.dt_field[ 2 ]       = " << tape_date.dt_field[ 2 ]       << "\n";
   dump_context << "   tape_date.dt_field[ 3 ]       = " << tape_date.dt_field[ 3 ]       << "\n";
   dump_context << "   tape_date.dt_field[ 4 ]       = " << tape_date.dt_field[ 4 ]       << "\n";
   dump_context << "   tape_format_version_major     = " << tape_format_version_major     << "\n";
   dump_context << "}\n";
}

#endif // _DEBUG

void CMTFTape::Empty( void )
{
   block_header.block_type[ 0 ] = 0;
   block_header.block_type[ 1 ] = 0;
   block_header.block_type[ 2 ] = 0;
   block_header.block_type[ 3 ] = 0;

   block_header.block_attribs      = 0;
   block_header.offset_to_data     = 0;
   block_header.machine_os_id      = 0;
   block_header.machine_os_version = 0;

   block_header.displayable_size.lsw = 0;
   block_header.displayable_size.msw = 0;

   block_header.logical_block_address.lsw = 0;
   block_header.logical_block_address.msw = 0;

   block_header.session_id.lsw = 0;
   block_header.session_id.msw = 0;

   block_header.control_block_id = 0;
   
   block_header.string_storage.elmdata_size = 0;
   block_header.string_storage.data_offset  = 0;

   block_header.os_specific_data.elmdata_size = 0;
   block_header.os_specific_data.data_offset  = 0;
   block_header.string_type = 0;
   block_header.reserved    = 0;
   block_header.hdr_chksm   = 0;

   tape_id_number            = 0;
   tape_attributes           = 0;
   tape_seq_number           = 0;
   password_encryption_algor = 0;
   ecc_alg                   = 0;
   otc_type                  = 0;

   tape_name.elmdata_size = 0;
   tape_name.data_offset  = 0;

   tape_description.elmdata_size = 0;
   tape_description.data_offset  = 0;

   tape_password.elmdata_size = 0;
   tape_password.data_offset  = 0;

   software_name.elmdata_size = 0;
   software_name.data_offset  = 0;

   logical_block_size = 0;
   software_vendor_id = 0;
   
   tape_date.dt_field[ 0 ] = 0;
   tape_date.dt_field[ 1 ] = 0;
   tape_date.dt_field[ 2 ] = 0;
   tape_date.dt_field[ 3 ] = 0;
   tape_date.dt_field[ 4 ] = 0;

   tape_format_version_major = 0;
}

