#include <wfc.h>
#pragma hdrstop

/*
** Author: Samuel R. Blackburn
** CI$: 76300,326
** Internet: sammy@sed.csc.com
**
** You can use it any way you like as long as you don't try to sell it.
**
** Any attempt to sell WFC in source code form must have the permission
** of the original author. You can produce commercial executables with
** WFC but you can't sell WFC.
**
** Copyright, 1995, Samuel R. Blackburn
**
** $Workfile: $
** $Revision: $
** $Modtime: $
*/

#if defined( _DEBUG )
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#define new DEBUG_NEW
#endif

CNamedPipe::CNamedPipe( DWORD _input_buffer_size, DWORD _output_buffer_size )
{
   m_Initialize( _input_buffer_size, _output_buffer_size );
}

CNamedPipe::~CNamedPipe()
{
   if ( m_AutomaticallyDelete == TRUE )
   {
      if ( m_PipeHandle != (HANDLE) NULL )
      {
         Close();
      }
   }

   if ( m_InputBuffer != (LPVOID) NULL )
   {
      /*
      ** Free our memory
      */

      delete [] m_InputBuffer;

      m_InputBuffer = (LPVOID) NULL;
      m_InputBufferSize = 0L;
   }

   if ( m_OutputBuffer != (LPVOID) NULL )
   {
      /*
      ** Free our memory
      */

      delete [] m_OutputBuffer;

      m_OutputBuffer = (LPVOID) NULL;
      m_OutputBufferSize = 0L;
   }
}

void CNamedPipe::m_Initialize( DWORD _input_buffer_size, DWORD _output_buffer_size )
{
   m_AutomaticallyDelete = TRUE;
   m_ErrorCode           = 0L;
   m_PipeHandle          = INVALID_HANDLE_VALUE;
   m_Timeout             = NMPWAIT_USE_DEFAULT_WAIT;
   m_PipeName.Empty();

   m_InputBufferSize  = _input_buffer_size;
   m_OutputBufferSize = _output_buffer_size;

   m_InputBuffer  = new BYTE[ m_InputBufferSize  ];
   m_OutputBuffer = new BYTE[ m_OutputBufferSize ];
}

#if defined( _DEBUG )

void CNamedPipe::Dump( CDumpContext& dump_context ) const
{
   //CDummyFile::Dump( dump_context );

   dump_context << "m_AutomaticallyDelete = "      << m_AutomaticallyDelete      << "\n";
   dump_context << "m_PipeHandle = "               << m_PipeHandle               << "\n";
   dump_context << "m_MaximumNumberOfInstances = " << m_MaximumNumberOfInstances << "\n";
   dump_context << "m_InputBufferSize = "          << m_InputBufferSize          << "\n";
   dump_context << "m_OutputBufferSize = "         << m_OutputBufferSize         << "\n";
   dump_context << "m_NumberOfBytesToWrite = "     << m_NumberOfBytesToWrite     << "\n";
   dump_context << "m_NumberOfBytesRead = "        << m_NumberOfBytesRead        << "\n";
   dump_context << "m_Timeout = "                  << m_Timeout                  << "\n";
   dump_context << "m_PipeName = \""               << m_PipeName                 << "\"\n";
   dump_context << "m_FullPipeName is ";
   m_FullPipeName.Dump( dump_context );
   dump_context << "m_PipeState = "                << m_PipeState                << "\n";
   dump_context << "m_NumberOfInstances = "        << m_NumberOfInstances        << "\n";
   dump_context << "m_MaximumNumberOfBytesBeforeRemoteTransmission = "     << m_MaximumNumberOfBytesBeforeRemoteTransmission   << "\n";
   dump_context << "m_MaximumNumberOfMillisecondsBeforeRemoteTransmission = "     << m_MaximumNumberOfMillisecondsBeforeRemoteTransmission   << "\n";
   dump_context << "m_UserNameOfClientProcess = \"" << m_UserNameOfClientProcess << "\"\n";
}

#endif // _DEBUG

BOOL CNamedPipe::Call( CString& pipe_name, 
                       LPVOID   write_buffer, 
                       DWORD    size_of_write_buffer, 
                       LPVOID   read_buffer, 
                       DWORD    size_of_read_buffer, 
                       DWORD   *address_of_number_of_bytes_read,
                       DWORD    number_of_milliseconds_to_wait )
{
   ASSERT( write_buffer != NULL );
   ASSERT( read_buffer  != NULL );

   if ( write_buffer == NULL || read_buffer == NULL )
   {
      m_ErrorCode = ERROR_INVALID_PARAMETER;
      return( FALSE );
   }

   /*
   ** Writes to the pipe then reads from it
   */

   BOOL return_value = FALSE;

   return_value = ::CallNamedPipe( pipe_name, 
                                   write_buffer,
                                   size_of_write_buffer,
                                   read_buffer,
                                   size_of_read_buffer,
                                   address_of_number_of_bytes_read,
                                   number_of_milliseconds_to_wait );

   if ( return_value == TRUE )
   {
      return( TRUE );
   }
   else
   {
      m_ErrorCode = ::GetLastError();

      return( FALSE );
   }
}

void CNamedPipe::Close( void )
{
   if ( m_PipeHandle != INVALID_HANDLE_VALUE )
   {
      ::CloseHandle( m_PipeHandle );
      m_PipeHandle = INVALID_HANDLE_VALUE;
   }
}

BOOL CNamedPipe::Connect( LPOVERLAPPED overlapped_p )
{
   // overlapped_p can be NULL

   BOOL return_value = FALSE;

   return_value = ::ConnectNamedPipe( m_PipeHandle, overlapped_p );

   if ( return_value == TRUE )
   {
      return( TRUE );
   }
   else
   {
      m_ErrorCode = ::GetLastError();

      return( FALSE );
   }
}

BOOL CNamedPipe::Create( LPCTSTR server_name,
                         LPCTSTR pipe_name,
                         DWORD   open_mode,
                         DWORD   type_of_pipe,
                         DWORD   number_of_pipes,
           LPSECURITY_ATTRIBUTES security_attributes_p )
{
   ASSERT( pipe_name != NULL );

   /*
   ** Check parameters for errors
   */

   if ( pipe_name == NULL )
   {
      m_ErrorCode = ERROR_INVALID_PARAMETER;
      return( FALSE );
   }

   m_PipeName = "\\\\";

   if ( server_name == NULL )
   {
      m_PipeName += ".";
   }
   else
   {
      m_PipeName += server_name;
   }

   m_PipeName += "\\PIPE\\";
   m_PipeName += pipe_name;

   CSecurityAttributes security_attributes;
   SECURITY_DESCRIPTOR security_descriptor;

   if ( security_attributes_p == NULL )
   {
      ::InitializeSecurityDescriptor( &security_descriptor, SECURITY_DESCRIPTOR_REVISION );

      ::SetSecurityDescriptorDacl( &security_descriptor, TRUE, NULL, FALSE );
      security_attributes.bInheritHandle = FALSE;
      security_attributes.lpSecurityDescriptor = &security_descriptor;

      security_attributes_p = (SECURITY_ATTRIBUTES *) &security_attributes;
   }

   m_PipeHandle = ::CreateNamedPipe( m_PipeName,
                                     open_mode,
                                     type_of_pipe, 
                                     number_of_pipes,
                                     m_OutputBufferSize,
                                     m_InputBufferSize,
                                     m_Timeout,
                                     security_attributes_p );

   if ( m_PipeHandle == INVALID_HANDLE_VALUE )
   {
      m_ErrorCode = ::GetLastError();
      return( FALSE );
   }
   else
   {
      return( TRUE );
   }
}

BOOL CNamedPipe::Disconnect( void )
{
   BOOL return_value = FALSE;

   return_value = ::DisconnectNamedPipe( m_PipeHandle );

   if ( return_value == TRUE )
   {
      return( TRUE );
   }
   else
   {
      m_ErrorCode = ::GetLastError();

      return( FALSE );
   }
}

BOOL CNamedPipe::GetInformation( void )
{
   BOOL return_value = FALSE;

   DWORD type_of_pipe                = 0;
   DWORD size_of_output_buffer       = 0;
   DWORD size_of_input_buffer        = 0;
   DWORD maximum_number_of_instances = 0;

   return_value = ::GetNamedPipeInfo( m_PipeHandle,
                                     &type_of_pipe,
                                     &size_of_output_buffer,
                                     &size_of_input_buffer,
                                     &maximum_number_of_instances );

   if ( return_value == TRUE )
   {
      return( TRUE );
   }
   else
   {
      m_ErrorCode = ::GetLastError();

      return( FALSE );
   }
}

BOOL CNamedPipe::GetState( void )
{
   BOOL return_value = FALSE;

   TCHAR temp_string[ 513 ];

   ::ZeroMemory( temp_string, sizeof( temp_string ) );

   return_value = ::GetNamedPipeHandleState( m_PipeHandle,
                                            &m_PipeState,
                                            &m_NumberOfInstances,
                                            &m_MaximumNumberOfBytesBeforeRemoteTransmission,
                                            &m_MaximumNumberOfMillisecondsBeforeRemoteTransmission,
                                             temp_string,
                                             sizeof( temp_string ) );

   m_UserNameOfClientProcess = temp_string;

   if ( return_value == TRUE )
   {
      return( TRUE );
   }
   else
   {
      m_ErrorCode = ::GetLastError();

      return( FALSE );
   }
}

BOOL CNamedPipe::Open( const char *pipe_name, UINT port_number, CFileException * perror )
{
   ASSERT( pipe_name != NULL );

   if ( pipe_name == (LPCTSTR) NULL )
   {
      m_ErrorCode = ERROR_INVALID_PARAMETER;

      return( FALSE );
   }

   /*
   ** pipe_name can be:
   ** "pipe_name" where the pipe will be openend on the local machine
   ** "\\server_name\pipe_name" where the pipe will be opened on the server
   ** "\\server_name\PIPE\pipe_name" which is a fully qualified pipe name
   */

   CUniversalNamingConvention unc( pipe_name );

   TRACE( "unc is \"%s\"\n", (LPCTSTR) unc );

   if ( unc.ServerName.IsEmpty() != FALSE )
   {
      unc.ServerName = ".";
   }

   if ( unc.ShareName.CompareNoCase( "PIPE" ) != 0 )
   {
      CString temp_string = unc.ShareName;

      unc.ShareName = "PIPE";

      if ( temp_string.IsEmpty() != TRUE )
      {
         unc.PathName  = temp_string + "\\" + unc.PathName;
      }
   }

   unc.Make();

   m_FullPipeName = unc;

   TRACE( "Full Pipe Name is \"%s\"\n", (LPCTSTR) unc );

   return( Create( unc.ServerName, unc.PathName ) );
}

BOOL CNamedPipe::Peek( LPVOID buffer_address, 
                       DWORD  size_of_buffer,
                       DWORD& number_of_bytes_read,
                       DWORD& number_of_bytes_available,
                       DWORD& number_of_bytes_remaining_in_message )
{
   /*
   ** buffer_address can be NULL
   */

   BOOL return_value = FALSE;

   return_value = ::PeekNamedPipe( m_PipeHandle, 
                                   buffer_address, 
                                   size_of_buffer, 
                                  &number_of_bytes_read,
                                  &number_of_bytes_available,
                                  &number_of_bytes_remaining_in_message );

   if ( return_value == TRUE )
   {
      return( TRUE );
   }
   else
   {
      m_ErrorCode = ::GetLastError();

      return( FALSE );
   }
}

BOOL CNamedPipe::SetState( DWORD new_pipe_mode, 
                           DWORD maximum_number_of_bytes_before_transmission, 
                           DWORD maximum_number_of_milliseconds_before_transmission )
{
   BOOL return_value = FALSE;

   return_value = ::SetNamedPipeHandleState( m_PipeHandle,
                                            &new_pipe_mode,
                                            &maximum_number_of_bytes_before_transmission,
                                            &maximum_number_of_milliseconds_before_transmission );

   if ( return_value == TRUE )
   {
      return( TRUE );
   }
   else
   {
      m_ErrorCode = ::GetLastError();

      return( FALSE );
   }
}

BOOL CNamedPipe::Transact( LPOVERLAPPED overlapped_p )
{
   // overlapped_p can be NULL

   BOOL return_value = FALSE;

   return_value = ::TransactNamedPipe( m_PipeHandle,
                                       m_OutputBuffer,
                                       m_NumberOfBytesToWrite,
                                       m_InputBuffer,
                                       m_InputBufferSize,
                                      &m_NumberOfBytesRead,
                                       overlapped_p );

   if ( return_value == TRUE )
   {
      return( TRUE );
   }
   else
   {
      m_ErrorCode = ::GetLastError();

      return( FALSE );
   }
}

BOOL CNamedPipe::Wait( LPCTSTR name_of_server, LPCTSTR name_of_pipe, DWORD number_of_milliseconds )
{
   ASSERT( name_of_pipe != NULL );

   /*
   ** Check parameters for errors
   */

   if ( name_of_pipe == NULL )
   {
      m_ErrorCode = ERROR_INVALID_PARAMETER;
      return( FALSE );
   }

   BOOL return_value = FALSE;

   CString full_pipe_name( "\\\\" ); // like \\servername\pipe\pipename

   if ( name_of_server == NULL )
   {
      full_pipe_name += ".";
   }
   else
   {
      full_pipe_name += name_of_server;
   }

   full_pipe_name += "\\pipe\\";
   full_pipe_name += name_of_pipe;

   return_value = ::WaitNamedPipe( full_pipe_name, number_of_milliseconds );

   if ( return_value == TRUE )
   {
      return( TRUE );
   }
   else
   {
      m_ErrorCode = ::GetLastError();

      return( FALSE );
   }
}
