#include "wfc.h"
#pragma hdrstop

void PASCAL fill_data( CSquiggleData *data_p );

class CMainWindow : public CFrameWnd
{
   public:

      CMainWindow();

      CLabeledGrid Grid;

   protected:

      afx_msg int  OnCreate( LPCREATESTRUCT cs_p );
      afx_msg void OnPaint();
      afx_msg void OnTimer( UINT id );
      DECLARE_MESSAGE_MAP()
};

CMainWindow::CMainWindow()
{
   int number_of_rows    = 1;
   int number_of_columns = 1;

   Grid.SetSize( number_of_rows, number_of_columns );

   int row_index    = 0;
   int column_index = 0;

   for ( row_index = 0; row_index < number_of_rows; row_index++ )
   {
      for( column_index = 0; column_index < number_of_columns; column_index++ )
      {
         CSquiggle *squiggle_p = new CSquiggle;

         squiggle_p->SetHeight( 480 );
         squiggle_p->SetWidth(  640 );
         squiggle_p->SetLineColor( YELLOW );
         squiggle_p->SetFillColor( BLACK  );
         squiggle_p->SetNumberOfGridLines( 10, 8 );
         squiggle_p->SetLineThickness( 2 );
         squiggle_p->SetGridLineType( PS_SOLID );

         CSquiggleData *data_p = new CSquiggleData;

         data_p->MinimumValue = 1;
         data_p->MaximumValue = 256;
         data_p->Data.SetSize( 256 );

         fill_data( data_p );

         squiggle_p->SetSquiggleData( data_p, TRUE );

         Grid.SetAt( row_index, column_index, squiggle_p );
      }
   }

   TCHAR name[ 10 ];

   name[ 0 ] = 'A';
   name[ 1 ] = ' ';
   name[ 2 ] = 'R';
   name[ 3 ] = 'o';
   name[ 4 ] = 'w';
   name[ 5 ] = 0x00;

   for ( row_index = 0; row_index < number_of_rows; row_index++ )
   {
      name[ 0 ] = (TCHAR) ( 'A' + row_index );
      Grid.SetRowName( row_index, name );
   }

   Grid.SetRowsTitle( "Amplitude" );

   for( column_index = 0; column_index < number_of_columns; column_index++ )
   {
      ::sprintf( name, "%02d", column_index );
      Grid.SetColumnName( column_index, name );
   }

   Grid.SetColumnsTitle( "Frequency" );
   Grid.SetName( "Battleship!" );
   Grid.SetLabelOptions( LABELED_GRID_COLUMNS_TITLE | LABELED_GRID_ROWS_TITLE );
   Grid.SetVerticalSpacing( 2 );
   Grid.SetHorizontalSpacing( 2 );
   
   CRect rectangle( 90, 60, 0, 0 );

   Grid.SetRectangle( rectangle );
}

void PASCAL fill_data( CSquiggleData *data_p )
{
   static static_randomizer_initialized = 0;

   if ( static_randomizer_initialized == 0 )
   {
      static_randomizer_initialized = 1;

      srand( (unsigned) time( NULL ) );
   }

   if ( data_p == (CSquiggleData *) NULL )
   {
      return;
   }

   int number_of_elements = data_p->Data.GetSize();
   int index              = 0;

   WORD random_value = 0;
   WORD valid_range  = data_p->ValidRange();
   WORD last_value   = 0;
   WORD direction    = 0;
   WORD new_value    = 0;

   while( index < number_of_elements )
   {
      random_value = (WORD) ( rand() % 67 );

      if ( direction == 0 )
      {
         new_value = (WORD) ( last_value + random_value );
         new_value += (WORD) data_p->MinimumValue;

         if ( new_value >= data_p->MaximumValue )
         {
            direction = 1;
            new_value = data_p->MaximumValue - random_value;
         }
      }
      else
      {
         if ( last_value < random_value )
         {
            new_value = data_p->MinimumValue + random_value;
            direction = 0;
         }
         else
         {
            new_value = (WORD) ( last_value - random_value );

            if ( new_value <= data_p->MinimumValue )
            {
               direction = 0;
               new_value = data_p->MinimumValue;
            }
         }
      }

      data_p->Data.SetAt( index, new_value );

      last_value = new_value;

      index++;
   }
}

BEGIN_MESSAGE_MAP( CMainWindow, CFrameWnd )
   ON_WM_CREATE()
   ON_WM_PAINT()
   ON_WM_TIMER()
END_MESSAGE_MAP()

int CMainWindow::OnCreate( LPCREATESTRUCT )
{
   SetTimer( 1, 200, NULL );
   return( 0 );
}

void CMainWindow::OnPaint()
{
   CPaintDC device_context( this );

   Grid.Draw( device_context );
}

void CMainWindow::OnTimer( UINT )
{
   CSquiggle *squiggle_p = (CSquiggle *) Grid.GetAt( 0, 0 );

   if ( squiggle_p != (CSquiggle *) NULL )
   {
      CSquiggleData *data_p = new CSquiggleData;

      if ( data_p != (CSquiggleData *) NULL )
      {
         data_p->MinimumValue = 1;
         data_p->MaximumValue = 256;
         data_p->Data.SetSize( 256 );

         fill_data( data_p );

         squiggle_p->SetSquiggleData( data_p, TRUE );

         CRect rectangle;

         squiggle_p->GetRectangle( rectangle );

         InvalidateRect( &rectangle, FALSE );
      }
   }
}

class CSimpleApplication : public CWinApp
{
   public:

      BOOL InitInstance();
};

BOOL CSimpleApplication::InitInstance()
{
   CMainWindow *main_window_p = new CMainWindow;

   m_pMainWnd = main_window_p;

   main_window_p->Create( NULL, "Simple" );

   {
      CClientDC device_context( main_window_p );

      main_window_p->Grid.PrepareForPainting( device_context );
   }

   main_window_p->ShowWindow( m_nCmdShow );
   main_window_p->UpdateWindow();

   return( TRUE );
}

CSimpleApplication dodah;
