#include "test.h"
#pragma hdrstop

VOID PASCAL dial_monitor( HRASCONN     connection_handle, 
                          UINT         message, 
                          RASCONNSTATE connection_state,
                          DWORD        error_code,
                          DWORD        extended_error_code )
{
   switch( connection_state )
   {
      case RASCS_OpenPort:

         TRACE( "RASCS_OpenPort : The communication port is about to be opened.\n" );
         break;

      case RASCS_PortOpened:

         TRACE( "RASCS_PortOpened : The communication port has been opened successfully.\n" );
         break;

      case RASCS_ConnectDevice:

         TRACE( "RASCS_ConnectDevice : A device is about to be connected. RasGetConnectStatus can be called to determine the name and type of the device being connected.\n" );
         break;

      case RASCS_DeviceConnected:

         TRACE( "RASCS_DeviceConnected : A device has connected successfully. RasGetConnectStatus can be called to determine the name and type of the device being connected.\n" );
         break;

      case RASCS_AllDevicesConnected:

         TRACE( "RASCS_AllDevicesConnected : All devices in the device chain have successfully connected. At this point, the physical link is established.\n" );
         break;

      case RASCS_Authenticate:

         TRACE( "RASCS_Authenticate : 	The authentication process is starting. Remote access does not allow the remote client to generate any traffic on the LAN until authentication has been successfully completed. \n" );
         break;

      case RASCS_AuthNotify:

         TRACE( "RASCS_AuthNotify : An authentication event has occurred. If dwError is zero, this event will be immediately followed by one of the more specific authentication states following. If dwError is nonzero, authentication has failed, and the error value indicates why.\n" );
         break;

      case RASCS_AuthRetry:

         TRACE( "RASCS_AuthRetry : The client has requested another validation attempt with a new username/password/domain. This state does not occur in Windows NT version 3.1.\n" );
         break;

      case RASCS_AuthCallback:

         TRACE( "RASCS_AuthCallback : The remote access server has requested a callback number. This occurs only if the user has \"Set By Caller\" callback privilege on the server.\n" );
         break;

      case RASCS_AuthChangePassword:

         TRACE( "RASCS_AuthChangePassword : The client has requested to change the password on the account. This state does not occur in Windows NT version 3.1.\n" );
         break;

      case RASCS_AuthProject:

         TRACE( "RASCS_AuthProject : The projection phase is starting.\n" );
         break;

      case RASCS_AuthLinkSpeed:

         TRACE( "RASCS_AuthLinkSpeed : The link-speed calculation phase is starting.\n" );
         break;

      case RASCS_AuthAck:

         TRACE( "RASCS_AuthAck : An authentication request is being acknowledged.\n" );
         break;

      case RASCS_ReAuthenticate:

         TRACE( "RASCS_ReAuthenticate : Reauthentication (after callback) is starting.\n" );
         break;

      case RASCS_Authenticated:

         TRACE( "RASCS_Authenticated : The client has successfully completed authentication.\n" );
         break;

      case RASCS_PrepareForCallback:

         TRACE( "RASCS_PrepareForCallback : The line is about to disconnect in preparation for callback.\n" );
         break;

      case RASCS_WaitForModemReset:

         TRACE( "RASCS_WaitForModemReset : The client is delaying in order to give the modem time to reset itself in preparation for callback.\n" );
         break;

      case RASCS_WaitForCallback:

         TRACE( "RASCS_WaitForCallback : The client is waiting for an incoming call from the remote access server.\n" );
         break;

      case RASCS_Projected:

         TRACE( "RASCS_Projected : This state occurs after the RASCS_AuthProject state. It indicates that projection result information is available. You can access the projection result information by calling RasGetProjectionInfo.\n" );
         break;

#if (WINVER >= 0x400)

      case RASCS_StartAuthentication:    // Windows 95 only 

         TRACE( "RASCS_StartAuthentication : Windows 95 only: Indicates that user authentication is being initiated or retried.\n" );
         break;

      case RASCS_CallbackComplete:       // Windows 95 only 

         TRACE( "RASCS_CallbackComplete : Windows 95 only: Indicates that the client has been called back and is about to resume authentication.\n" );
         break;

      case RASCS_LogonNetwork:           // Windows 95 only 

         TRACE( "RASCS_LogonNetwork : Windows 95 only: Indicates that the client is logging on to the network.\n" );
         break;

#endif 
 
      case RASCS_Interactive:

         TRACE( "RASCS_Interactive : This state corresponds to the terminal state supported by RASPHONE.EXE. This state does not occur in Windows NT version 3.1.\n" );
         break;

      case RASCS_RetryAuthentication:

         TRACE( "RASCS_RetryAuthentication : This state corresponds to the retry authentication state supported by RASPHONE.EXE. This state does not occur in Windows NT version 3.1.\n" );
         break;

      case RASCS_CallbackSetByCaller:

         TRACE( "RASCS_CallbackSetByCaller : This state corresponds to the Callback state supported by RASPHONE.EXE. This state does not occur in Windows NT version 3.1.\n" );
         break;

      case RASCS_PasswordExpired:

         TRACE( "RASCS_PasswordExpired : This state corresponds to the change password state supported by RASPHONE.EXE. This state does not occur in Windows NT version 3.1.\n" );
         break;

      case RASCS_Connected:

         TRACE( "RASCS_Connected : Successful connection.\n" );
         break;

      case RASCS_Disconnected:

         TRACE( "RASCS_Disconnected : Disconnection or failed connection.\n" );
         break;

      default:

         if ( connection_state != 0 )
         {
            TCHAR debug_string[ 99 ];

            wsprintf( debug_string, (LPCTSTR) TEXT( "Unknown connection state %d\n" ), connection_state );
            TRACE( debug_string );
         }

         break;
   }

   switch( extended_error_code )
   {
      case ERROR_SERVER_NOT_RESPONDING:

         TRACE( "   Extended Error: Server not responding\n" );
         break;

      case ERROR_NETBIOS_ERROR:

         TRACE( "   Extended Error: NetBIOS error\n" );
         break;

      case ERROR_AUTH_INTERNAL:

         TRACE( "   Extended Error: Internal Diagnostics Code\n" );
         break;

      case ERROR_CANNOT_GET_LANA:

         TRACE( "   Extended Error: Routing error code\n" );
         break;

      default:

         if ( extended_error_code != 0 )
         {
            TCHAR debug_string[ 99 ];

            wsprintf( debug_string, (LPCTSTR) TEXT( "Unknown extended error code %lu\n" ), extended_error_code );
            TRACE( debug_string );
         }

         break;
   }
}

void test_CRAS( void )
{
   CRemoteAccessService ras;

   CStringArray strings;

   ras.SetConnectionCallback( dial_monitor );
   ras.SetDialOptions( CRemoteAccessService::dialAcceptPausedStates );

   if ( ras.GetPhoneBookEntries( strings ) == TRUE )
   {
      DWORD index = 0;
      DWORD number_of_entries = strings.GetSize();

      TRACE( "Phone Book Entries:\n" );

      while( index < number_of_entries )
      {
         TRACE1( "\"%s\"\n", (const char *) strings[ index ] );
         index++;
      }
   }

   strings.RemoveAll();

   if ( ras.GetConnections( strings ) == TRUE )
   {
      DWORD index = 0;
      DWORD number_of_entries = strings.GetSize();

      TRACE( "\nCurrent Connections:\n" );

      while( index < number_of_entries )
      {
         TRACE1( "\"%s\"\n", (const char *) strings[ index ] );
         index++;
      }
   }

   if ( ras.Open( "EPLORER" ) != TRUE )
   {
      CString error_string;
      ras.GetErrorString( error_string );
      TRACE1( "Ras Open failed with \"%s\"!\n", (const char *) error_string );
   }
   else
   {
      TRACE( "RAS Open!\n" );
   }

   strings.RemoveAll();

   if ( ras.GetConnections( strings ) == TRUE )
   {
      DWORD index = 0;
      DWORD number_of_entries = strings.GetSize();

      TRACE( "\nCurrent Connections:\n" );

      while( index < number_of_entries )
      {
         TRACE1( "\"%s\"\n", (const char *) strings[ index ] );
         index++;
      }
   }

   if ( ras.HangUp( "EPLORER" ) == TRUE )
   {
      TRACE( "Hangup OK\n" );
   }
}
