#include "test.h"
#pragma hdrstop

void test_CServer( LPCTSTR machine_name )
{
   CServer server;

   server.Open( machine_name );

   CString name;
   CString comment;
   CString path;
   CString os;
   CString domain;

   DWORD major_version   = 0;
   DWORD minor_version   = 0;
   DWORD type            = 0;
   DWORD users           = 0;
   DWORD number_of_users = 0;
   DWORD number_of_opens = 0;

   server.GetUserPath( path );
   server.GetName( name );
   server.GetComment( comment );
   server.GetPlatformName( os );
   server.GetDomain( domain );

   major_version   = server.GetMajorVersion();
   minor_version   = server.GetMinorVersion();
   type            = server.GetType();
   users           = server.GetUsers();
   number_of_users = server.GetNumberOfUsers();
   number_of_opens = server.GetNumberOfOpens();

   printf( "Server Name:      \"%s\"\n", (LPCTSTR) name    );
   printf( "Server Domain:    \"%s\"\n", (LPCTSTR) domain  );
   printf( "Server Comment:   \"%s\"\n", (LPCTSTR) comment );
   printf( "Server User Path: \"%s\"\n", (LPCTSTR) path    );
   printf( "Server OS:        \"%s\"\n", (LPCTSTR) os      );
   printf( "Server Version:    %d.%d\n", major_version, minor_version );
   printf( "Server Users:      %d\n",    users );
   printf( "Number Of Users:   %d\n",    number_of_users );
   printf( "Number Of Opens:   %d\n",    number_of_opens );
}

