/*** line.c ***/

#include "windows.h"
#include "wsc.h"

#include "line.h"
#include "sioerror.h"

extern HWND hMainWnd;
extern int  FatalFlag;
extern int  OnLineFlag;

/*** PRIVATE ***/

static int ErrorCheck(int Code,char *Text)
{if(Code<0) SioError(Code,Text);
 return Code;
}

/*** PUBLIC ***/

int GoOnLine(int Port, int BaudCode, int RxQueSize, int TxQueSize)
{int RetCode;
 char Temp[50];
 if(OnLineFlag) return TRUE;
 /* reset Port */
 RetCode = SioReset(Port,RxQueSize,TxQueSize);
 if(RetCode<0)
   {wsprintf((LPSTR)Temp,"SioReset:COM%d",1+Port);
    SioError(RetCode,Temp);
    return FALSE;
   }
 /* set baud rate */
 ErrorCheck( SioBaud(Port,BaudCode), "SioBaud");
 /* clear receive buffer */
 ErrorCheck( SioRxClear(Port), "SioRxClear");
 /* set DTR & RTS */
 ErrorCheck( SioDTR(Port,'S'), "SioDTR");
 ErrorCheck( SioRTS(Port,'S'), "SioRTS");
 /* no flow control */
 ErrorCheck( SioFlow(Port,'N'), "SioFlow");
 /* we're done */
 OnLineFlag = TRUE;
 return TRUE;
}

void GoOffLine(int Port)
{SioDone(Port);
 /* we're done */
 OnLineFlag = FALSE;
}
  