UNIT Drumfile;

{$F+}

(*------------------------------------------
   DRUMFILE.Pas by Peter Horn, (c) 1993, based on
   DRUMFILE.C -- File I/O Routines for DRUM
                 (c) Charles Petzold, 1992
  ------------------------------------------*)



INTERFACE

USES WinTypes, WinProcs, WinDos, Objects, OMemory, OWindows, ODialogs,
   Strings, OStdDlgs, MMSystem, MidiConst, MIDInterface;

(*
/*-------------------------------------------------------
   DRUMFILE.H Header File for File I/O Routines for DRUM
  -------------------------------------------------------*/
*)

Function DrumFileWrite   (DRUMS : PDrum; szFileName: Pchar) : PChar ;

Function DrumFileRead    (HWindow: Hwnd; szFileName: Pchar) : PChar ;




implementation


const
szFilter: array [0..2] of PChar = (('Drum Files (*.DRM)'),  ('*.drm'), ('')) ;

szDrumID : Pchar = 'DRUM' ;
szListID : Pchar = 'LIST' ;
szInfoID : Pchar = 'INFO' ;
szSoftID : Pchar = 'ISFT' ;
szDateID : Pchar = 'ISCD' ;
szFmtID  : Pchar = 'fmt ' ;
szDataID : Pchar = 'data' ;

szSoftware : Pchar = 'DRUM by Charles Petzold, PC Magazine, Vol. 11, Nos. 9-12' ;

szErrorNoCreate     : Pchar = 'File %s could not be opened for writing.' ;
szErrorCannotWrite  : Pchar = 'File %s could not be written to. Disk full.' ;
szErrorNotFound     : Pchar = 'File %s not found or cannot be opened.' ;
szErrorNotDrum      : Pchar = 'File %s is not a standard DRUM file.' ;
szErrorUnsupported  : Pchar = 'File %s is not a supported DRUM file.' ;
szErrorCannotRead   : Pchar = 'File %s cannot be read.' ;

Function DrumFileWrite   (DRUMs : PDrum; szFileName: Pchar) : PChar ;
const lFormat : Longint = 1;
      wError  : LongInt = 0 ;

var
     szDateBuf : array [0..16] of char;
     Myhmmio   : PHMMIO (*HMMIO*)        ;
     i , j : integer;
     mymmckinfo  : array [0..3] of PMMCKInfo ;
     Hour, Minute, Second, Sec100 : word;
     Year, Month,Day, DayOfWeek : word;
     S1,S2,S3 : String;
     drumarray : array [0..382] of Char;
     DrumHigh, DrumLow : Word;


begin
     new (Myhmmio);
     for i:= 0 to 3 do new (mymmckinfo[i]);

     (*
     C can simply write drums to file as if that record were made up
     of characters. Doing that with Pascal produces garbage.
     So we have to do a bit more work. First clean up the array
     *)

     for i := 0 to 382 do
     drumarray[i] := #0;

     i:=0; drumarray[i] := char (lo (drums^.iMsecPerBeat));
     i:=1; drumarray[i] := char (hi (drums^.iMsecPerBeat));
     i:=2; drumarray[i] := char (lo (drums^.iVelocity));
     i:=3; drumarray[i] := char (hi (drums^.iVelocity));
     i:=4; drumarray[i] := char (lo (drums^.iNumBeats));
     i:=5; drumarray[i] := char (hi (drums^.iNumBeats));

     for j:= 0 to NUM_PERC-1 do begin
       DrumLow   :=  loword (drums^.dwSeqBas[j]);
       DrumHigh  :=  hiword (drums^.dwSeqBas[j]);
       i:= i + 1; drumarray[i] := char (lo (DrumLow ));
       i:= i + 1; drumarray[i] := char (hi (DrumLow ));
       i:= i + 1; drumarray[i] := char (lo (DrumHigh));
       i:= i + 1; drumarray[i] := char (hi (DrumHigh));
     end;
     for j:= 0 to NUM_PERC-1 do begin
       DrumLow   :=  loword (drums^.dwSeqExt[j]);
       DrumHigh  :=  hiword (drums^.dwSeqExt[j]);
       i:= i + 1; drumarray[i] := char (lo (DrumLow ));
       i:= i + 1; drumarray[i] := char (hi (DrumLow ));
       i:= i + 1; drumarray[i] := char (lo (DrumHigh));
       i:= i + 1; drumarray[i] := char (hi (DrumHigh));
     end;

     (* function mmioOpen(szFileName: PChar; lpmmioinfo: PMMIOInfo;
                 dwOpenFlags: Longint): THMMIO; *)
     Myhmmio^ := mmioOpen (szFileName, nil,
                            (MMIO_CREATE or MMIO_WRITE or MMIO_ALLOCBUF));
     if Myhmmio^ = 0 then  DrumFileWrite := szErrorNoCreate ;


     (*       // Create a "RIFF" chunk with a "CPDR" type
     *)

     mymmckinfo[0]^.fccType := mmioStringToFOURCC (szDrumID, 0) ;

     wError := mmioCreateChunk (myhmmio^, mymmckinfo[0], MMIO_CREATERIFF) ;

     (*          // Create "LIST" sub-chunk with an "INFO" type   *)

     mymmckinfo[1]^.fccType := mmioStringToFOURCC (szInfoID, 0) ;

     wError := mmioCreateChunk (myhmmio^, mymmckinfo[1], MMIO_CREATELIST) ;

     (*          // Create "ISFT" sub-sub-chunk    *)

     mymmckinfo[2]^.ckid := mmioStringToFOURCC (szSoftID, 0) ;

     wError := mmioCreateChunk (myhmmio^, mymmckinfo[2], 0) ;
     wError := mmioWrite (myhmmio^, szSoftware, (StrLen (szSoftware)+1));
     wError := mmioAscend (myhmmio^, mymmckinfo[2], 0) ;

     (*          // Create a time string

     time (lTime) ;
     tmTime = localtime (&lTime) ;
     *)
     GEtDate (Year, Month,Day, DayOfWeek);
     Gettime (Hour, Minute, Second, Sec100);
     Str(Year:4, S1); Str (Month:2, S2); Str(Day:2, S3 );
     s1 := S1+'-'+S2+'-'+S3;
     StrPcopy (szDateBuf,S1);
     (*
              szDateBuf : array [0..16] of char;
              // Create "ISCD" sub-sub-chunk     *)

     mymmckinfo[2]^.ckid := mmioStringToFOURCC (szDateID, 0) ;

     wError := mmioCreateChunk (myhmmio^, mymmckinfo[2], 0) ;
     wError := mmioWrite (myhmmio^, szDateBuf, strlen (szDateBuf) + 1) ;
     wError := mmioAscend (myhmmio^, mymmckinfo[2], 0) ;
     wError := mmioAscend (myhmmio^, mymmckinfo[1], 0) ;

     (*          // Create "fmt " sub-chunk         *)

     mymmckinfo[1]^.ckid := mmioStringToFOURCC (szFmtID, 0) ;

     wError := mmioCreateChunk (myhmmio^, mymmckinfo[1], 0) ;
     wError := mmioWrite (myhmmio^, @lFormat, sizeof (lFormat)) ;
     wError := mmioAscend (myhmmio^, mymmckinfo[1], 0) ;

     (*          // Create the "data" sub-chunk      *)

     mymmckinfo[1]^.ckid := mmioStringToFOURCC (szDataID, 0) ;

     wError := mmioCreateChunk (myhmmio^, mymmckinfo[1], 0) ;
     wError := mmioWrite (myhmmio^, @drumarray, sizeof (DRUMS^)) ;
     wError := mmioAscend (myhmmio^, mymmckinfo[1], 0) ;
     wError := mmioAscend (myhmmio^, mymmckinfo[0], 0) ;

     (*          // Clean up and return           *)

     wError := mmioClose (myhmmio^, 0) ;
     (*
     for i:= 0 to 3 do Dispose (mymmckinfo[i]);
     *)

     if (wError) <> 0
          then begin
           mmioOpen (szFileName, nil, MMIO_DELETE) ;
           DrumFileWrite := szErrorCannotWrite ;
          end;

     end;

Function DrumFileRead (HWindow: Hwnd; szFileName: Pchar) : PChar ;
var DrumPtr : array [0..$1FF] of byte;  i, j :integer;
    DrumLow, DrumHigh : Word;
    infile : file; OK : boolean; S : String;
begin
   for i := 0 to $1FF do DrumPtr[i]:= 0;
   S := StrPas ( szFileName);
   assign(infile, S);
   {$I-} reset (infile, 1); {$I+}
   OK := IOResult = 0;
   if  OK then
   Blockread (infile, DrumPtr, $1F8)
   else ;

   close (infile);

     i:= 130;
     drums^.iMsecPerBeat := byte(DrumPtr[i])   + (byte(DrumPtr[i+1]) * $100);
     drums^.iVelocity    := byte(DrumPtr[i+2]) + (byte(DrumPtr[i+3]) * $100);
     drums^.iNumBeats    := byte(DrumPtr[i+4]) + (byte(DrumPtr[i+5]) * $100);

     i:=i+5;

     for j:= 0 to NUM_PERC-1 do begin
       DrumLow   :=  word(DrumPtr[i])         + (word(DrumPtr[i+1])*$100 );
       DrumHigh  :=  word(DrumPtr[i+2])       + (word(DrumPtr[i+3])* $100 );
       drums^.dwSeqBas[j] := longint(DrumLow) + (longint(DrumHigh) *$10000);
       i := i + 4;
     end;
     for j:= 0 to NUM_PERC-1 do begin
       DrumLow   :=  word(DrumPtr[i]) + (word(DrumPtr[i+1])*$100 );
       DrumHigh  :=  word(DrumPtr[i+2]) + (word(DrumPtr[i+3])*$100 );
       drums^.dwSeqExt[j] := longint(DrumLow) + (longint(DrumHigh)*$10000);
       i := i + 4;
     end;
     
     DrumSetParams (drums) ;

end;


end.