Unit MIDIconst;

{$F+}

interface

uses WinTypes, WinProcs, Strings, MMSystem, midiids;

CONST
  WINDOWTITLE : Pchar = 'Peter Horn''s MIDI Music Centre Vers. 1.00 24th December 1994: ';
  DLLName     : Pchar = 'MIDIDLL.DLL';
  Version     : Pchar = 'Vers. 1.00 24th December 1994';
  szAppName : PChar =  'Drum';
  szUntitled : PChar = '(Untitled)';
  szTitleName : PChar = '';
  szMIDIName : PChar  = '*.MID';
  MidiBool :  Boolean = False;
  CurrentInst     : Integer = 0;
  CurrentOctave   : Integer = 3;
  CurrentVelocity : Integer = 64;
  CurrentChannel  : Integer = 1;
  Semitones       : Integer = 0;
  CurrentTimeBase : array [0..1] of integer = (4,4);
  Key             : Integer = 0;
  sharpsign       : Integer = 0;

  NUM_PERC     =    47;
  WM_USER_NOTIFY      = (WM_USER + 1);
  WM_USER_FINISHED    = (WM_USER + 2);
  WM_USER_ERROR       = (WM_USER + 3);
  WM_USER_SWITCHPIANO = (WM_USER + 4);
  WM_USER_SWITCHDRUM  = (WM_USER + 5);
  WM_USER_SWITCHNOTES = (WM_USER + 6);
  WM_USER_SWITCHMIDI  = (WM_USER + 7);
  WM_USER_EXIT        = (WM_USER + 8);

  _MAX_FNAME = 128;
  _MAX_EXT   = 3;

  NUM_INST = 127;

   Instrumentation: ARRAY [0..NUM_INST] OF Pchar =
  (('Acoustic Grand Piano'),('Bright Acoustic Piano'),
  ('Electric Grand Piano'), ('Honky-tonk Piano'), ('Rhodes Piano'),
  ('Chorused Piano'),('Harpsichord'), ('Clavinet'),
  ('Celesta'), ('Glockenspiel'), ('Music box'),('Vibraphone'),
  ('Marimba'), ('Xylophone'), ('Tubular Bells'), ('Dulcimer'),
  ('Hammond Organ'),('Percussive Organ'),('Rock Organ'),
  ('Church Organ'), ('Reed Organ'),('Accordion'),
  ('Harmonica'), ('Tango Accordion'),('Acoustic Guitar (nylon)'),
  ('Acoustic Guitar (steel)'), ('Electric Guitar (jazz)'),
  ('Electric Guitar (clean)'), ('Electric Guitar (muted)'),
  ('Overdriven Guitar'), ('Distortion Guitar'), ('Guitar Harmonics'),
  ('Acoustic Bass'), ('Electric Bass (finger)'),
  ('Electric Bass (pick)'), ('Fretless Bass'), ('Slap Bass 1'),
  ('Slap Bass 2'), ('Synth Bass 1'), ('Synth Bass 2'),
  ('Violin'), ('Viola'),('Cello'), ('Contrabass'), ('Tremolo Strings'),
  ('Pizzicato Strings'), ('Orchestral Harp'), ('Timpani'),
  ('String Ensemble 1'),('String Ensemble 2'), ('Synth Strings 1'),
  ('Synth Strings 2'), ('Choir Aahs'), ('Voice Oohs'), ('Synth Voice'),
  ('Orchestra Hit'), ('Trumpet'), ('Trombone'), ('Tuba'), ('Muted Trumpet'),
  ('French Horn'), ('Brass Section'), ('Synth Brass 1'), ('Synth Brass 2'),
  ('Soprano Sax'),('Alto Sax'), ('Tenor Sax'), ('Baritone Sax'), ('Oboe'),
  ('English Horn'), ('Bassoon'), ('Clarinet'),('Piccolo'), ('Flute'),
  ('Recorder'), ('Pan Flute'), ('Bottle Blow'), ('Shakuhachi'),
  ('Whistle'), ('Ocarina'), ('Lead 1 (square)'), ('Lead 2 (sawtooth)'),
  ('Lead 3 (caliope lead)'), ('Lead 4 (chiff lead)'),
  ('Lead 5 (charang)'),('Lead 6 (voice)'), ('Lead 7 (fifths)'),
  ('Lead 8 (brass + lead)'), ('Pad 1 (new age)'), ('Pad 2 (warm)'),
  ('Pad 3 (polysynth)'), ('Pad 4 (choir)'), ('Pad 5 (bowed)'),
  ('Pad 6 (metallic)'), ('Pad 7 (halo)'), ('Pad 8 (sweep)'),
  ('FX 1 (rain)'), ('FX 2 (soundtrack)'), ('FX 3 (crystal)'),
  ('FX 4 (atmosphere)'), ('FX 5 (brightness)'), ('FX 6 (goblins)'),
  ('FX 7 (echoes)'), ('FX 8 (sci-fi)'),('Sitar'), ('Banjo'), ('Shamisen'),
  ('Koto'), ('Kalimba'), ('Bagpipe'), ('Fiddle'), ('Shanai'),
  ('Tinkle Bell'),('Agogo'), ('Steel Drums'), ('Woodblock'),
  ('Taiko Drum'), ('Melodic Tom'),('Synth Drum'), ('Reverse Cymbal'),
  ('Guitar Fret Noise'), ('Breath Noise'), ('Seashore'), ('Bird Tweet'),
  ('Telephone Ring'), ('Helicopter'), ('Applause'),('Gunshot'));


   MIDToolVersion = 'v1.0';


VAR

        ParentNotify :HWnd;
        AboutProc: TFARPROC;
        szBuffer : ARRAY [0..80 + _MAX_FNAME + _MAX_EXT] OF CHAR;
        ChannelInstruments : array [0..15] of integer;
        cxChar, cyChar : INTEGER;
        dwCurrPos : LONGINT (*DWORD*);
        iTempo, iIndexLast, GlobalNote, GlobalNewNote : INTEGER;
        bNeedSave : boolean;
        Lib, Lib1, MainInstance:THandle;
        Volume  : Longint;
        Midi_ID : WORD;
        lphMidiOut: PHMidiOut;
        szFileName : Pchar ; FileChars : array [0..128] of char;
        DevNm:Pchar; DName : array[0..MaxPNameLen-1] of Char;
        mMid, mPid, MTech, mVoice, mNote, mChM: Word;
        mVers : Word; mSup: Longint;
        lpdwVolume: PLongint;
        Currentvolume   : Word ;


PROCEDURE DummyMeldung (hwindow: Hwnd; STR : STRING; zText1: PChar);

FUNCTION About (Dialog: HWND; Message, WParam: WORD;
                                       LParam: LONGINT): BOOL; export;
PROCEDURE ErrorMessage (HWindow : hwnd; szError : Pchar; szTitleName : PChar);

Procedure DoCaption (Hwindow : HWND; szTitleName : Pchar);

    {---------------------------------------------------------}
    { DrawRectangle                                           }
    {---------------------------------------------------------}

PROCEDURE DrawGrayRectangle (Hwindow : hwnd) ;

PROCEDURE DrawGray1Rectangle (PaintDC: HDC; X, Y : INTEGER);

PROCEDURE DrawGray2Rectangle (PaintDC: HDC; X, Y : INTEGER);

PROCEDURE DrawBlackRectangle (PaintDC: HDC; X, Y : INTEGER);

PROCEDURE DrawWhiteRectangle (PaintDC: HDC; X, Y : INTEGER);

PROCEDURE DrawWhite2Rectangle (PaintDC: HDC; X, Y : INTEGER);

    {---------------------------------------------------------}
    { Piano Information                                       }
    {---------------------------------------------------------}

Procedure GiveInformation (Hwindow: HWND; PlaceX,PlaceY,W,H : Integer; InfoText: Pchar);

Procedure ChangeVelocity (HWindow : HWnd; Velocity :Integer);

Procedure ChangeOctave (HWindow : HWnd; Octave :Integer);

Procedure ChangeVolume (HWindow : HWnd; lpdVolume : PLongInt);



{-------------------------------------------------------------------}

implementation

PROCEDURE DummyMeldung (hwindow: Hwnd; STR : STRING; zText1: PChar);
VAR zText2 : Pchar; S4 : ARRAY [0..20] OF CHAR;
     BEGIN
       NEW (zText2);
       StrPCopy (zText2, STR);
       MessageBox (hWindow, zText1,
       zText2, MB_OK OR MB_ICONINFORMATION);

     END; {DummyMeldung}

FUNCTION About (Dialog: HWND; Message, WParam: WORD;
                  LParam: LONGINT): BOOL;
        BEGIN
          About := TRUE;
          CASE Message OF
            wm_InitDialog:
                            EXIT;
            wm_Command:
                         IF (WParam = ID_OK) OR (WParam = ID_CANCEL) THEN
                         BEGIN
                           EndDialog (Dialog, 1);
                           EXIT;
                         END;
          END;
          About := FALSE;
    END;

    PROCEDURE ErrorMessage (HWindow : hwnd; szError : Pchar; szTitleName : PChar);
     begin
     	wvsprintf (szBuffer, szError, szTitleName) ;

     	MessageBeep (MB_ICONEXCLAMATION) ;
     	MessageBox (hwindow, szBuffer, szAppName, MB_OK or MB_ICONEXCLAMATION) ;
     end;

   Procedure DoCaption (Hwindow : HWND; szTitleName : Pchar);
    var title :Pchar;FileChars : array [0..256] of char;
    begin
     title := @FileChars;
     if StrLen(szTitleName) = 0 then StrLCat (szTitleName, szUntitled, StrLen(szUntitled)+1);
     StrLCopy (Title, WINDOWTITLE,  StrLen (WINDOWTITLE));
     StrLCat (WINDOWTITLE, szTitleName,  StrLen (WINDOWTITLE)+ StrLen (szTitleName));
     SetWindowText (Hwindow , TITLE) ;

    end;

    {---------------------------------------------------------}
    { DrawRectangle                                           }
    {---------------------------------------------------------}

    PROCEDURE DrawGrayRectangle (Hwindow : hwnd) ;
     const
        iBrush: INTEGER = LTGRAY_BRUSH;
        iPen  : Integer  = NULL_Pen;
     var PaintDC : HDC;
     BEGIN
       PaintDC:= GetDC (hwindow) ;
       SelectObject (PaintDC, GetStockObject (iPen));
       SelectObject (Paintdc, GetStockObject (iBrush) ) ;
       RECTANGLE (Paintdc, 0, 0,  640, 32) ;
       ReleaseDC (hwindow, PaintDC) ;
     END;     (* DrawRectangle*)


     PROCEDURE DrawBlackRectangle (PaintDC: HDC; X, Y : INTEGER);
     const
        iBrush: INTEGER = BLACK_BRUSH;

     BEGIN


       SelectObject (Paintdc, GetStockObject (iBrush) ) ;

       If x in [0,1,3,4,5,7,8,10,11,12,14,15, 17,18,19] then
       RECTANGLE (Paintdc, (X *30+21), (20 * Y ) ,
       		  (X*30 + 38) , (40* Y) ) ;



     END;     (* DrawRectangle*)

     PROCEDURE DrawWhiteRectangle (PaintDC: HDC; X, Y : INTEGER);

     const
        iBrush: INTEGER = WHITE_BRUSH;

     BEGIN


       SelectObject (Paintdc, GetStockObject (iBrush) ) ;

       RECTANGLE (Paintdc, (X*30) , (20 * Y) ,
       		  (X*30 + 30) , (60 * Y) ) ;



     END;     (* DrawRectangle*)

     PROCEDURE DrawWhite2Rectangle (PaintDC: HDC; X, Y : INTEGER);

     const
        iBrush: INTEGER = WHITE_BRUSH;
        iPen  : Integer  = NULL_Pen;
     BEGIN

       SelectObject (PaintDC, GetStockObject (iPen));
       SelectObject (Paintdc, GetStockObject (iBrush) ) ;

       RECTANGLE (Paintdc, (X*30) , (40 * Y) ,
       		  (X*30 + 30) , (60 * Y) ) ;



     END;     (* DrawRectangle*)

     PROCEDURE DrawGray2Rectangle (PaintDC: HDC; X, Y : INTEGER);
     const
        iBrush: INTEGER = LTGRAY_BRUSH;
        iPen  : Integer  = NULL_Pen;

     BEGIN

       SelectObject (PaintDC, GetStockObject (iPen));
       SelectObject (Paintdc, GetStockObject (iBrush) ) ;

       RECTANGLE (Paintdc, (X *30), (40 * Y ) ,
       		  (X*30 + 30) , (60* Y) ) ;



     END;     (* DrawRectangle*)

     PROCEDURE DrawGray1Rectangle (PaintDC: HDC; X, Y : INTEGER);
     const
        iBrush: INTEGER = LTGRAY_BRUSH;

     BEGIN
       SelectObject (Paintdc, GetStockObject (iBrush) ) ;

       RECTANGLE (Paintdc, (X *30+21), (30 * Y ) ,
       		  (X*30 + 38) , (40* Y) ) ;
     END;     (* DrawRectangle  *)

    {---------------------------------------------------------}
    { Piano Information                                       }
    {---------------------------------------------------------}

    Procedure GiveInformation (Hwindow: HWND; PlaceX,PlaceY,W,H : Integer; InfoText: Pchar);
    const iBrush: INTEGER = DKGRAY_BRUSH;
    var NewDC : HDC; iPen : THandle;

    begin
      NewDC := GetDC (HWindow);
       SelectObject (NewDC, GetStockObject (iBrush) ) ;
       RECTANGLE (newDC,PlaceX,PlaceY,W,H  ) ;

      SetTextColor (NewDC, RGB (255, 255, 255) ) ;
      SetBkMode (NewDC, TRANSPARENT) ;
      Textout (NewDC,PlaceX+2,PlaceY+2,InfoText,strLen (InfoText));
      ReleaseDC (HWindow, NewDC);
    end;

    Procedure ChangeVelocity (HWindow : HWnd; Velocity :Integer);
    var VelocityTxt : PChar; Intxt : array [0..128] of char;
    begin
      VelocityTxt := @InTxt;
      wvsprintf (VelocityTxt,'Key Velocity (Loudness) = %d' , Velocity);
      GiveInformation  (Hwindow, 180 ,3 , 390 , 28 , VelocityTxt) ;
    end;

    Procedure ChangeOctave (HWindow : HWnd; Octave :Integer);
    var VelocityTxt : PChar; Intxt : array [0..128] of char;
    begin
      VelocityTxt := @InTxt;
      wvsprintf (VelocityTxt,'Octave = %d' , Octave);
      GiveInformation  (Hwindow, 500 ,3 , 620 , 28 , VelocityTxt) ;
    end;


    Procedure ChangeVolume (HWindow : HWnd; lpdVolume : PLongInt);
    var volumeText : PChar; Intxt : array [0..128] of char;
        Leftvol, Rightvol : LongInt;
    begin
      volumeText := @InTxt;
      Leftvol := (HiWord (lpdvolume^) div $100);
      Rightvol := LoWord (lpdvolume^) div $100;
      wvsprintf (volumeText,'Volume = %6d' ,Leftvol);
      GiveInformation  (Hwindow, 390 ,3 , 500 , 28 , volumeText) ;
    end;


end.