UNIT MIDIDrum;

{$F+}

(*------------------------------------------
   MIDIDRUM.Pas by Peter Horn, (c) 1993
  ------------------------------------------*)



INTERFACE

USES WinTypes, WinProcs, WinDos, Objects, OMemory, OWindows, ODialogs,
  Strings, OStdDlgs, MMSystem, MIDInterface, MIDIConst;


CONST
   MIDIDrumVersion = 'v1.0';

   MChunkH = 'MThd'; { Header-Chunk-ID for SMF-Dateien }
   MChunkT = 'MTrk'; { Track-Chunk-ID for SMF-Dateien  }

TYPE
   ChunkName = ARRAY[0..3] OF CHAR; { Array for Chunk-ID           }
   ChunkSize = ARRAY[0..3] OF BYTE; { Array for 32-Bit Chunk-size }
   DeltaType = RECORD
                Data : ARRAY[0..3] OF BYTE; { Array for DeltaTime-Daten    }
                Count: BYTE;
                END;

{ Datatyp for alle necessary informations on a Chunk }

   MIDChunkInfo = RECORD
             ckID   : ChunkName;
             ckSize : ChunkSize;
             END;

{ Datatype for all necessary data for the  Header-Chunk of a  }
{ SFM-File                                                    }
   MIDChunkHeader = RECORD
             ckID   : ChunkName;
             ckSize : ChunkSize;
             Format : WORD;
             Tracks : WORD;
             Divis  : WORD;
             END;

   MIDFileTyp = FILE;

VAR
   MIDErrStat  : WORD;      { Globale Variable fr den Fehlerstatus      }
   MIDFormat   : WORD;      { Globale Variable fr das MIDI-Dateiformat  }
   MIDTracks   : WORD;      { Globale Variable fr die Anzahl der Tracks }
   MIDDivis    : WORD;      { Globale Variable fr die Divisions-Info    }


Function MIDIFileWrite   (DRUMS : PDrum; szFileName: Pchar) : PChar ;


Implementation


VAR
   Regs        : TRegisters;
   MIDFileSize : LongInt;   { internal global variable for file length  }
   MIDGlobSize : LongInt;   { internal global variable for total length }
   MIDLoclSize : LongInt;   { internal global variable for chunck length }
   M           : Text;      { internal global variable for  MIDI-Textdatei }



Function MIDIFileWrite   (DRUMS : PDrum; szFileName: Pchar) : PChar ;
var MIDFile: MIDFileTyp;
    MIdBuffer : array [0..4000] of byte;
    Trackbuffer : array [0..2000] of byte;
    MidBufferPtr : Pointer; header: MIDChunkHeader; CkHeader : MIDChunkInfo;
    i, Position : integer; Tracklength : Longint;

Procedure MIDCalcSize(var MSize : ChunkSize; ChSize: LongInt );

VAR
   Power : REAL;
   i : integer;
   Dummy : LongInt;
   Count : BYTE;

  BEGIN  
     MSize [3] := lo (Loword (Chsize));
     MSize [2] := hi (Loword (Chsize));
     MSize [1] := lo (Hiword (Chsize));
     MSize [0] := hi (Hiword (Chsize));
  end;

Procedure MIDCalcDeltaValue(var Msize: DeltaType; Chsize : LongInt);
VAR
   Power : REAL; i: integer;
   Dummy : LongInt;
   Loop  : BYTE;

BEGIN
   Msize.Data[0] := ChSize mod $7F; Msize.Count := 1;
   for i:= 1 to 3 do Msize.Data[0] := 0;
   If  ChSize > $7F then begin
       Msize.Count := 2;
       ChSize := (ChSize  div $80);
       Msize.Data[1] := ChSize mod $7F;
       If  ChSize > $7F then begin
                Msize.Count := 3;
       		ChSize := (ChSize  div $80);
                Msize.Data[1] := Msize.Data[1] or $80;
       		Msize.Data[2] := ChSize mod $7F;
       		If  ChSize > $7F then begin
                        Msize.Count := 4;
	       		ChSize := (ChSize  div $80);
        	        Msize.Data[2] := Msize.Data[2] or $80;
       			Msize.Data[3] := ChSize or $80;

	        end;
       end;
   end;
   if Msize.count > 1 then begin
     Msize.Data[Msize.count-1] := Msize.Data[Msize.count-1] or $80;
   end;

   Msize.Data[0] := Msize.Data[0] + 1;

   END;


function insertMIDIHeader (CHeader : MIDChunkHeader; var Pos : integer) : integer;
var i : integer;
begin
   for i := 0 to 3 do begin
     MIDBuffer[Pos] := byte(Cheader.ckID [i]);
     Pos := Pos + 1;
   end;
   for i := 0 to 3 do begin
     MIDBuffer[Pos] := byte(Cheader.CkSize [i]);
     Pos := Pos + 1;
   end;
   MIDBuffer [Pos] := hi (Cheader.format); Pos := Pos + 1;
   MIDBuffer [Pos] := lo (Cheader.format); Pos := Pos + 1;
   MIDBuffer [Pos] := hi (Cheader.tracks); Pos := Pos + 1;
   MIDBuffer [Pos] := lo (Cheader.tracks); Pos := Pos + 1;
   MIDBuffer [Pos] := hi (Cheader.divis);  Pos := Pos + 1;
   MIDBuffer [Pos] := lo (Cheader.divis);  Pos := Pos + 1;
   insertMIDIHeader := sizeOf (CHeader);
end;

Procedure insertTrackHeader (CkHeader : MIDChunkInfo; var Pos : Integer);
var i : Integer;
begin
   for i := 0 to 3 do begin
     MIDBuffer[Pos] := byte(Ckheader.ckID [i]);
     Pos := Pos + 1;
   end;
   for i := 0 to 3 do begin
     MIDBuffer[Pos] := byte(Ckheader.CkSize [i]);
     Pos := Pos + 1;
   end;

end;

Procedure InsertMetaEvent (var Tracklength: LongInt; Event : Byte; S:Pchar);
var i : integer;
begin
   Trackbuffer [Tracklength] := 0; Inc (Tracklength);
   Trackbuffer [Tracklength] := $FF; Inc (Tracklength);
   Trackbuffer [Tracklength] := Event; Inc (Tracklength);
   Trackbuffer [Tracklength] := StrLen (S); Inc (Tracklength);
   for i := 0 to  StrLen (S) - 1 do begin
      Trackbuffer [Tracklength] := byte(S^); Inc (Tracklength); Inc (S);
   end;

end;

procedure Delta (x , lastx : integer; var Tracklength : Longint);
var DeltaL : Longint; Msize: DeltaType;  I: integer;
begin
   DeltaL := (x - lastx)* $3B;
   MIDCalcDeltaValue(Msize, DeltaL);
   if (x - lastx) = 0 then Msize.Data[0] := 0;
   for I:= MSize.Count-1 downto 0 do begin

       Trackbuffer [Tracklength] := Msize.Data[i]; Inc (Tracklength);
   end;
end;

procedure getdrum (var Tracklength : Longint; Extended : boolean);
const L : Longint = 1;
var x,y, lastx : Integer; first, hit : boolean; Absolute: Longint;
begin
   first := true; lastx := 0;
   if Extended then begin
     FOR X := 0 TO  31 DO BEGIN
        hit := false;
          FOR Y := 0 TO NUM_PERC - 1 DO BEGIN
             if (drums^.dwSeqExt [y] and (L shl x)  <> 0)
       	     then begin
                hit := true;
   		if first then begin
                 Delta (x, lastx, Tracklength); (* Time intervall *)
                 Trackbuffer [Tracklength] := $99; Inc (Tracklength);
                end
                else begin
                  Delta (x, lastx, Tracklength); (* Time intervall *)
                end;
                (* Note to be played *)
   		Trackbuffer [Tracklength] := y+$23; Inc (Tracklength);
                (* Note Dynamics is always the same *)
   		Trackbuffer [Tracklength] := $40; Inc (Tracklength);

                first := false;

             end;
          end;
          if hit then begin
             Trackbuffer [Tracklength] := $3B; Inc (Tracklength);
             lastx := x;
          end;
          FOR Y := 0 TO NUM_PERC - 1 DO BEGIN
             if (drums^.dwSeqExt [y] and (L shl x)  <> 0)
       	     then begin
                (* Note to be silenced *)
   		Trackbuffer [Tracklength] := y+$23; Inc (Tracklength);
                Trackbuffer [Tracklength] := 0; Inc (Tracklength);
                Trackbuffer [Tracklength] := 0; Inc (Tracklength);
                first := false
             end;

             if hit then lastx := x;
         end;
         if hit then Dec (Tracklength);
     end;  (* for x *)
   end  (* if extended *)
   else (* if not extended *)
   begin
     FOR X := 0 TO  31 DO BEGIN
        hit := false;
          FOR Y := 0 TO NUM_PERC - 1 DO BEGIN
             if (drums^.dwSeqBas [y] and (L shl x)  <> 0)
       	     then begin
                hit := true;
   		if first then begin
                 (*
                 Trackbuffer [Tracklength] := Delta; Inc (Tracklength);
                 *)
                 Delta (x, lastx, Tracklength);
                 Trackbuffer [Tracklength] := $9F; Inc (Tracklength);
                end
                else begin
                  Delta (x, lastx, Tracklength);
                end;
                (* Note to be played *)
   		Trackbuffer [Tracklength] := y+$23; Inc (Tracklength);
                (* Note Dynamics is always the same *)
   		Trackbuffer [Tracklength] := $40; Inc (Tracklength);

                first := false;

             end;
          end;
          if hit then begin
             Trackbuffer [Tracklength] := $3B; Inc (Tracklength);
             lastx := x;
          end;
          FOR Y := 0 TO NUM_PERC - 1 DO BEGIN
             if (drums^.dwSeqBas [y] and (L shl x)  <> 0)
       	     then begin
                (* Note to be silenced *)
   		Trackbuffer [Tracklength] := y+$23; Inc (Tracklength);
                Trackbuffer [Tracklength] := 0; Inc (Tracklength);
                Trackbuffer [Tracklength] := 0; Inc (Tracklength);
                first := false
             end;

         end;
         if hit then Dec (Tracklength);
     end;  (* for x *)
   end  (* if not extended *)
end;

Procedure FillFirstTrack (var Tracklength : Longint);

begin
   InsertMetaEvent (Tracklength, $01, 'DRUM MIDI File');
   InsertMetaEvent (Tracklength, $02, '(c) Peter Horn 1993');
   InsertMetaEvent (Tracklength, $03, 'Drum Track #0');
   InsertMetaEvent (Tracklength, $04, 'Conductor');
   (*  *)
   Trackbuffer [Tracklength] := 0; Inc (Tracklength);
   Trackbuffer [Tracklength] := $FF; Inc (Tracklength);
   Trackbuffer [Tracklength] := $59; Inc (Tracklength);
   Trackbuffer [Tracklength] := $02; Inc (Tracklength);
   Trackbuffer [Tracklength] := $00; Inc (Tracklength);
   Trackbuffer [Tracklength] := $00; Inc (Tracklength);
   (* *)
   Trackbuffer [Tracklength] := 0; Inc (Tracklength);
   Trackbuffer [Tracklength] := $FF; Inc (Tracklength);
   Trackbuffer [Tracklength] := $21; Inc (Tracklength);
   Trackbuffer [Tracklength] := $02; Inc (Tracklength);
   Trackbuffer [Tracklength] := $00; Inc (Tracklength);
   Trackbuffer [Tracklength] := $00; Inc (Tracklength);

   (* Time Signature: 4/4 one Metronome Click every quarter note*)
   Trackbuffer [Tracklength] := 0; Inc (Tracklength);
   Trackbuffer [Tracklength] := $FF; Inc (Tracklength);
   Trackbuffer [Tracklength] := $58; Inc (Tracklength);
   Trackbuffer [Tracklength] := $04; Inc (Tracklength);
   Trackbuffer [Tracklength] := $04; Inc (Tracklength);
   Trackbuffer [Tracklength] := $02; Inc (Tracklength);
   Trackbuffer [Tracklength] := $18; Inc (Tracklength);
   Trackbuffer [Tracklength] := $08; Inc (Tracklength);

   (* Tempo*)
   Trackbuffer [Tracklength] := 0; Inc (Tracklength);
   Trackbuffer [Tracklength] := $FF; Inc (Tracklength);
   Trackbuffer [Tracklength] := $51; Inc (Tracklength);
   Trackbuffer [Tracklength] := $03; Inc (Tracklength);
   Trackbuffer [Tracklength] := $07; Inc (Tracklength);
   Trackbuffer [Tracklength] := $A1; Inc (Tracklength);
   Trackbuffer [Tracklength] := $20; Inc (Tracklength);


   (*End of track*)
   Trackbuffer [Tracklength] := 0; Inc (Tracklength);
   Trackbuffer [Tracklength] := $FF; Inc (Tracklength);
   Trackbuffer [Tracklength] := $2F; Inc (Tracklength);
   Trackbuffer [Tracklength] := 0; Inc (Tracklength);

end;

Procedure FillSecondTrack (var Tracklength : Longint);
begin
   InsertMetaEvent (Tracklength, $03, 'Drum Track #1');
   InsertMetaEvent (Tracklength, $04, 'RhythmSection');
   (* Program Change *)
   Trackbuffer [Tracklength] := 0; Inc (Tracklength);
   Trackbuffer [Tracklength] := $FF; Inc (Tracklength);
   Trackbuffer [Tracklength] := $21; Inc (Tracklength);
   Trackbuffer [Tracklength] := $01; Inc (Tracklength);
   Trackbuffer [Tracklength] := $00; Inc (Tracklength);
   Trackbuffer [Tracklength] := $00; Inc (Tracklength);
   Trackbuffer [Tracklength] := $C9; Inc (Tracklength);
   Trackbuffer [Tracklength] := $00; Inc (Tracklength);
   getdrum (Tracklength, true);
   Trackbuffer [Tracklength] := 0; Inc (Tracklength);
   Trackbuffer [Tracklength] := $FF; Inc (Tracklength);
   Trackbuffer [Tracklength] := $2F; Inc (Tracklength);
   Trackbuffer [Tracklength] := 0; Inc (Tracklength);
end;

Procedure FillThirdTrack (var Tracklength : Longint);
begin
   InsertMetaEvent (Tracklength, $03, 'Drum Track #2');
   InsertMetaEvent (Tracklength, $04, 'Melody RhythmSection');

   (* Program Change  to Channel 16 Patch One*)
   Trackbuffer [Tracklength] := 0; Inc (Tracklength);
   Trackbuffer [Tracklength] := $FF; Inc (Tracklength);
   Trackbuffer [Tracklength] := $21; Inc (Tracklength);
   Trackbuffer [Tracklength] := $01; Inc (Tracklength);
   Trackbuffer [Tracklength] := $00; Inc (Tracklength);
   Trackbuffer [Tracklength] := $00; Inc (Tracklength);
   Trackbuffer [Tracklength] := $CF; Inc (Tracklength);
   Trackbuffer [Tracklength] := 116; Inc (Tracklength);
   getdrum (Tracklength, false);
   Trackbuffer [Tracklength] := 0; Inc (Tracklength);
   Trackbuffer [Tracklength] := $FF; Inc (Tracklength);
   Trackbuffer [Tracklength] := $2F; Inc (Tracklength);
   Trackbuffer [Tracklength] := 0; Inc (Tracklength);
end;

begin  {MIDIFileWrite}
   MIDFileSize  := 0;
   MidBufferPtr := @Midbuffer;
   Assign(MIDFile,szFileName);
   Rewrite(MIDFile,1);
   Position := 0;

   (* Do the HeaderChunk *)

   header.ckID := MChunkH;
   MIDCalcSize(header.CkSize, 6 );
   header.format := 1;
   header.tracks := 3;
   header.divis  := 120;
   MIDFileSize := MIDFileSize + insertMIDIHeader (Header,Position);

   (* Do the First TrackChunk *)

   Tracklength := 0;
   CkHeader.ckID := MChunkT;
   FillFirstTrack (Tracklength);
   MIDCalcSize(Ckheader.CkSize, Tracklength);
   insertTrackHeader (CkHeader,Position);

   for i := 0 to Tracklength - 1 do begin
      MIdBuffer[Position] := Trackbuffer [i]; Position := Position + 1;
   end;
   MIDFileSize := Position;

   (* Do the Second TrackChunk *)
   Tracklength := 0;
   CkHeader.ckID := MChunkT;
   FillSecondTrack (Tracklength);
   MIDCalcSize(Ckheader.CkSize, Tracklength);
   insertTrackHeader (CkHeader,Position);

   for i := 0 to Tracklength - 1 do begin
      MIdBuffer[Position] := Trackbuffer [i]; Position := Position + 1;
   end;
   MIDFileSize := Position;

   (* Do the Third TrackChunk *)
   Tracklength := 0;
   CkHeader.ckID := MChunkT;
   FillThirdTrack (Tracklength);
   MIDCalcSize(Ckheader.CkSize, Tracklength);
   insertTrackHeader (CkHeader,Position);

   for i := 0 to Tracklength - 1 do begin
      MIdBuffer[Position] := Trackbuffer [i]; Position := Position + 1;
   end;
   MIDFileSize := Position;

   Blockwrite (MIDFile, MIdBuffer, MIDFilesize);
   close ( MIDFile);
end;  {MIDIFileWrite}

end.