unit MidiIDS;

interface

const


  cm_NewMIDI       = 100;
  cm_OpenMIDIFile  = 101;
  cm_SaveMIDI      = 102;
  cm_Save_As       = 103;

  cm_Merge         = 104;
  cm_Import        = 105;
  cm_ImportSysEx   = 108;

  cm_PianoPlay     = 110;
  cm_PianoRecord   = 111;
  cm_PianoPlayRecord = 112;
  cm_Backing       = 113;

  cm_newdrum       = 114;
  cm_OPENDrum      = 115;
  cm_Close         = 116;
  cm_SAVEDrum      = 117;
  cm_SAVEAsMIDI    = 118;

  cm_Print         = 120;
  cm_Pagesetup     = 121;
  cm_Printersetup  = 122;
  cm_ExitMIDIMusic = 199;

  cm_Undo          = 200;

  cm_Cut           = 201;
  cm_Copy          = 202;
  cm_Paste         = 203;

  cm_Clear         = 204;
  cm_Delete        = 205;


  cm_StartMIDI     = 207;
  cm_EndMIDI       = 208;
  cm_Running       = 209;
  cm_STOPPED       = 210;



cm_MetronomeBeeps    = 221;
cm_TimeSignature     = 222;
cm_Pitch             = 226;
cm_Volume            = 227;
cm_Octave            = 228;
cm_Velocity          = 229;
cm_Channel           = 220;

  cm_mixer         = 231;

  cm_ChangeChannel = 232;
  cm_ClearSection  = 233;
  cm_FilterEvents  = 234;
  cm_FilterChannel = 235;
  cm_Information   = 236;
  cm_MergeTrack    = 237;
  cm_Quantize      = 238;
  cm_Replicate     = 239;
  cm_Split         = 240;
  cm_Transpose     = 241;
  cm_Transform     = 242;

  cm_Thru          = 243;
  cm_RecordFilter  = 244;
  cm_Metronome     = 245;
  cm_Reset         = 246;
  cm_AutoReset     = 247;

  cm_SystemExclusive=248;
  cm_SysExCustomize= 249;

  cm_Advanced       =250;
  cm_Configure      =251;

  cm_Timebase       =252;
  cm_SongKey        =253;
  cm_GeneralMIDI    =254;

  cm_EventList      =255;
  cm_PianoRoll      =256;
  cm_AuditionPatches=257;

  cm_NextWindow     =258;
  cm_PreviousWindow =259;

  cm_ROLPitchWheel  =260;

  cm_ROLSavePatches =261;




	       {POPUP "&Piano" }

cm_AcousticGrandPiano = 300;
cm_BrightAcousticPiano= 301;
cm_ElectricGrandPiano = 302;
cm_HonkytonkPiano     = 303;
cm_RhodesPiano        = 304;
cm_ChorusedPiano      = 305;
cm_Harpsichord        = 306;
cm_Clavinet           = 307;


		{POPUP "&Chromatic Percussion"}

cm_Celesta            = 308;
cm_Glockenspiel       = 309;
cm_Musicbox           = 310;
cm_Vibraphone         = 311;
cm_Marimba            = 312;
cm_Xylophone          = 313;
cm_TubularBells       = 314;
cm_Dulcimer           = 315;


		{POPUP "&Organ"}

cm_HammondOrgan       = 316;
cm_PercussiveOrgan   = 317;
cm_RockOrgan         = 318;
cm_ChurchOrgan        = 319;
cm_ReedOrgan          = 320;
cm_Accordion          = 321;
cm_Harmonica          = 322;
cm_TangoAccordian     = 323;


		{POPUP "&Guitar"}

cm_NylonAcousticGuitar= 324;
cm_SteelAcousticGuitar= 325;
cm_JazzElectricGuitar = 326;
cm_CleanElectricGuitar= 327;
cm_MutedElectricGuitar= 328;
cm_OverdrivenGuitar   = 329;
cm_DistortionGuitar   = 330;
cm_GuitarHarmonics    = 331;


		{POPUP "&Bass"}

cm_AcousticBass       = 332;
cm_ElectricBass       = 333;
cm_ElectricPickBass   = 334;
cm_FretlessBass       = 335;
cm_SlapBass1          = 336;
cm_SlapBass2          = 337;
cm_SynthBass1         = 338;
cm_SynthBass2         = 339;


		{POPUP "&Strings"}

cm_Violin             = 340;
cm_Viola              = 341;
cm_Cello              = 342;
cm_Contrabass         = 343;
cm_TremoloStrings     = 344;
cm_PizzicatoStrings   = 345;
cm_OrchestralHarp     = 346;
cm_Timpani            = 347;

		{POPUP "&Ensemble"}

cm_StringEns1         = 348;
cm_StringEns2         = 349;
cm_SynthStr1          = 350;
cm_SynthStr2          = 351;
cm_ChoirAahs          = 352;
cm_VoiceOohs          = 353;
cm_SynthVoice         = 354;
cm_OrchestraHit       = 355;


		{POPUP "&Brass"}
cm_Trumpet            = 356;
cm_Trombone           = 357;
cm_Tuba               = 358;
cm_MutedTrumpet       = 359;
cm_FrenchHorn        = 360;
cm_BrassSection      = 361;
cm_SynthBrass1        = 362;
cm_SynthBrass2        = 363;

		{POPUP "&Reed"}

cm_SopranoSax         = 364;
cm_AltoSax            = 365;
cm_TenorSax           = 366;
cm_BaritoneSax        = 367;
cm_Oboe               = 368;
cm_EnglishHorn        = 369;
cm_Bassoon            = 370;
cm_Clarinet           = 371;


		{POPUP "&Pipe"}

cm_Piccolo            = 372;
cm_Flute              = 373;
cm_Recorder           = 374;
cm_PanFlute          = 375;
cm_BottleBlow        = 376;
cm_Shakuhachi         = 377;
cm_Whistle            = 378;
cm_Ocarina            = 379;


		{POPUP "&Synth Lead"}

cm_Leadsquare         = 380;
cm_Leadsawtooth       = 381;
cm_Leadcaliope        = 382;
cm_Leadchiff          = 383;
cm_Leadcharang        = 384;
cm_Leadvoice          = 385;
cm_Leadfifths         = 386;
cm_Leadbrass          = 387;


		{POPUP "&Synth Pad"}

cm_Pad1              = 388;
cm_Pad2              = 389;
cm_Pad3              = 390;
cm_Pad4              = 391;
cm_Pad5              = 392;
cm_Pad6              = 393;
cm_Pad7              = 394;
cm_Pad8              = 395;


		{POPUP "&Synth Effects" }

cm_FX1               = 396;
cm_FX2               = 397;
cm_FX3               = 398;
cm_FX4               = 399;
cm_FX5               = 400;
cm_FX6               = 401;
cm_FX7               = 402;
cm_FX8               = 403;


		{POPUP "&Ethnic"}

cm_Sitar             = 404;
cm_Banjo             = 405;
cm_Shamisen          = 406;
cm_Koto              = 407;
cm_Kalimba           = 408;
cm_Bagpipe           = 409;
cm_Fiddle            = 410;
cm_Shanai            = 411;


		{ "&Percussive"}

cm_TinkleBell       = 412;
cm_Agogo             = 413;
cm_SteelDrums       = 414;
cm_Woodblock         = 415;
cm_TaikoDrum        = 416;
cm_MelodicTom       = 417;
cm_SynthDrum        = 418;
cm_ReverseCymbal    = 419;


		{POPUP "&Sound Effects" }

cm_GuitarFretNoise   = 420;
cm_BreathNoise       = 421;
cm_Seashore          = 422;
cm_BirdTweet         = 423;
cm_TelephoneRing     = 424;
cm_Helicopter        = 425;
cm_Applause          = 426;
cm_Gunshot           = 427;

{	POPUP "Notes" }
cm_Whole             = 601;
cm_Half              = 602;
cm_Quarter           = 603;
cm_Eigth             = 604;
cm_Sixteenth         = 605;
cm_Thirtysecond      = 606;
cm_Dotted            = 607;
cm_Triplets          = 608;

{	POPUP "Rest" }
cm_RestWhole         = 611;
cm_RestHalf          = 612;
cm_RestQuarter       = 613;
cm_RestEigth         = 614;
cm_RestSixteenth     = 615;
cm_RestThirtysecond  = 616;
cm_RestDotted        = 617;
cm_RestTriplets      = 618;
cm_StaffSoprano      = 620;
cm_StaffBass         = 621;
cm_StaffDrum         = 622;

cm_Fullpage          = 700;
cm_HalfPage          = 701;
cm_QuarterPage       = 702;

cm_OneChannel        = 703;
cm_SelectedChannels  = 704;
cm_AllChannels       = 705;
cm_CombineChannels   = 706;

  cm_Cascade       = 805;
  cm_Tile          = 806;

  cm_Notation      = 801;
  cm_Piano         = 802;
  cm_MIDITrack     = 803;
  cm_DRUM          = 804;



  cm_help          = 901;
  cm_help_piano    = 902;
  cm_help_drum     = 903;
  cm_help_list     = 904;
  cm_help_notes    = 905;
  cm_help_pianoroll = 906;
  cm_help_listedit  = 907;
  cm_helphelp       = 909;
  cm_quickHelp      = 910;
  cm_indexHelp      = 911;
  cm_KeyboardHelp   = 912;
  cm_midiHelp       = 913;
  cm_drum_fileHelp  = 914;
  cm_Install_Board  = 920;

  cm_AboutList      = 997;
  cm_AboutDrum      = 998;
  cm_AboutPiano     = 996;
  cm_AboutNotes     = 995;
  cm_About          = 999;


   {Eventlist Ids}
cm_EventEdit     = 1103;
cm_EventInsert   = 1101;
cm_EventDelete   = 1102;
cm_full          = 1151;
cm_Minim         = 1152;
cm_QuarterNote   = 1154;
cm_eigthNote     = 1158;
cm_sixteenthNote = 1166;
cm_thirtiethNote = 1182;
cm_sixtyfourNote = 1214;


    {Identifiers IDs}

  id_Helpbutton = 415;

 {EventList Insert}
id_NoteOn        =3000;
id_KeyPressure   =3001;
id_ControlChange =3002;
id_ProgramChange =3003;
id_ChannelAfterTouch=3004;
id_PitchWheel    =3005;
id_TempoChange   =3006;
id_TimeSignature =3007;
id_TextEvent     =3008;
id_SystemEx      =3009;



  (*Scrollbars*)
  id_Horizontal = 801;
  id_Vertical   = 802;

  (*Dialog ids in OStdDialogs*)
  sd_FileSave   = 32516;
  sd_FileOpen   = 32515;

  {Windows Identifiers }

  {Identifiers for the note patterns for the Palette}
  id_full     = 401;
  id_Minim    = 402;
  id_Quarter  = 403;
  id_eigth    = 404;
  id_sixteenth= 405;
  id_thirtieth= 406;
  id_fastforward = 407;
  id_help        = 408;
  id_playbutton  = 409;
  id_RecordButton= 410;
  id_RewindButton= 411;
  id_Stopbutton  = 412;
  id_PianoRoll   = 413;
  id_ListEdit    = 414;

 id_LB0        = 590;
 Id_Name       = 591;
 Id_Instrument = 592;
 Id_Channel    = 593;
 Id_Pitch      = 594;
 Id_Beats      = 595;
 Id_Events     = 596;
 Id_Port       = 597;

  implementation

  end.